/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.dtus;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.Context;
import com.sun.ut.console.I18N;
import com.sun.ut.console.SelectHelper;
import com.sun.ut.console.dtus.DesktopUnitHelper;
import com.sun.ut.console.dtus.SearchCriteria;
import com.sun.ut.console.server.ServerHelper;
import com.sun.ut.service.ServiceException;
import com.sun.web.ui.component.TableRowGroup;
import java.util.List;

public class DesktopUnitsHandler
extends BaseHandler {
    private TableDataProvider allDtusProvider;
    private List dtusList;
    private SelectHelper selectHelper = new SelectHelper("#{dtuRowGroup.tableRow}");
    private TableRowGroup tableRowGroup;
    private SearchCriteria searchCriteria = DesktopUnitHelper.getSearchCriteria();
    private String serverName = (String)Context.getSessionAttribute("selectedServer");

    public DesktopUnitsHandler() {
        this.getDtus();
    }

    public TableDataProvider getDtus() {
        if (this.allDtusProvider == null) {
            DesktopUnitHelper.getSearchCriteria().setFilter("all");
            DesktopUnitHelper.getSearchCriteria().setSearchString("*");
            try {
                this.dtusList = this.getProvider().searchDTUs("*");
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error(se);
            }
            this.allDtusProvider = new ObjectListDataProvider(this.dtusList);
        }
        return this.allDtusProvider;
    }

    public TableRowGroup getTableRowGroup() {
        return this.tableRowGroup;
    }

    public void setTableRowGroup(TableRowGroup tableRowGroup) {
        this.tableRowGroup = tableRowGroup;
    }

    public SelectHelper getSelectHelper() {
        return this.selectHelper;
    }

    public String viewProperties() {
        DesktopUnitHelper.setSelectedId(Context.getRequestParameter("id"));
        return "viewDesktopUnitDetails";
    }

    public String viewServer() {
        String server = Context.getRequestParameter("server_id");
        if (server != null) {
            ServerHelper.setSelectedId(server);
        }
        return "viewServerDetails";
    }

    public String getServerName() {
        return this.serverName;
    }

    public String delete() {
        RowKey[] rowKeys = this.getTableRowGroup().getRenderedSelectedRowKeys();
        if (rowKeys == null) {
            return "success";
        }
        for (int i = 0; i < rowKeys.length; ++i) {
            RowKey rowKey = rowKeys[i];
            String dtuId = (String)this.getDtus().getValue(this.getDtus().getFieldKey("id"), rowKey);
            try {
                Object[] args = new Object[]{dtuId};
                this.getProvider().deleteDTU(dtuId);
                this.getAuditService().publishEvent("Desktop", "dtu_removed", args, 0);
                continue;
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error(se);
                return "success";
            }
        }
        this.allDtusProvider = null;
        this.getSelectHelper().clear();
        this.getStatusMessage().info("alert_stored_changes", "dtu_delete");
        return "success";
    }

    public boolean isSelectable() {
        return DesktopUnitHelper.getSearchCriteria().getFilter().equals("all");
    }

    public boolean isCurrentDTUs() {
        return DesktopUnitHelper.getSearchCriteria().getFilter().equals("current");
    }

    public boolean isMultiheadGroups() {
        return DesktopUnitHelper.getSearchCriteria().getFilter().equals("multiheads");
    }

    public String getTitle() {
        String filter = DesktopUnitHelper.getSearchCriteria().getFilter();
        if (filter.equals("all")) {
            return I18N.getResource("dtu_title_all");
        }
        if (filter.equals("current")) {
            return I18N.getResource("dtu_title_current");
        }
        if (filter.equals("multiheads")) {
            return I18N.getResource("dtu_title_multihead");
        }
        if (filter.equals("readers")) {
            return I18N.getResource("dtu_title_token_readers");
        }
        return I18N.getResource("dtu_title_all");
    }

    protected void filter(List list) {
    }

    public SearchCriteria getSearchCriteria() {
        return this.searchCriteria;
    }

    public String search() {
        SearchCriteria search = (SearchCriteria)Context.getSessionAttribute("dtuSearchCriteria");
        if (search == null) {
            search = new SearchCriteria();
            Context.setSessionAttribute("dtuSearchCriteria", search);
        }
        search.setFilter(this.searchCriteria.getFilter());
        search.setSearchString(this.searchCriteria.getSearchString());
        return "viewDtuSearchResults";
    }

    public List getDtusList() {
        return this.dtusList;
    }

    public void setDtusList(List newDtusList) {
        this.dtusList = newDtusList;
    }
}

