/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.dtus;

import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.I18N;
import com.sun.ut.console.dtus.DesktopUnitHelper;
import com.sun.ut.service.ServiceException;

public class NewDesktopUnit
extends BaseHandler {
    private String id;
    private String location;
    private String description;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        DesktopUnitHelper.setSelectedId(null);
        return this.id;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String save() {
        if (this.location == null) {
            this.location = "";
        }
        if (this.description == null) {
            this.description = "";
        }
        try {
            Object[] args = new String[]{this.id, this.location, this.description};
            this.getProvider().addDTU(this.id, this.location, this.description);
            this.getAuditService().publishEvent("Desktop", "dtu_added", args, 0);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            Object[] args = new String[]{this.id};
            this.getStatusMessage().error(I18N.getResource("dtu_alert_add", args), se, true);
            return "newDesktopUnit";
        }
        DesktopUnitHelper.setSelectedId(null);
        this.getStatusMessage().info("alert_stored_changes", "dtu_add", true);
        return "viewDesktopUnits";
    }
}

