/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.server;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.Context;
import com.sun.ut.console.I18N;
import com.sun.ut.console.SelectHelper;
import com.sun.ut.console.server.DiskSpaceInfo;
import com.sun.ut.console.server.RestartServicesTask;
import com.sun.ut.console.server.ServerHelper;
import com.sun.ut.service.Host;
import com.sun.ut.service.ServiceException;
import com.sun.web.ui.component.TableRowGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ServersHandler
extends BaseHandler {
    public static final String ALL_SERVERS = "AllServers";
    public static final String SERVERS_RESTARTING = "ServersRestarting";
    private TableRowGroup tableRowGroup;
    private ObjectListDataProvider dataProvider;
    private SelectHelper selectHelper = new SelectHelper("#{server.tableRow}");
    private boolean operationInProgress;

    public ServersHandler() {
        this.getServerList();
    }

    public ObjectListDataProvider getServerList() {
        this.dataProvider = (ObjectListDataProvider)Context.getSessionAttribute(ALL_SERVERS);
        if (this.dataProvider == null) {
            List hosts = new ArrayList();
            try {
                hosts = this.getProvider().getHosts();
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error(se);
            }
            this.dataProvider = new ObjectListDataProvider(hosts);
        }
        return this.dataProvider;
    }

    public TableRowGroup getTableRowGroup() {
        return this.tableRowGroup;
    }

    public void setTableRowGroup(TableRowGroup tableRowGroup) {
        this.tableRowGroup = tableRowGroup;
    }

    public SelectHelper getSelectHelper() {
        return this.selectHelper;
    }

    public String viewProperties() {
        ServerHelper.setSelectedId(Context.getRequestParameter("id"));
        return "viewServerDetails";
    }

    protected void restart(boolean isColdRestart) {
        RowKey[] rowKeys = this.getTableRowGroup().getRenderedSelectedRowKeys();
        ObjectListDataProvider serverList = this.getServerList();
        Context.setSessionAttribute(ALL_SERVERS, serverList);
        ArrayList<Host> serversRestarting = new ArrayList<Host>();
        for (int i = 0; i < rowKeys.length; ++i) {
            RowKey rowKey = rowKeys[i];
            Host host = (Host)serverList.getObject(rowKey);
            RestartServicesTask task = new RestartServicesTask(this.getAdminContext(), host, isColdRestart);
            host.setRestartStatus("restarting");
            if (isColdRestart) {
                host.setLastRestartType("cold_restart");
            } else {
                host.setLastRestartType("warm_restart");
            }
            serversRestarting.add(host);
            this.cacheServerDetails(host);
            task.start();
        }
        Context.setSessionAttribute(SERVERS_RESTARTING, serversRestarting);
        this.getSelectHelper().clear();
    }

    public String warmRestart() {
        this.getNotification().setRestartRequired(false);
        this.restart(false);
        return "success";
    }

    public String coldRestart() {
        this.getNotification().setColdRestartRequired(false);
        this.restart(true);
        return "success";
    }

    public boolean isRestartInProgress() {
        boolean restartInProgress = false;
        ArrayList serversRestarting = (ArrayList)Context.getSessionAttribute(SERVERS_RESTARTING);
        if (serversRestarting == null) {
            restartInProgress = false;
        } else if (this.isServersRestarting(serversRestarting)) {
            restartInProgress = true;
        } else {
            Object[] auditArgs;
            ArrayList restarted = this.getRestartedServers(serversRestarting, false);
            ArrayList failed = this.getRestartedServers(serversRestarting, true);
            String restartedList = this.getServerNamesList(restarted);
            String failedList = this.getServerNamesList(failed);
            String statusRestartType = I18N.getResource("servers_table_warm_restart_button");
            String auditRestartType = this.getAuditService().getMessage("restart_warm");
            if (this.isColdRestart(serversRestarting)) {
                auditRestartType = this.getAuditService().getMessage("restart_cold");
                statusRestartType = I18N.getResource("servers_table_cold_restart_button");
            }
            if (restarted.size() > 0) {
                auditArgs = new String[]{auditRestartType, restartedList};
                this.getAuditService().publishEvent("servers_restart", auditArgs);
            }
            if (failed.size() > 0) {
                auditArgs = new String[]{auditRestartType, failedList};
                this.getAuditService().publishEvent("servers_restart_failed", auditArgs);
                this.getStatusMessage().error("server_restart_failed_alert", failedList);
            } else {
                Object[] statusArgs = new String[]{statusRestartType};
                this.getStatusMessage().info("server_restart_done", I18N.getResource("restart_success", statusArgs));
            }
            Context.setSessionAttribute(SERVERS_RESTARTING, null);
            Context.setSessionAttribute(ALL_SERVERS, null);
            Context.setSessionAttribute("CachedData", null);
            this.dataProvider = null;
            restartInProgress = false;
        }
        return restartInProgress;
    }

    public String getWarmRestartOnClick() {
        return "javascript: if (confirmSelectedRowsForWarmRestart(\"" + I18N.getResource("server_restart_warm_popup") + "\" ) == false) return false";
    }

    public String getColdRestartOnClick() {
        return "javascript: if (confirmSelectedRowsForColdRestart(\"" + I18N.getResource("server_restart_cold_popup") + "\" ) == false) return false";
    }

    private ArrayList getRestartedServers(ArrayList servers, boolean failed) {
        String status = "restart_done";
        if (failed) {
            status = "restart_failed";
        }
        ArrayList<Host> list = new ArrayList<Host>();
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Host server = (Host)servers.get(i);
                if (server.getRestartStatus() == null || !server.getRestartStatus().equals(status)) continue;
                list.add(server);
            }
        }
        return list;
    }

    private boolean isServersRestarting(ArrayList servers) {
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Host server = (Host)servers.get(i);
                if (server.getRestartStatus() == null || !server.getRestartStatus().equals("restarting")) continue;
                return true;
            }
        }
        return false;
    }

    private String getServerNamesList(ArrayList servers) {
        String list = "[";
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Host server = (Host)servers.get(i);
                list = list + server.getName();
                if (servers.size() == 1 || i == servers.size() - 1) continue;
                list = list + ", ";
            }
        }
        list = list + "]";
        return list;
    }

    private boolean isColdRestart(ArrayList servers) {
        boolean isColdRestart = true;
        Host server = (Host)servers.get(servers.size() - 1);
        if (server.getLastRestartType().equals("warm_restart")) {
            isColdRestart = false;
        }
        return isColdRestart;
    }

    private void cacheServerDetails(Host host) {
        HashMap cachedData = (HashMap)Context.getSessionAttribute("CachedData");
        if (cachedData == null) {
            cachedData = new HashMap();
        }
        HashMap<String, Number> cachedServer = new HashMap<String, Number>();
        int totalUserSessions = 0;
        int totalDisconnectedUserSessions = 0;
        int totalGreeterSessions = 0;
        int totalDisconnectedGreeterSessions = 0;
        int totalDtus = this.getProvider().getCurrentDTUsNumber(host.getName());
        try {
            int[] sessions = this.getProvider().getSessionNumbers(host.getName());
            if (sessions != null) {
                totalUserSessions = sessions[0];
                totalDisconnectedUserSessions = sessions[1];
                totalGreeterSessions = sessions[2];
                totalDisconnectedGreeterSessions = sessions[3];
            }
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
        }
        ArrayList<DiskSpaceInfo> list = new ArrayList<DiskSpaceInfo>();
        try {
            long[] info = this.getProvider().getDiskSpace("/");
            list.add(new DiskSpaceInfo(I18N.getResource("serverDetails_root"), info[2], info[1], info[0]));
            info = this.getProvider().getDiskSpace("/tmp");
            list.add(new DiskSpaceInfo(I18N.getResource("serverDetails_tmp"), info[2], info[1], info[0]));
            info = this.getProvider().getSwapSpace();
            list.add(new DiskSpaceInfo(I18N.getResource("serverDetails_swap"), info[2], info[1], info[0]));
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
        }
        ObjectListDataProvider diskSpaceProvider = new ObjectListDataProvider(list);
        cachedServer.put("TotalDtus", new Integer(totalDtus));
        cachedServer.put("TotalUserSessions", new Integer(totalUserSessions));
        cachedServer.put("TotalDisconnectedUserSessions", new Integer(totalDisconnectedUserSessions));
        cachedServer.put("TotalGreeterSessions", new Integer(totalGreeterSessions));
        cachedServer.put("TotalDisconnectedGreeterSessions", new Integer(totalDisconnectedGreeterSessions));
        cachedServer.put("DiskSpaceProvider", (Number)diskSpaceProvider);
        cachedServer.put("RestartTime", new Long(System.currentTimeMillis()));
        cachedData.put(host.getName(), cachedServer);
        Context.setSessionAttribute("CachedData", cachedData);
    }
}

