/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.tokens;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.Context;
import com.sun.ut.console.I18N;
import com.sun.ut.console.RawTokenWrapper;
import com.sun.ut.console.SelectHelper;
import com.sun.ut.console.tokens.SearchCriteria;
import com.sun.ut.console.tokens.TokenHelper;
import com.sun.ut.service.LogicalToken;
import com.sun.ut.service.RawToken;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.User;
import com.sun.web.ui.component.TableRowGroup;
import com.sun.web.ui.model.Option;
import com.sun.web.ui.model.OptionTitle;
import java.util.ArrayList;
import java.util.List;

public class TokensHandler
extends BaseHandler {
    public static final String SESSTYPE_DEFAULT = "default";
    public static final String SESSTYPE_KIOSK = "kiosk";
    public static final String SESSTYPE_REGULAR = "regular";
    private Option[] sessionActionsOptions = new Option[]{new OptionTitle(I18N.getResource("tokens_session_type_actions")), new Option((Object)"default", I18N.getResource("tokens_set_default")), new Option((Object)"kiosk", I18N.getResource("tokens_set_kiosk")), new Option((Object)"regular", I18N.getResource("tokens_set_regular"))};
    private String sessionType = "";
    private List registeredUsers;
    private List registeredTokens;
    private List currentTokens;
    private boolean needConfirmation = false;
    private TableRowGroup tableRowGroup;
    private SelectHelper selectHelper = new SelectHelper("#{tokensRowGroup.tableRow}");
    private SearchCriteria searchCriteria = new SearchCriteria();
    private boolean checkedKioskInstalled;
    private boolean isKioskInstalled;

    public TokensHandler() {
        String filter = TokenHelper.getSearchCriteria().getFilter();
        if (filter.equals("registered")) {
            this.getRegisteredTokens();
        } else {
            this.getCurrentTokens();
        }
    }

    public ObjectListDataProvider getRegisteredTokens() {
        if (this.registeredTokens == null) {
            try {
                this.registeredUsers = this.getProvider().searchUsers("*");
                this.registeredTokens = new ArrayList();
                ArrayList<String> aliasUsers = new ArrayList<String>();
                for (int i = 0; i < this.registeredUsers.size(); ++i) {
                    User user = (User)this.registeredUsers.get(i);
                    List logicalTokens = user.getLogicalTokens();
                    if (logicalTokens == null) continue;
                    for (int j = 0; j < logicalTokens.size(); ++j) {
                        LogicalToken logicalToken = (LogicalToken)logicalTokens.get(j);
                        List rawTokens = logicalToken.getRawTokens();
                        if (rawTokens == null) continue;
                        String username = user.getUserName();
                        if (rawTokens.size() > 1) {
                            int n = 1;
                            do {
                                String index = Integer.toString(n);
                                username = user.getUserName() + "[" + index + "]";
                                ++n;
                            } while (aliasUsers.contains(username));
                            aliasUsers.add(username);
                        }
                        for (int k = 0; k < rawTokens.size(); ++k) {
                            RawToken rawToken = (RawToken)rawTokens.get(k);
                            rawToken.setOwner(username);
                            rawToken.setDescription(user.getDescription());
                            rawToken.setSessionType(logicalToken.getSessionType());
                            this.registeredTokens.add(new RawTokenWrapper(rawToken));
                        }
                    }
                }
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("tokens_alert_get", se);
            }
        }
        this.filter(this.registeredTokens);
        return new ObjectListDataProvider(this.registeredTokens);
    }

    public void setRegisteredTokensList(List newRegisteredTokens) {
        this.registeredTokens = newRegisteredTokens;
    }

    public TableDataProvider getCurrentTokens() {
        if (this.currentTokens == null) {
            try {
                this.currentTokens = new ArrayList();
                List unfilteredTokens = this.getProvider().getCurrentTokens();
                for (int i = 0; i < unfilteredTokens.size(); ++i) {
                    RawToken rawToken = (RawToken)unfilteredTokens.get(i);
                    if (rawToken.getId() == null || rawToken.getId().length() <= 0) continue;
                    this.currentTokens.add(rawToken);
                }
                this.filter(this.currentTokens);
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("tokens_alert_get", se);
            }
        }
        return new ObjectListDataProvider(this.currentTokens);
    }

    public void setCurrentTokensList(List newCurrentTokens) {
        this.currentTokens = newCurrentTokens;
    }

    public String selectToken() {
        String selectedTokenId = Context.getRequestParameter("selectedTokenId");
        Context.setSessionAttribute("selectedTokenId", selectedTokenId);
        String selectedUserId = null;
        for (int i = 0; i < this.getRegisteredTokensList().size(); ++i) {
            RawToken rawToken = (RawToken)this.getRegisteredTokensList().get(i);
            if (!selectedTokenId.equals(rawToken.getId())) continue;
            User user = rawToken.getLogicalToken().getUser();
            selectedUserId = user.getId();
            break;
        }
        Context.setSessionAttribute("selectedUserId", selectedUserId);
        return "viewTokenDetails";
    }

    public String delete() {
        RowKey[] rowKeys = this.tableRowGroup.getRenderedSelectedRowKeys();
        if (rowKeys == null) {
            return "success";
        }
        ObjectListDataProvider oldp = this.getRegisteredTokens();
        ArrayList<String> deletedTokens = new ArrayList<String>();
        String tokenId = null;
        for (int i = 0; i < rowKeys.length; ++i) {
            RowKey rowKey = rowKeys[i];
            RawToken rawToken = (RawToken)oldp.getObject(rowKey);
            try {
                this.deleteToken(rawToken);
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("tokens_alert_delete", se);
                return "";
            }
            deletedTokens.add(rawToken.getId());
            if (i != 0) continue;
            tokenId = rawToken.getId();
        }
        this.setRegisteredTokensList(null);
        this.selectHelper.clear();
        String tokens = "";
        if (deletedTokens.size() != 0) {
            tokens = tokens + "[";
            for (int i = 0; i < deletedTokens.size(); ++i) {
                tokens = i == 0 ? tokens + (String)deletedTokens.get(i) : tokens + ", " + (String)deletedTokens.get(i);
            }
            tokens = tokens + "]";
        }
        Object[] args = new Object[]{tokens};
        this.getAuditService().publishEvent("Users", "token_removed", args, 0);
        this.getStatusMessage().info("alert_stored_changes", "tokens_delete");
        return "success";
    }

    public String enable() {
        RowKey[] rowKeys = this.tableRowGroup.getRenderedSelectedRowKeys();
        if (rowKeys == null) {
            return "success";
        }
        ObjectListDataProvider oldp = this.getRegisteredTokens();
        ArrayList<String> enabledTokens = new ArrayList<String>();
        String tokenId = null;
        for (int i = 0; i < rowKeys.length; ++i) {
            RowKey rowKey = rowKeys[i];
            RawToken rawToken = (RawToken)oldp.getObject(rowKey);
            try {
                this.getProvider().modifyToken(rawToken.getId(), true);
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("tokens_alert_modify", se);
                return "";
            }
            enabledTokens.add(rawToken.getId());
            if (i != 0) continue;
            tokenId = rawToken.getId();
        }
        this.setRegisteredTokensList(null);
        this.selectHelper.clear();
        String tokens = "";
        if (enabledTokens.size() != 0) {
            tokens = tokens + "[";
            for (int i = 0; i < enabledTokens.size(); ++i) {
                tokens = i == 0 ? tokens + (String)enabledTokens.get(i) : tokens + ", " + (String)enabledTokens.get(i);
            }
            tokens = tokens + "]";
        }
        Object[] args = new Object[]{tokens};
        this.getAuditService().publishEvent("Users", "token_enabled", args, 0);
        this.getStatusMessage().info("alert_stored_changes", "tokens_enable");
        return "success";
    }

    public String disable() {
        RowKey[] rowKeys = this.tableRowGroup.getRenderedSelectedRowKeys();
        if (rowKeys == null) {
            return "success";
        }
        ObjectListDataProvider oldp = this.getRegisteredTokens();
        ArrayList<String> disabledTokens = new ArrayList<String>();
        String tokenId = null;
        for (int i = 0; i < rowKeys.length; ++i) {
            RowKey rowKey = rowKeys[i];
            RawToken rawToken = (RawToken)oldp.getObject(rowKey);
            try {
                this.getProvider().modifyToken(rawToken.getId(), false);
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("tokens_alert_modify", se);
                return "";
            }
            disabledTokens.add(rawToken.getId());
            if (i != 0) continue;
            tokenId = rawToken.getId();
        }
        this.setRegisteredTokensList(null);
        this.selectHelper.clear();
        String tokens = "";
        if (disabledTokens.size() != 0) {
            tokens = tokens + "[";
            for (int i = 0; i < disabledTokens.size(); ++i) {
                tokens = i == 0 ? tokens + (String)disabledTokens.get(i) : tokens + ", " + (String)disabledTokens.get(i);
            }
            tokens = tokens + "]";
        }
        Object[] args = new Object[]{tokens};
        this.getAuditService().publishEvent("Users", "token_disabled", args, 0);
        this.getStatusMessage().info("alert_stored_changes", "tokens_disable");
        return "success";
    }

    public String modifySession() {
        RowKey[] rowKeys = this.tableRowGroup.getRenderedSelectedRowKeys();
        if (rowKeys == null) {
            return "success";
        }
        ObjectListDataProvider oldp = this.getRegisteredTokens();
        ArrayList<String> editedTokens = new ArrayList<String>();
        String tokenId = null;
        for (int i = 0; i < rowKeys.length; ++i) {
            RowKey rowKey = rowKeys[i];
            RawToken rawToken = (RawToken)oldp.getObject(rowKey);
            LogicalToken logicalToken = rawToken.getLogicalToken();
            String id = logicalToken.getId();
            try {
                if (this.sessionType.equals(SESSTYPE_REGULAR)) {
                    this.getProvider().setSessionType(id, 2);
                } else if (this.sessionType.equals(SESSTYPE_KIOSK)) {
                    this.getProvider().setSessionType(id, 1);
                } else {
                    this.getProvider().setSessionType(id, 0);
                }
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("tokens_alert_modify", se);
                return "";
            }
            editedTokens.add(rawToken.getId());
            if (i != 0) continue;
            tokenId = rawToken.getId();
        }
        this.setRegisteredTokensList(null);
        this.selectHelper.clear();
        String tokens = "";
        if (editedTokens.size() != 0) {
            tokens = tokens + "[";
            for (int i = 0; i < editedTokens.size(); ++i) {
                tokens = i == 0 ? tokens + (String)editedTokens.get(i) : tokens + ", " + (String)editedTokens.get(i);
            }
            tokens = tokens + "]";
        }
        Object[] args = new Object[]{this.sessionType, tokens};
        this.getAuditService().publishEvent("Users", "token_session_changed", args, 0);
        this.getStatusMessage().info("alert_stored_changes", "tokens_modify_session_changed");
        this.setSessionType("");
        return "success";
    }

    public TableRowGroup getTableRowGroup() {
        return this.tableRowGroup;
    }

    public void setTableRowGroup(TableRowGroup tableRowGroup) {
        this.tableRowGroup = tableRowGroup;
    }

    public SelectHelper getSelectHelper() {
        return this.selectHelper;
    }

    public Option[] getSessionActionsOptions() {
        return this.sessionActionsOptions;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(String sessionType) {
        this.sessionType = sessionType;
    }

    public boolean isRegistered() {
        return TokenHelper.getSearchCriteria().getFilter().equals("registered");
    }

    public boolean isCurrent() {
        return TokenHelper.getSearchCriteria().getFilter().equals("current");
    }

    public String getTitle() {
        String filter = TokenHelper.getSearchCriteria().getFilter();
        if (filter.equals("current")) {
            return I18N.getResource("tokens_title_current");
        }
        return I18N.getResource("tokens_title_registered");
    }

    protected void filter(List tokens) {
    }

    private void deleteToken(RawToken token) throws ServiceException {
        String id = token.getId();
        User user = token.getLogicalToken().getUser();
        user = this.getProvider().getUser(user.getId());
        List logicalTokens = user.getLogicalTokens();
        for (int i = 0; i < logicalTokens.size(); ++i) {
            LogicalToken logicalToken = (LogicalToken)logicalTokens.get(i);
            List rawTokens = logicalToken.getRawTokens();
            for (int j = 0; j < rawTokens.size(); ++j) {
                RawToken rawToken = (RawToken)rawTokens.get(j);
                if (!rawToken.getId().equals(id)) continue;
                if (rawTokens.size() > 1) {
                    this.getProvider().deleteToken(id);
                } else {
                    this.getProvider().deleteUser(user.getId());
                }
                return;
            }
        }
    }

    public SearchCriteria getSearchCriteria() {
        return this.searchCriteria;
    }

    public String search() {
        SearchCriteria search = TokenHelper.getSearchCriteria();
        search.setFilter(this.searchCriteria.getFilter());
        search.setSearchString(this.searchCriteria.getSearchString());
        return "viewTokensSearchResults";
    }

    public boolean isKioskInstalled() {
        if (!this.checkedKioskInstalled) {
            this.isKioskInstalled = this.getProvider().isKioskInstalled();
            this.checkedKioskInstalled = true;
        }
        return this.isKioskInstalled;
    }

    private List getRegisteredTokensList() {
        if (this.registeredTokens == null) {
            this.getRegisteredTokens();
        }
        return this.registeredTokens;
    }
}

