/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import com.sun.ut.service.AdminContext;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AuditService {
    private static final String RESOURCE_BUNDLE = "com.sun.ut.console.resource.AuditMessages";
    private static final String DEFAULT_SERVICE_NAME = "Admin";
    private static final int DEFAULT_STATUS_VALUE = 0;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private AdminContext ctx;

    public void init(AdminContext context) {
        this.ctx = context;
    }

    public void release() {
        this.ctx = null;
    }

    public AdminContext getContext() {
        return this.ctx;
    }

    public void publishEvent(String message) {
        this.publishEvent(DEFAULT_SERVICE_NAME, message, null, 0);
    }

    public void publishEvent(String message, Object[] args) {
        this.publishEvent(DEFAULT_SERVICE_NAME, message, args, 0);
    }

    public void publishEvent(String message, int status) {
        this.publishEvent(DEFAULT_SERVICE_NAME, message, null, status);
    }

    public void publishEvent(String message, Object[] args, int status) {
        this.publishEvent(DEFAULT_SERVICE_NAME, message, args, status);
    }

    public void publishEvent(String serviceName, String message, int status) {
        this.publishEvent(serviceName, message, null, status);
    }

    public void publishEvent(String serviceName, String message, Object[] args, int status) {
        String details = this.getFormattedMessage(message, args);
        String userName = "";
        if (this.ctx.getUserName() != null) {
            userName = this.ctx.getUserName();
        }
        this.ctx.getDatastore().publishEvent(userName, this.ctx.getHostName(), serviceName, details, status);
    }

    public String getMessage(String key) {
        return this.getFormattedMessage(key, null);
    }

    public String getMessage(String key, Object[] args) {
        return this.getFormattedMessage(key, args);
    }

    protected String getFormattedMessage(String key, Object[] args) {
        String message = key;
        try {
            ResourceBundle resBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
            message = resBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        if (args != null) {
            MessageFormat formatter = new MessageFormat(message);
            message = formatter.format(args).toString();
        }
        return message;
    }

    public String getFormattedDuration(long length) {
        StringBuffer buffer = new StringBuffer();
        long duration = length;
        duration = this.formatTimeLength(buffer, duration, 86400000L, "day", "days");
        duration = this.formatTimeLength(buffer, duration, 3600000L, "hour", "hours");
        if (buffer.length() == 0) {
            duration = this.formatTimeLength(buffer, duration, 60000L, "minute", "minutes");
            duration = this.formatTimeLength(buffer, duration, 1000L, "second", "seconds");
        } else {
            duration = this.formatTimeLength(buffer, duration, 60000L, "minute", "minutes");
        }
        if (buffer.length() == 0) {
            buffer.append("0 seconds");
        }
        return buffer.toString();
    }

    private long formatTimeLength(StringBuffer buffer, long duration, long unit, String singleUnit, String multipleUnits) {
        long count = duration / unit;
        if (count >= 1L) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(count);
            buffer.append(" ");
            if (count > 1L) {
                buffer.append(multipleUnits);
            } else {
                buffer.append(singleUnit);
            }
        }
        return duration - count * unit;
    }
}

