/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import com.sun.ut.service.MultiheadGroup;
import java.util.Date;

public class DesktopUnit {
    public static final String DEFAULT_NAMESPACE = "IEEE802";
    private static final int ONE_SECOND = 1000;
    private String id;
    private String location = "";
    private String description = "";
    private String model;
    private String firmwareRev;
    private String group;
    private String server;
    private String namespace;
    private Date lastStatusUpdate;
    private Date firstConnection;
    private boolean isTokenReader;
    private boolean isRegistered;
    private MultiheadGroup multiheadGroup;

    public DesktopUnit(String id, boolean isTokenReader, String group, String namespace, boolean isRegistered) {
        this(id, null, null, null, null, null, null, null, isTokenReader, group, namespace, isRegistered);
    }

    public DesktopUnit(String id, String location, String description, String model, String firmwareRev, String server, String firstConnection, String lastStatusUpdate, boolean isTokenReader, String group, String namespace, boolean isRegistered) {
        this.id = id;
        if (location != null) {
            this.location = location;
        }
        if (description != null) {
            this.description = description;
        }
        this.model = model;
        this.firmwareRev = firmwareRev;
        this.server = server;
        this.lastStatusUpdate = this.getDateForString(lastStatusUpdate);
        this.firstConnection = this.getDateForString(firstConnection);
        this.isTokenReader = isTokenReader;
        this.isRegistered = isRegistered;
        this.group = group;
        this.namespace = namespace != null && namespace.length() > 0 ? namespace : DEFAULT_NAMESPACE;
    }

    private Date getDateForString(String time) {
        Date result = null;
        if (time != null && time.length() > 0) {
            try {
                result = new Date(Long.parseLong(time) * 1000L);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getCanonicalId() {
        StringBuffer buffer = new StringBuffer(this.namespace);
        buffer.append(".");
        buffer.append(this.id);
        return buffer.toString();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModel() {
        return this.model;
    }

    public String getFirmwareRev() {
        return this.firmwareRev;
    }

    public Date getFirstConnection() {
        return this.firstConnection;
    }

    public Date getLastUpdate() {
        return this.lastStatusUpdate;
    }

    public boolean isTokenReader() {
        return this.isTokenReader;
    }

    public boolean isConnected() {
        return this.server != null;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getCurrentTokenId() {
        return null;
    }

    public String getServer() {
        return this.server;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    private String[] convertIdsForDisplay(String[] dtuIds) {
        for (int i = 0; i < dtuIds.length; ++i) {
            if (!dtuIds[i].startsWith(DEFAULT_NAMESPACE)) continue;
            dtuIds[i] = dtuIds[i].substring(DEFAULT_NAMESPACE.length() + 1);
        }
        return dtuIds;
    }

    public void setMultiheadGroup(MultiheadGroup multiheadGroup) {
        this.multiheadGroup = multiheadGroup;
    }

    public MultiheadGroup getMultiheadGroup() {
        return this.multiheadGroup;
    }
}

