/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

public class MultiheadGroup {
    private String name;
    private int rows;
    private int cols;
    private String geometry;
    private String primaryDtu;
    private String[] dtuIds;
    private static final String GEOMETRY_PREFIX = "geometry=";
    public static final String MULTIHEAD_PREFIX = "MULTIHEAD:";

    public MultiheadGroup(String name, String geometry, String primaryDtu, String[] dtuIds) {
        this.name = name;
        this.geometry = geometry.substring(GEOMETRY_PREFIX.length());
        this.cols = Integer.parseInt(this.geometry.split("x")[0]);
        this.rows = Integer.parseInt(this.geometry.split("x")[1]);
        if (primaryDtu.startsWith("IEEE802")) {
            primaryDtu = primaryDtu.substring("IEEE802".length() + 1);
        }
        this.primaryDtu = primaryDtu;
        for (int i = 0; i < dtuIds.length; ++i) {
            if (!dtuIds[i].startsWith("IEEE802")) continue;
            dtuIds[i] = dtuIds[i].substring("IEEE802".length() + 1);
        }
        this.dtuIds = dtuIds;
    }

    public MultiheadGroup(String name, int rows, int cols, String primaryDtu, String[] dtuIds) {
        this.name = name;
        this.rows = rows;
        this.cols = cols;
        this.geometry = Integer.toString(rows) + " x " + Integer.toString(cols);
        if (primaryDtu.startsWith("IEEE802")) {
            primaryDtu = primaryDtu.substring("IEEE802".length() + 1);
        }
        this.primaryDtu = primaryDtu;
        for (int i = 0; i < dtuIds.length; ++i) {
            if (!dtuIds[i].startsWith("IEEE802")) continue;
            dtuIds[i] = dtuIds[i].substring("IEEE802".length() + 1);
        }
        this.dtuIds = dtuIds;
    }

    public String getName() {
        return this.name;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public String getGeometry() {
        return this.geometry;
    }

    public String getPrimaryDTU() {
        return this.primaryDtu;
    }

    public String[] getMembers() {
        return this.dtuIds;
    }

    public void setMembers(String[] dtus) {
        this.dtuIds = dtus;
    }
}

