/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import com.sun.ut.service.AdminContext;
import com.sun.ut.service.DesktopUnit;
import com.sun.ut.service.Devices;
import com.sun.ut.service.Host;
import com.sun.ut.service.Interface;
import com.sun.ut.service.Kiosk;
import com.sun.ut.service.KioskApplication;
import com.sun.ut.service.KioskDescriptor;
import com.sun.ut.service.LogicalToken;
import com.sun.ut.service.MultiheadGroup;
import com.sun.ut.service.Package;
import com.sun.ut.service.Policy;
import com.sun.ut.service.Provider;
import com.sun.ut.service.RawToken;
import com.sun.ut.service.Security;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.Session;
import com.sun.ut.service.SmartCard;
import com.sun.ut.service.User;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ProviderMockup
extends Provider {
    private static final int PACKAGES_NUMBER = 50;
    private static final int SMARTCARD_TYPES_NUMBER = 24;
    private static final int DTU_ID_LENGTH = 12;
    private static final int DTU_START_INDEX = 100;
    private static final int DTU_NUMBER = 30;
    private static final int MULTIHEAD_1 = 1;
    private static final int MULTIHEAD_2 = 2;
    private static final int MULTIHEAD_3 = 3;
    private static final int MULTIHEAD_4 = 4;
    private static final int KIOSK_APP_1 = 1;
    private static final int KIOSK_APP_2 = 2;
    private static final int KIOSK_APP_3 = 3;
    private static final int ZEE_CONNECTED_DTUS = 15;
    private static final int SPLINTER_CONNECTED_DTUS = 25;
    private static final int OTHER_CONNECTED_DTUS = 5;
    private static final int DISKSPACE_TOTAL = 10000;
    private static final int DISKSPACE_USED = 2000;
    private static final int RESTART_TIME = 30000;
    private static final String SRSS_VERSION = "4";
    private static final int[] ZEE_SESSIONS = new int[]{2, 10, 13, 2};
    private static final int[] SPLINTER_SESSIONS = new int[]{2, 4, 23, 8};
    private static final int[] AUGUSTUS_SESSIONS = new int[]{2, 8, 3, 1};
    private AdminContext ctx;
    private HashMap dtuMap;
    private HashMap multiheadGroups;
    private HashMap userMap;
    private List hosts;
    private List hostsWithInterfaces;
    private Devices devices;
    private ArrayList sessions;
    private ArrayList currentTokens;
    private Policy policy;
    private Security security;
    private List packages;
    private List registeredSmartCards;
    private List availableSmartCards;
    private Kiosk kiosk;
    private List sessionDescriptors;
    private List applicationDescriptors;

    public void init(AdminContext context) {
        int i;
        this.ctx = context;
        this.dtuMap = new HashMap();
        this.userMap = new HashMap();
        this.multiheadGroups = new HashMap();
        this.initializeDtuData();
        this.initializeUserData();
        this.hosts = new ArrayList();
        this.hosts.add(new Host(this.getCurrentHostName(), "111.1.1.1", 0, true, false, false, null));
        this.hosts.add(new Host("Mockup server 1", "111.1.1.2", 0, true, true, false, null));
        this.hosts.add(new Host("Mockup server 2", "222.1.1.3", 0, true, false, true, null));
        this.hosts.add(new Host("Mockup server 3", "333.1.1.4", 0, true, false, false, null));
        this.hostsWithInterfaces = new ArrayList();
        HashMap<String, Interface> interfaces = new HashMap<String, Interface>();
        interfaces.put("111.1.1.0/24", new Interface("111.1.1.1", true, false));
        interfaces.put("222.1.1.0/24", new Interface("222.1.1.1", false, true));
        interfaces.put("333.1.1.0/24", new Interface("333.1.1.1", true, false));
        this.hostsWithInterfaces.add(new Host(this.getCurrentHostName(), "111.1.1.1", 0, true, false, false, interfaces));
        interfaces = new HashMap();
        interfaces.put("111.1.1.0/24", new Interface("111.1.1.2", true, false));
        this.hostsWithInterfaces.add(new Host("Mockup server 1", "111.1.1.2", 0, true, true, true, interfaces));
        interfaces = new HashMap();
        interfaces.put("111.1.1.0/24", new Interface("111.1.1.3", false, false));
        interfaces.put("333.1.1.0/24", new Interface("333.1.1.2", true, true));
        this.hostsWithInterfaces.add(new Host("Mockup server 2", "111.1.1.3", 0, false, false, false, interfaces));
        interfaces = new HashMap();
        interfaces.put("111.1.1.0/24", new Interface("111.1.1.4", false, false));
        interfaces.put("222.1.1.0/24", new Interface("222.1.1.2", true, true));
        interfaces.put("333.1.1.0/24", new Interface("333.1.1.3", true, false));
        this.hostsWithInterfaces.add(new Host("Mockup server 3", "111.1.1.4", 0, true, true, false, interfaces));
        this.devices = new Devices(true, false, true);
        this.sessions = new ArrayList();
        this.sessions.add(new Session("auth.kr108829", null, "Klaus", "kr108829", false, false, "5", "zee", null, null, null, null, null, null, null, null, null));
        this.sessions.add(new Session("pseudo.127785", null, "", "", false, true, SRSS_VERSION, "augustus", null, null, null, null, null, null, null, null, null));
        this.sessions.add(new Session("auth.test1", null, "Test1", "test1", true, false, "7", "splinter", null, null, null, null, null, null, null, null, null));
        this.sessions.add(new Session("MicroPayflex.3334b8690000000", null, "Test2", "", true, true, "0", "splinter", null, null, null, null, null, null, null, null, null));
        this.currentTokens = new ArrayList();
        this.currentTokens.add(new RawToken("token1", "Klaus Ruehl", "Sun Ray 100", "Work Office", "zee.germany.sun.com"));
        this.currentTokens.add(new RawToken("token2", "Johan Steyn", "Sun Ray 170", "Home Office", "splinter.ireland.sun.com"));
        this.policy = new Policy();
        this.policy.setKioskMode("card");
        this.policy.setNscm(true);
        this.policy.setNscmExit(true);
        this.policy.setMultihead(true);
        this.policy.setUnixAuthentication(true);
        this.policy.setSelfRegisteredTokensAccess("both");
        this.security = new Security(true, true, true, true, 0);
        this.packages = new ArrayList();
        for (i = 0; i < 50; ++i) {
            this.packages.add(new Package("Mockup" + i, "Mockup package for test purposes", "" + i + ".0", "abc." + i + ".xyz"));
        }
        this.registeredSmartCards = new ArrayList();
        this.availableSmartCards = new ArrayList();
        for (i = 0; i < 24; ++i) {
            this.availableSmartCards.add(new SmartCard("Smart Card " + i, "Model", "Mockup Smart Card", "Sun Microsystems, Inc.", "1.0", "smartcard", null, "File" + i + ".cfg"));
        }
        this.sessionDescriptors = new ArrayList();
        Kiosk defaults = new Kiosk(null, "10000", "1000", "1000", "100", "10", "en", "--defaults-args-for-jds", null);
        this.sessionDescriptors.add(new KioskDescriptor("jds", "Java Desktop System", true, "path-to-icon", "Sun's GNOME-based desktop", defaults));
        defaults = new Kiosk(null, "20000", "", "", "", "", "", "", null);
        this.sessionDescriptors.add(new KioskDescriptor("cde", "Common Desktop Environment", true, "path-to-icon", "Sun's previous attempt at a desktop", defaults));
        defaults = new Kiosk(null, "30000", null, null, null, null, null, null, null);
        this.sessionDescriptors.add(new KioskDescriptor("sgd", "Secure Global Desktop", true, "path-to-icon", "Sun's Secure global desktop", defaults));
        defaults = null;
        this.sessionDescriptors.add(new KioskDescriptor("rdp", "Windows Connector", true, "path-to-icon", "Sun's Tarrantella acquisition", defaults));
        defaults = new Kiosk(null, "50000", "5000", "5000", "500", "50", "de", "--defaults-args-for-browser", null);
        this.sessionDescriptors.add(new KioskDescriptor("browser", "Browser", false, "path-to-icon", "Mozilla Firefox", defaults));
        this.applicationDescriptors = new ArrayList();
        this.applicationDescriptors.add(new KioskDescriptor("firefox", "Browser", false, "path-to-icon", "Mozilla Firefox version 1.0.7", null));
        this.applicationDescriptors.add(new KioskDescriptor("thunderbird", "Email", false, "path-to-icon", "Mozilla Thunderbird version 1.0.7", null));
        this.applicationDescriptors.add(new KioskDescriptor("xclock", "Clock", false, "path-to-icon", "X-Windows Clock", null));
        this.applicationDescriptors.add(new KioskDescriptor("gedit", "Text Editor", false, "path-to-icon", "The GNOME Text Editor", null));
        this.applicationDescriptors.add(new KioskDescriptor("nautilus", "File Browser", false, "path-to-icon", "Nautilus 2.12.1", null));
        this.applicationDescriptors.add(new KioskDescriptor("gnibbles", "Nibbles", false, "path-to-icon", "Arcade Game for GNOME", null));
        ArrayList<KioskApplication> applications = new ArrayList<KioskApplication>();
        applications.add(new KioskApplication((KioskDescriptor)this.applicationDescriptors.get(1), "user", "-height 600 -width 400"));
        applications.add(new KioskApplication((KioskDescriptor)this.applicationDescriptors.get(2), "auto", "-P myprofile"));
        applications.add(new KioskApplication((KioskDescriptor)this.applicationDescriptors.get(3), "critical", "-geometry 200x200 -bg yellow"));
        applications.add(new KioskApplication("/path/to/descriptor", "desc", "user", "--verbose --no-splash"));
        applications.add(new KioskApplication("/path/to/executable", "exec", "user", "--slideshow"));
        this.kiosk = new Kiosk((KioskDescriptor)this.sessionDescriptors.get(0), "600", "10", "200000", "256", "200", "en", "-v --long-option", applications);
    }

    public void release() {
        this.ctx = null;
        this.dtuMap = null;
        this.multiheadGroups = null;
    }

    public boolean hasAdminPrivileges(String username) throws ServiceException {
        return username.equals("admin");
    }

    public int getReplicationRole(String hostname) throws ServiceException {
        this.ctx.getLogger().info("Detecting replication role");
        if (this.getCurrentHostName().equals(hostname)) {
            return 2;
        }
        return 4;
    }

    public DesktopUnit getDTU(String id) {
        this.ctx.getLogger().info("Retrieving data for DTU " + id);
        if (this.dtuMap.get(id) == null) {
            this.ctx.getLogger().warning("DTU with " + id + " not in database!");
        }
        return (DesktopUnit)this.dtuMap.get(id);
    }

    public DesktopUnit getDTU(String id, boolean includeRuntimeInfo) {
        return this.getDTU(id);
    }

    public void modifyDTU(String id, String location, String description) {
        this.ctx.getLogger().info("Modified DTU with id " + id);
        DesktopUnit dtu = (DesktopUnit)this.dtuMap.get(id);
    }

    public void deleteDTU(String id) {
        this.ctx.getLogger().info("Deleting DTU with id " + id);
        this.dtuMap.remove(id);
    }

    public void addDTU(String id, String location, String description) {
        this.ctx.getLogger().info("Adding DTU with id " + id);
        this.addDTU(id, location, description, "");
    }

    public List getDTUs() {
        this.ctx.getLogger().info("Retrieving list of DTUs");
        return new ArrayList(this.dtuMap.values());
    }

    public List getCurrentDTUs() {
        this.ctx.getLogger().info("Retrieving list of DTUs with \"up\" status");
        ArrayList<DesktopUnit> results = new ArrayList<DesktopUnit>();
        Iterator it = this.dtuMap.values().iterator();
        while (it.hasNext()) {
            DesktopUnit dtu = (DesktopUnit)it.next();
            if (!dtu.isConnected()) continue;
            results.add(dtu);
        }
        return results;
    }

    public String getCurrentToken(String servername, String dtuId) {
        return "MicroPayflex.3334b8690000000";
    }

    public int getCurrentDTUsNumber(String hostname) {
        if (hostname.compareTo("zee") == 0) {
            return 15;
        }
        if (hostname.compareTo("splinter") == 0) {
            return 25;
        }
        return 5;
    }

    public List getTokenReaders() {
        ArrayList<DesktopUnit> list = new ArrayList<DesktopUnit>();
        list.add(this.getDTU("040020f94f8a"));
        list.add(this.getDTU("050020f94f8a"));
        list.add(this.getDTU("060020f94f8a"));
        return list;
    }

    public void addTokenReader(String dtuId) {
    }

    public void removeTokenReader(String dtuId) {
    }

    public String getToken(String readerId) {
        return "MicroPayflex.5004b8690000000";
    }

    public String getTokenFromDTU(String servername, String dtuId) throws ServiceException {
        return "MicroPayflex.5004b8690000000";
    }

    public String getTokenFromReader(String readerId) throws ServiceException {
        if (readerId.equals("050020f94f8a")) {
            return "MicroPayflex.050020f94f8a";
        }
        if (readerId.equals("040020f94f8a")) {
            return "MicroPayflex.040020f94f8a";
        }
        if (readerId.equals("060020f94f8a")) {
            return "MicroPayflex.060020f94f8a";
        }
        return "unkown.token";
    }

    public List searchDTUs(String searchCriteria) {
        this.ctx.getLogger().info("Performing DTU search for " + searchCriteria);
        if (searchCriteria.equals("*")) {
            return this.getDTUs();
        }
        ArrayList<DesktopUnit> results = new ArrayList<DesktopUnit>();
        Iterator it = this.dtuMap.values().iterator();
        while (it.hasNext()) {
            DesktopUnit dtu = (DesktopUnit)it.next();
            if (dtu.getId().indexOf(searchCriteria) != -1) {
                results.add(dtu);
                continue;
            }
            if (dtu.getLocation() != null && dtu.getLocation().indexOf(searchCriteria) != -1) {
                results.add(dtu);
                continue;
            }
            if (dtu.getDescription() == null || dtu.getDescription().indexOf(searchCriteria) == -1) continue;
            results.add(dtu);
        }
        return results;
    }

    public MultiheadGroup getMultiheadGroup(String name) {
        this.ctx.getLogger().info("Retrieving multihead group: " + name);
        return (MultiheadGroup)this.multiheadGroups.get(name);
    }

    public List getMultiheadGroups() {
        this.ctx.getLogger().info("Retrieving data for all multihead groups");
        ArrayList list = new ArrayList();
        Iterator it = this.multiheadGroups.values().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    private void addDTU(String id, String location, String description, String status) {
        String macAddress = this.reformatId(id);
        DesktopUnit dtu = new DesktopUnit(macAddress, location, description, "", "", "", "", "", false, "", "", true);
        this.dtuMap.put(macAddress, dtu);
    }

    private String reformatId(String id) {
        StringBuffer buffer = new StringBuffer(id);
        int fill = 12 - id.length();
        for (int i = 0; i < fill; ++i) {
            buffer.insert(0, "0");
        }
        return buffer.toString();
    }

    private void initializeDtuData() {
        for (int i = 100; i <= 130; ++i) {
            this.addDTU(Integer.toHexString(i), "Ham-01 / Rm. 6." + i, "QA lab", "Up");
        }
        this.addDTU("040020f94f8a", "Ham-01 / Rm. 5.12", "Developer Center", "");
        this.addDTU("050020f94f8a", "Ham-01 / Rm. 5.12", "Developer Center", "Down");
        this.addDTU("060020f94f8a", "Ham-01 / Rm. 5.12", "Developer Center", "Down");
        this.addDTU("070020f94f8a", "Ham-01 / Rm. 5.12", "Developer Center", "Down");
        this.addDTU("080020f94e8a", "Ham-01 / Rm. 4.06", "Public kiosk", "Up");
        this.addDTU("080020f94e8b", "Ham-01 / Rm. 4.06", "Public kiosk", "Up");
        this.addDTU("080020f94e9e", "Ham-01 / Rm. 4.06", "Public kiosk", "Up");
        this.addDTU("080020f94e9f", "Ham-01 / Rm. 4.06", "Public kiosk", "Up");
        this.addDTU("080020f94f8a", "Ham-01 / Rm. 5.12", "Developer Center", "Up");
        this.addDTU("080020f94f8a", "Ham-01 / Rm. 5.12", "Developer Center", "Up");
        Iterator it = this.dtuMap.values().iterator();
        this.addMultiheadGroup("Demo Multihead", 2, 3, it);
        this.addMultiheadGroup("Large Screen", 4, 3, it);
        this.addMultiheadGroup("Workspace A", 1, 4, it);
        this.addMultiheadGroup("Workspace B", 2, 2, it);
        this.addMultiheadGroup("Airport", 1, 2, it);
        this.addMultiheadGroup("Public Information", 2, 3, it);
    }

    private void addMultiheadGroup(String id, int rows, int columns, Iterator it) {
        String[] dtuIds = new String[rows * columns];
        int index = 0;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                DesktopUnit dtu = (DesktopUnit)it.next();
                dtuIds[index] = dtu.getId();
                ++index;
            }
        }
        MultiheadGroup group = new MultiheadGroup(id, rows, columns, dtuIds[0], dtuIds);
        for (int i = 0; i < dtuIds.length; ++i) {
            this.getDTU(dtuIds[i]).setGroup(id);
        }
        this.multiheadGroups.put(id, group);
    }

    public List getHosts() {
        this.hosts = new ArrayList();
        this.hosts.add(new Host(this.getCurrentHostName(), "111.1.1.1", 0, true, false, false, null));
        this.hosts.add(new Host("Mockup server 1", "111.1.1.2", 0, true, true, false, null));
        this.hosts.add(new Host("Mockup server 2", "222.1.1.3", 0, true, false, true, null));
        this.hosts.add(new Host("Mockup server 3", "333.1.1.4", 0, true, false, false, null));
        return this.hosts;
    }

    public List getHostsWithInterfaces(String hostname) {
        return this.hostsWithInterfaces;
    }

    public String getPrimaryHostName() {
        return "zee";
    }

    public long[] getDiskSpace(String path) {
        long[] info = new long[]{10000L, 8000L, 2000L};
        return info;
    }

    public String getSoftwareVersion() {
        return SRSS_VERSION;
    }

    public long[] getSwapSpace() {
        long[] info = new long[]{10000L, 8000L, 2000L};
        return info;
    }

    public int[] getSessionNumbers(String hostname) {
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("zee", ZEE_SESSIONS);
        map.put("splinter", SPLINTER_SESSIONS);
        map.put("augustus", AUGUSTUS_SESSIONS);
        return (int[])map.get(hostname);
    }

    public void restartHost(String hostname, boolean coldRestart) {
        Host host = null;
        try {
            for (int i = 0; i < this.hosts.size(); ++i) {
                host = (Host)this.hosts.get(i);
                if (host == null || !hostname.equals(host.getName())) continue;
                host.setRestartStatus("restarting");
            }
            Thread.currentThread();
            Thread.sleep(30000L);
            if (host != null) {
                host.setRestartStatus("restart_done");
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public void getStartTimes(String hostname, int[] startTimes) {
    }

    public String getCurrentHostName() {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            hostname = "localhost";
        }
        return hostname;
    }

    public Devices getDevices() {
        this.ctx.getLogger().info("Retrieving devices");
        return new Devices(this.devices);
    }

    public void saveDevices(Devices newDevices) {
        this.ctx.getLogger().info("Modifying devices");
        this.devices = new Devices(newDevices);
    }

    public List getSessions(String token, String hostname) {
        this.ctx.getLogger().info("Retrieving sessions");
        return new ArrayList(this.sessions);
    }

    public void terminate(Session session) {
        this.sessions.remove(session);
    }

    public void terminateSession(String server, String display, String token) {
        this.ctx.getLogger().info("Terminating sessions");
        Iterator it = this.sessions.iterator();
        while (it.hasNext()) {
            Session session = (Session)it.next();
            if (session.getServer() != server || session.getDisplay() != display || session.getTokenID() != token) continue;
            this.sessions.remove(session);
            break;
        }
    }

    public List searchUsers(String searchCriteria) {
        this.ctx.getLogger().info("Retrieving users");
        return new ArrayList(this.userMap.values());
    }

    public List getUsers(String searchCriteria) {
        this.ctx.getLogger().info("Retrieving users");
        return new ArrayList(this.userMap.values());
    }

    public List getCurrentTokens() {
        this.ctx.getLogger().info("Retrieving current tokens");
        return new ArrayList(this.currentTokens);
    }

    public User getUser(String id) {
        this.ctx.getLogger().info("Retrieving data for user: id=" + id);
        return (User)this.userMap.get(id);
    }

    public String addUser(String name, String description, String tokenId) {
        this.ctx.getLogger().info("Adding new user: name=" + name + " description=" + description + " tokenId=" + tokenId);
        RawToken rawToken = new RawToken(tokenId, true);
        ArrayList<RawToken> rawTokens = new ArrayList<RawToken>();
        rawTokens.add(rawToken);
        LogicalToken logicalToken = new LogicalToken(tokenId, 0, rawTokens);
        ArrayList<LogicalToken> logicalTokens = new ArrayList<LogicalToken>();
        logicalTokens.add(logicalToken);
        User user = new User(tokenId, name, description, logicalTokens);
        this.userMap.put(user.getId(), user);
        return user.getId();
    }

    public void deleteUser(String id) {
        this.ctx.getLogger().info("Deleting user: id=" + id);
        this.userMap.remove(id);
    }

    public void modifyUser(String id, String name, String description) {
        this.ctx.getLogger().info("Modifying user: id=" + id + " name=" + name + " description=" + description);
        User user = (User)this.userMap.get(id);
        user.setUserName(name);
        user.setDescription(description);
    }

    public String getUnixUserComment(String id) {
        return null;
    }

    public boolean isKioskConfigured() {
        return true;
    }

    public boolean isKioskInstalled() {
        return true;
    }

    public boolean isNscmSupported() {
        return true;
    }

    public Policy getPolicy() {
        this.ctx.getLogger().info("Retrieving policy: " + this.policy.getContent());
        return this.policy;
    }

    public void modifyPolicy(Policy newPolicy) {
        this.ctx.getLogger().info("Modifying policy: " + newPolicy.getContent());
        this.policy.setContent(newPolicy.getContent());
    }

    public void modifyPassword(String password, String newPassword) throws ServiceException {
        this.ctx.getLogger().info("Modifying password");
    }

    public Security getSecurity() {
        this.ctx.getLogger().info("Retrieving security");
        return new Security(this.security);
    }

    public void saveSecurity(Security newSecurity) {
        this.ctx.getLogger().info("Modifying security: " + newSecurity);
        this.security = new Security(newSecurity);
    }

    public List getPackages() {
        this.ctx.getLogger().info("Retrieving packages");
        return new ArrayList(this.packages);
    }

    public List getRegisteredSmartCards() {
        this.ctx.getLogger().info("Retrieving registered smart cards");
        return new ArrayList(this.registeredSmartCards);
    }

    public List getAvailableSmartCards() {
        this.ctx.getLogger().info("Retrieving available smart cards");
        return new ArrayList(this.availableSmartCards);
    }

    public void saveSmartCards(List smartCards) {
        this.ctx.getLogger().info("Saving smart cards");
        this.registeredSmartCards = new ArrayList();
        for (int i = 0; i < smartCards.size(); ++i) {
            SmartCard smartCard = (SmartCard)smartCards.get(i);
            SmartCard availableSmartCard = null;
            for (int j = 0; j < this.availableSmartCards.size(); ++j) {
                availableSmartCard = (SmartCard)this.availableSmartCards.get(j);
                if (smartCard.getName().equals(availableSmartCard.getName()) && smartCard.getVersion().equals(availableSmartCard.getVersion())) break;
                availableSmartCard = null;
            }
            if (availableSmartCard == null) continue;
            this.registeredSmartCards.add(availableSmartCard);
        }
    }

    public void deleteToken(String id) {
        this.ctx.getLogger().info("Deleting token: id=" + id);
        Iterator it = this.userMap.values().iterator();
        block0: while (it.hasNext()) {
            User user = (User)it.next();
            List logicalTokens = user.getLogicalTokens();
            for (int i = 0; i < logicalTokens.size(); ++i) {
                LogicalToken logicalToken = (LogicalToken)logicalTokens.get(i);
                List rawTokens = logicalToken.getRawTokens();
                for (int j = 0; j < rawTokens.size(); ++j) {
                    RawToken rawToken = (RawToken)rawTokens.get(j);
                    if (!id.equals(rawToken.getId())) continue;
                    rawTokens.remove(rawToken);
                    break block0;
                }
            }
        }
    }

    public void addToken(String tokenId, String userId, boolean enabled) {
        this.ctx.getLogger().info("Adding token " + tokenId + " to user " + userId);
        User user = (User)this.userMap.get(userId);
        List logicalTokens = user.getLogicalTokens();
        LogicalToken logicalToken = (LogicalToken)logicalTokens.get(0);
        List rawTokens = logicalToken.getRawTokens();
        rawTokens.add(new RawToken(tokenId, enabled));
    }

    public void modifyToken(String id, boolean enabled) {
        Iterator it = this.userMap.values().iterator();
        block0: while (it.hasNext()) {
            User user = (User)it.next();
            List logicalTokens = user.getLogicalTokens();
            for (int i = 0; i < logicalTokens.size(); ++i) {
                LogicalToken logicalToken = (LogicalToken)logicalTokens.get(i);
                List rawTokens = logicalToken.getRawTokens();
                for (int j = 0; j < rawTokens.size(); ++j) {
                    RawToken rawToken = (RawToken)rawTokens.get(j);
                    if (!id.equals(rawToken.getId())) continue;
                    rawToken.setEnabled(enabled);
                    break block0;
                }
            }
        }
    }

    public void setSessionType(String token, int type) throws ServiceException {
    }

    public int getSessionType(String token) throws ServiceException {
        return 2;
    }

    public Kiosk getKiosk() {
        this.ctx.getLogger().info("Retrieving Kiosk Mode configuration");
        return new Kiosk(this.kiosk);
    }

    public void saveKiosk(Kiosk newKiosk) {
        this.ctx.getLogger().info("Saving Kiosk Mode configuration");
        this.kiosk = newKiosk;
    }

    public List getKioskSessionDescriptors() {
        this.ctx.getLogger().info("Retrieving Kiosk Mode session descriptors");
        return new ArrayList(this.sessionDescriptors);
    }

    public List getKioskApplicationDescriptors() {
        this.ctx.getLogger().info("Retrieving Kiosk Mode application descriptors");
        return new ArrayList(this.applicationDescriptors);
    }

    private void initializeUserData() {
        ArrayList<RawToken> rawTokens = new ArrayList<RawToken>();
        rawTokens.add(new RawToken("raw.token.1", true));
        rawTokens.add(new RawToken("raw.token.2", true));
        rawTokens.add(new RawToken("raw.token.3", true));
        rawTokens.add(new RawToken("raw.token.4", true));
        ArrayList<LogicalToken> logicalTokens = new ArrayList<LogicalToken>();
        logicalTokens.add(new LogicalToken("logical.token.1", 2, rawTokens));
        User user = new User("user.1", "Klaus Ruehl", "Apollo developer", logicalTokens);
        this.userMap.put(user.getId(), user);
        rawTokens = new ArrayList();
        rawTokens.add(new RawToken("raw.token.5", true));
        rawTokens.add(new RawToken("raw.token.6", true));
        rawTokens.add(new RawToken("raw.token.7", true));
        rawTokens.add(new RawToken("raw.token.8", true));
        logicalTokens = new ArrayList();
        logicalTokens.add(new LogicalToken("logical.token.2", 1, rawTokens));
        user = new User("user.2", "Johan Steyn", "Apollo developer", logicalTokens);
        this.userMap.put(user.getId(), user);
    }
}

