/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.authentication;

public class PamMessage {
    public static final String PAM_SUCCESS = "\u00000";
    public static final String PAM_PROMPT_ECHO_OFF = "\u00001";
    public static final String PAM_PROMPT_ECHO_ON = "\u00002";
    public static final String PAM_ERROR_MSG = "\u00003";
    public static final String PAM_TEXT_INFO = "\u00004";
    private String type;
    private String message;

    public PamMessage(String data) {
        int pos = data.indexOf(" ");
        if (pos > 0) {
            this.type = data.substring(0, pos);
            if (pos < data.length() - 1) {
                this.message = data.substring(pos + 1, data.length());
            }
        } else {
            this.type = data;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSuccess() {
        return this.type.compareTo(PAM_SUCCESS) == 0;
    }

    public boolean isPromptEchoOff() {
        return this.type.compareTo(PAM_PROMPT_ECHO_OFF) == 0;
    }

    public boolean isPromptEchoOn() {
        return this.type.compareTo(PAM_PROMPT_ECHO_ON) == 0;
    }

    public boolean isErrorMsg() {
        return this.type.compareTo(PAM_ERROR_MSG) == 0;
    }

    public boolean isTextInfo() {
        return this.type.compareTo(PAM_TEXT_INFO) == 0;
    }
}

