/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.command;

import com.sun.ut.service.Kiosk;
import com.sun.ut.service.KioskApplication;
import com.sun.ut.service.KioskDescriptor;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.Task;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class KioskDesc
extends Task {
    private static final String KIOSKDESC_CMD = "/opt/SUNWkio/bin/kioskdesc";
    public static final String PRINT_OPTION = "print";
    public static final String LIST_OPTION = "list";
    public static final String SESSION_TYPE = "-s";
    public static final String APPLICATION_TYPE = "-a";
    private String option;
    private String type;
    private String descriptor;

    public KioskDesc() {
    }

    public KioskDesc(String optionArg, String typeArg) {
        this.option = optionArg;
        this.type = typeArg;
    }

    public void setOption(String optionArg) {
        this.option = optionArg;
    }

    public String getOption() {
        return this.option;
    }

    public void setType(String typeArg) {
        this.type = typeArg;
    }

    public String getType() {
        return this.type;
    }

    public String[] getElements() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(KIOSKDESC_CMD);
        if (this.option != null) {
            list.add(this.option);
        }
        if (this.type != null) {
            list.add(this.type);
        }
        if (this.descriptor != null) {
            list.add(this.descriptor);
        }
        String[] command = new String[list.size()];
        command = list.toArray(command);
        return command;
    }

    public String getKioskDesc(String optionArg, String typeArg) {
        this.option = optionArg;
        this.type = typeArg;
        this.descriptor = null;
        this.run();
        return this.getOutputMsg();
    }

    public String getKioskDesc(String optionArg, String typeArg, String descriptorArg) {
        this.option = optionArg;
        this.type = typeArg;
        this.descriptor = descriptorArg;
        this.run();
        return this.getOutputMsg();
    }

    public Kiosk getKiosk(String contents) throws ServiceException {
        List sessionDescriptors = this.getKioskDescriptors(SESSION_TYPE);
        List appDescriptors = this.getKioskDescriptors(APPLICATION_TYPE);
        return this.getKiosk(sessionDescriptors, appDescriptors, contents);
    }

    public List getKioskDescriptors(String typeArg) {
        ArrayList<KioskDescriptor> descriptors = new ArrayList<KioskDescriptor>();
        String result = this.getKioskDesc(LIST_OPTION, typeArg);
        StringTokenizer strtok = new StringTokenizer(result, "\n");
        while (strtok.hasMoreTokens()) {
            String id = strtok.nextToken();
            String lines = this.getKioskDesc(PRINT_OPTION, typeArg, id);
            descriptors.add(this.getKioskDescriptor(id, lines, typeArg));
        }
        return descriptors;
    }

    public Kiosk getKiosk(List sessionDescriptors, List appDescriptors, String kioskString) throws ServiceException {
        if (sessionDescriptors.size() <= 0) {
            throw new ServiceException("kiosk_no_session_descriptors_alert", "No session descriptors found. At least one is required for Kiosk Mode!", 0);
        }
        KioskDescriptor sessionDescriptor = null;
        String timeout = null;
        String maxCPU = null;
        String maxVM = null;
        String maxFiles = null;
        String maxFileSize = null;
        String locale = null;
        String args = null;
        ArrayList<KioskApplication> applications = new ArrayList<KioskApplication>();
        boolean applist = false;
        StringTokenizer tokenizer = new StringTokenizer(kioskString, "\n");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if ((line = line.trim()).startsWith("KIOSK_SESSION=")) {
                String id = line.substring(line.indexOf("=") + 1);
                for (int i = 0; i < sessionDescriptors.size(); ++i) {
                    KioskDescriptor desc = (KioskDescriptor)sessionDescriptors.get(i);
                    if (!id.equals(desc.getId())) continue;
                    sessionDescriptor = desc;
                    break;
                }
                if (sessionDescriptor == null) {
                    Object[] arguments = new String[]{id};
                    throw new ServiceException("kiosk_no_session_descriptor_alert", arguments, "No Kiosk session descriptor found with id: " + id, 0);
                }
            } else if (line.startsWith("KIOSK_SESSION_TIMEOUT_DETACHED=")) {
                timeout = line.substring(line.indexOf("=") + 1);
            } else if (line.startsWith("KIOSK_SESSION_LIMIT_CPU=")) {
                maxCPU = line.substring(line.indexOf("=") + 1);
            } else if (line.startsWith("KIOSK_SESSION_LIMIT_VMSIZE=")) {
                maxVM = line.substring(line.indexOf("=") + 1);
            } else if (line.startsWith("KIOSK_SESSION_LIMIT_DESCRIPTORS=")) {
                maxFiles = line.substring(line.indexOf("=") + 1);
            } else if (line.startsWith("KIOSK_SESSION_LIMIT_FILESIZE=")) {
                maxFileSize = line.substring(line.indexOf("=") + 1);
            } else if (line.startsWith("KIOSK_SESSION_LOCALE=")) {
                locale = line.substring(line.indexOf("=") + 1);
            } else if (line.startsWith("KIOSK_SESSION_ARGS=")) {
                args = KioskDesc.stripQuotes(line.substring(line.indexOf("=") + 1));
            } else if (line.startsWith("KIOSK_SESSION_APPLIST=")) {
                applist = true;
                if (line.length() <= line.indexOf("=") + 1) continue;
                line = line.substring(line.indexOf("=") + 1);
            }
            if (!applist) continue;
            applications.add(this.getApplication(appDescriptors, line));
        }
        if (sessionDescriptor == null) {
            throw new ServiceException("kiosk_session_descriptor_unconfigured", "Kiosk session descriptor is not configured!", 0);
        }
        return new Kiosk(sessionDescriptor, timeout, maxCPU, maxVM, maxFiles, maxFileSize, locale, args, applications);
    }

    public KioskDescriptor getKioskDescriptor(String id, String desc, String descType) {
        ArrayList descriptors = new ArrayList();
        String label = null;
        boolean launcher = false;
        String icon = null;
        String description = null;
        String timeout = null;
        String maxCPU = null;
        String maxVM = null;
        String maxFiles = null;
        String maxFileSize = null;
        String locale = null;
        String args = null;
        StringTokenizer st = new StringTokenizer(desc, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.startsWith("KIOSK_SESSION_LABEL=") || line.startsWith("KIOSK_APP_LABEL=")) {
                label = line.substring(line.indexOf("=") + 1);
                continue;
            }
            if (line.startsWith("KIOSK_SESSION_APPLAUNCHER=")) {
                launcher = true;
                continue;
            }
            if (line.startsWith("KIOSK_SESSION_ICON=") || line.startsWith("KIOSK_APP_ICON=")) {
                icon = line.substring(line.indexOf("=") + 1);
                continue;
            }
            if (line.startsWith("KIOSK_SESSION_DESCRIPTION=") || line.startsWith("KIOSK_APP_DESCRIPTION=")) {
                description = line.substring(line.indexOf("=") + 1);
                continue;
            }
            if (line.startsWith("KIOSK_SESSION_TIMEOUT_DETACHED=")) {
                timeout = line.substring(line.indexOf("=") + 1);
                continue;
            }
            if (line.startsWith("KIOSK_SESSION_LIMIT_CPU=")) {
                maxCPU = line.substring(line.indexOf("=") + 1);
                continue;
            }
            if (line.startsWith("KIOSK_SESSION_LIMIT_VMSIZE=")) {
                maxVM = line.substring(line.indexOf("=") + 1);
                continue;
            }
            if (line.startsWith("KIOSK_SESSION_LIMIT_DESCRIPTORS=")) {
                maxFiles = line.substring(line.indexOf("=") + 1);
                continue;
            }
            if (line.startsWith("KIOSK_SESSION_LIMIT_FILESIZE=")) {
                maxFileSize = line.substring(line.indexOf("=") + 1);
                continue;
            }
            if (line.startsWith("KIOSK_SESSION_LOCALE=")) {
                locale = line.substring(line.indexOf("=") + 1);
                continue;
            }
            if (!line.startsWith("KIOSK_SESSION_ARGS=")) continue;
            args = line.substring(line.indexOf("=") + 1);
        }
        if (label == null) {
            label = id;
        }
        Kiosk recommendations = null;
        if (descType.equals(SESSION_TYPE)) {
            recommendations = new Kiosk(null, timeout, maxCPU, maxVM, maxFiles, maxFileSize, locale, args, null);
        }
        return new KioskDescriptor(id, label, launcher, icon, description, recommendations);
    }

    private KioskApplication getApplication(List appDescriptors, String line) throws ServiceException {
        KioskDescriptor appDescriptor = null;
        String path = null;
        String descType = null;
        String mode = null;
        String appArgs = null;
        String s = line;
        int index = s.indexOf(":");
        if (index > 0) {
            if (s.startsWith("desc") || s.startsWith("exec")) {
                descType = s.substring(0, index);
            }
            if (s.length() > index + 1 && (index = (s = s.substring(index + 1)).indexOf(":")) > 0) {
                String appName = s.substring(0, index);
                if (appName.startsWith("/")) {
                    path = appName;
                } else {
                    String id = appName;
                    for (int i = 0; i < appDescriptors.size(); ++i) {
                        KioskDescriptor desc = (KioskDescriptor)appDescriptors.get(i);
                        if (!id.equals(desc.getId())) continue;
                        appDescriptor = desc;
                        break;
                    }
                    if (appDescriptor == null) {
                        Object[] arguments = new String[]{id};
                        throw new ServiceException("kiosk_no_app_descriptor_alert", arguments, "No Kiosk application descriptor found with id: " + id, 0);
                    }
                }
                if (s.length() > index + 1 && (index = (s = s.substring(index + 1)).indexOf(";")) > 0) {
                    if (s.startsWith("user") || s.startsWith("auto") || s.startsWith("critical")) {
                        mode = s.substring(0, index);
                    }
                    if (s.length() > index + 1) {
                        appArgs = s.substring(index + 1);
                    }
                }
            }
        }
        if (appDescriptor == null && path == null || descType == null || mode == null) {
            String[] arguments = new String[]{line};
            throw new ServiceException("kiosk_invalid_application_alert", "Invalid Kiosk application list entry: " + line, 0);
        }
        KioskApplication application = null;
        if (appDescriptor != null) {
            application = new KioskApplication(appDescriptor, mode, appArgs);
        }
        if (path != null) {
            application = new KioskApplication(path, descType, mode, appArgs);
        }
        return application;
    }

    private static String stripQuotes(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }
}

