/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.command;

import com.sun.ut.service.Policy;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.UtReader;
import com.sun.ut.service.jni.Datastore;
import com.sun.ut.service.jni.DatastoreFactory;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class UtReaderTest
extends TestCase {
    private static final String DTU_NAMESPACE = "IEEE802.";
    private static final String[] TEST_DTU_IDS = new String[]{"00144f488a77", "040020f94f81", "0003badc1c3f"};
    private static final String TEST_POLICY = " -a -z pseudo -p -s card -r card -t clear -t add:IEEE802." + TEST_DTU_IDS[0] + " -t add:" + "IEEE802." + TEST_DTU_IDS[1];
    private Datastore ds;
    private String backupPolicy;

    protected final void setUp() throws ServiceException {
        this.ds = DatastoreFactory.getDatastore();
        this.backupPolicy = this.ds.getPolicy();
        System.out.println("Backup policy: " + this.backupPolicy);
        this.ds.modifyPolicy("");
    }

    protected final void tearDown() throws ServiceException {
        this.ds.modifyPolicy(this.backupPolicy);
        this.ds = null;
    }

    public void testAddReader() throws ServiceException {
        UtReader cmd = new UtReader();
        cmd.addReader(TEST_DTU_IDS[0]);
        cmd.addReader(TEST_DTU_IDS[1]);
        cmd.addReader(TEST_DTU_IDS[2]);
        int i = 0;
        System.out.println("Configuring " + TEST_DTU_IDS.length + " token readers");
        Policy policy = new Policy(this.ds.getPolicy());
        System.out.println(policy.getContent());
        List readers = policy.getTerminalReaders();
        UtReaderTest.assertTrue((readers.size() == TEST_DTU_IDS.length ? 1 : 0) != 0);
        Iterator it = readers.iterator();
        System.out.println("Configured token readers:");
        while (it.hasNext()) {
            String readerId = (String)it.next();
            if (readerId.startsWith(DTU_NAMESPACE)) {
                readerId = readerId.substring(DTU_NAMESPACE.length(), readerId.length());
            }
            System.out.println(readerId);
            UtReaderTest.assertTrue((boolean)TEST_DTU_IDS[i].equals(readerId));
            ++i;
        }
        cmd.removeReader(TEST_DTU_IDS[0]);
        cmd.removeReader(TEST_DTU_IDS[1]);
        cmd.removeReader(TEST_DTU_IDS[2]);
        policy = new Policy(this.ds.getPolicy());
        System.out.println(policy.getContent());
        UtReaderTest.assertTrue((boolean)policy.getTerminalReaders().isEmpty());
    }

    public void testRemoveReader() throws ServiceException {
        Policy policy = new Policy(TEST_POLICY);
        this.ds.modifyPolicy(policy.getContent());
        System.out.println(policy.getContent());
        System.out.println("Unconfiguring all token readers");
        UtReader cmd = new UtReader();
        cmd.removeReader(TEST_DTU_IDS[0]);
        cmd.removeReader(TEST_DTU_IDS[1]);
        Policy newPolicy = new Policy(this.ds.getPolicy());
        System.out.println(newPolicy.getContent());
        UtReaderTest.assertTrue((boolean)newPolicy.getTerminalReaders().isEmpty());
    }

    public void testIsReader() throws ServiceException {
        String id = TEST_DTU_IDS[0];
        UtReader cmd = new UtReader();
        cmd.addReader(id);
        Policy policy = new Policy(this.ds.getPolicy());
        System.out.println("Added token reader " + id);
        System.out.println(policy.getContent());
        UtReaderTest.assertTrue((boolean)policy.isTerminalReader(id));
        cmd.removeReader(id);
        System.out.println("Removed token reader " + id);
        policy = new Policy(this.ds.getPolicy());
        System.out.println(policy.getContent());
        UtReaderTest.assertFalse((boolean)policy.isTerminalReader(id));
    }
}

