/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.command;

import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.RemoteCommand;
import com.sun.ut.service.command.Task;

public class UtRestart
extends Task {
    private static final String UT_RESTART_CMD = "/opt/SUNWut/sbin/utrestart";
    public static final String COLD_RESTART_OPTION = "-c";
    private boolean coldRestart = false;
    private Task remoteCommand = null;

    public UtRestart(String hostname, boolean coldRestart) {
        this.coldRestart = coldRestart;
    }

    public UtRestart() {
    }

    public void setColdRestart(boolean coldRestart) {
        this.coldRestart = coldRestart;
    }

    public boolean isColdRestart() {
        return this.coldRestart;
    }

    public String[] getElements() {
        String[] coldRestartCmd = new String[]{UT_RESTART_CMD, COLD_RESTART_OPTION};
        String[] warmRestartCmd = new String[]{UT_RESTART_CMD};
        if (this.isColdRestart()) {
            return coldRestartCmd;
        }
        return warmRestartCmd;
    }

    public void restart(String hostname, boolean isColdRestart) throws ServiceException {
        this.setColdRestart(isColdRestart);
        this.remoteCommand = new RemoteCommand(hostname, this.getElements());
        this.remoteCommand.run();
        if (this.remoteCommand.getExitCode() != 0) {
            throw new ServiceException("server_restart_failed_alert", this.remoteCommand.getSyntax() + ":" + this.remoteCommand.getErrorMsg(), this.remoteCommand.getExitCode());
        }
    }

    public void warmRestart(String hostname) throws ServiceException {
        this.restart(hostname, false);
    }

    public void coldRestart(String hostname) throws ServiceException {
        this.restart(hostname, true);
    }

    public boolean isRunning() {
        if (this.remoteCommand != null) {
            return this.remoteCommand.isAlive();
        }
        return super.isAlive();
    }
}

