/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.jni;

import com.sun.ut.service.DesktopUnit;
import com.sun.ut.service.Host;
import com.sun.ut.service.MultiheadGroup;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.UtReader;
import com.sun.ut.service.command.UtRestartTest;
import com.sun.ut.service.jni.Datastore;
import com.sun.ut.service.jni.DatastoreFactory;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class DesktopUnitTest
extends TestCase {
    private static final String STATUS_UP = "Up";
    private static final String NO_SMARTCARD_INSERTED = "pseudo";
    private static final String[] TEST_DTU = new String[]{"111111111111", "Test Location", "Test Information"};
    private static final int WAIT_LOOPS = 20;
    private static final int WAIT_TIME = 2000;
    private Datastore ds;

    protected final void setUp() {
        this.ds = DatastoreFactory.getDatastore();
    }

    protected final void tearDown() {
        this.ds = null;
    }

    public void testAddDtu() throws ServiceException {
        if (this.ds.getDTU(TEST_DTU[0], false) != null) {
            this.ds.deleteDTU(TEST_DTU[0]);
        }
        System.out.println("Adding new DTU " + TEST_DTU[0]);
        this.ds.addDTU(TEST_DTU[0], TEST_DTU[1], TEST_DTU[2]);
        DesktopUnit dtu = this.ds.getDTU(TEST_DTU[0], false);
        DesktopUnitTest.assertNotNull((Object)dtu);
        DesktopUnitTest.assertTrue((boolean)TEST_DTU[0].equals(dtu.getId()));
        DesktopUnitTest.assertTrue((boolean)TEST_DTU[1].equals(dtu.getLocation()));
        DesktopUnitTest.assertTrue((boolean)TEST_DTU[2].equals(dtu.getDescription()));
        DesktopUnitTest.assertTrue((boolean)dtu.isRegistered());
        dtu = this.ds.getDTU(TEST_DTU[0], true);
        DesktopUnitTest.assertNotNull((Object)dtu);
        DesktopUnitTest.assertTrue((boolean)TEST_DTU[0].equals(dtu.getId()));
        DesktopUnitTest.assertTrue((boolean)TEST_DTU[1].equals(dtu.getLocation()));
        DesktopUnitTest.assertTrue((boolean)TEST_DTU[2].equals(dtu.getDescription()));
        DesktopUnitTest.assertTrue((boolean)dtu.isRegistered());
        DesktopUnitTest.assertFalse((boolean)dtu.isConnected());
        this.ds.deleteDTU(TEST_DTU[0]);
        DesktopUnitTest.assertNull((Object)this.ds.getDTU(TEST_DTU[0], false));
        System.out.println("Adding new DTU " + TEST_DTU[0]);
        this.ds.addDTU(TEST_DTU[0], TEST_DTU[1], null);
        dtu = this.ds.getDTU(TEST_DTU[0], false);
        DesktopUnitTest.assertNotNull((Object)dtu);
        DesktopUnitTest.assertTrue((boolean)TEST_DTU[0].equals(dtu.getId()));
        DesktopUnitTest.assertTrue((boolean)TEST_DTU[1].equals(dtu.getLocation()));
        DesktopUnitTest.assertTrue((dtu.getDescription().length() == 0 ? 1 : 0) != 0);
        this.ds.deleteDTU(TEST_DTU[0]);
        DesktopUnitTest.assertNull((Object)this.ds.getDTU(TEST_DTU[0], false));
        System.out.println("Adding new DTU " + TEST_DTU[0]);
        this.ds.addDTU(TEST_DTU[0], null, null);
        dtu = this.ds.getDTU(TEST_DTU[0], false);
        DesktopUnitTest.assertNotNull((Object)dtu);
        DesktopUnitTest.assertTrue((boolean)TEST_DTU[0].equals(dtu.getId()));
        DesktopUnitTest.assertTrue((dtu.getLocation().length() == 0 ? 1 : 0) != 0);
        DesktopUnitTest.assertTrue((dtu.getDescription().length() == 0 ? 1 : 0) != 0);
        this.ds.deleteDTU(TEST_DTU[0]);
        DesktopUnitTest.assertNull((Object)this.ds.getDTU(TEST_DTU[0], false));
    }

    public void testModifyDtu() throws ServiceException {
        if (this.ds.getDTU(TEST_DTU[0], false) != null) {
            this.ds.deleteDTU(TEST_DTU[0]);
        }
        this.ds.addDTU(TEST_DTU[0], TEST_DTU[1], TEST_DTU[2]);
        System.out.println("Modifying " + TEST_DTU[0]);
        this.ds.modifyDTU(TEST_DTU[0], TEST_DTU[1], null);
        DesktopUnit dtu = this.ds.getDTU(TEST_DTU[0], false);
        DesktopUnitTest.assertNotNull((Object)dtu);
        DesktopUnitTest.assertTrue((boolean)TEST_DTU[0].equals(dtu.getId()));
        DesktopUnitTest.assertTrue((boolean)TEST_DTU[1].equals(dtu.getLocation()));
        DesktopUnitTest.assertTrue((dtu.getDescription().length() == 0 ? 1 : 0) != 0);
        System.out.println("Modifying " + TEST_DTU[0]);
        this.ds.modifyDTU(TEST_DTU[0], null, null);
        dtu = this.ds.getDTU(TEST_DTU[0], false);
        DesktopUnitTest.assertNotNull((Object)dtu);
        DesktopUnitTest.assertTrue((boolean)TEST_DTU[0].equals(dtu.getId()));
        DesktopUnitTest.assertTrue((dtu.getLocation().length() == 0 ? 1 : 0) != 0);
        DesktopUnitTest.assertTrue((dtu.getDescription().length() == 0 ? 1 : 0) != 0);
        this.ds.deleteDTU(TEST_DTU[0]);
        DesktopUnitTest.assertNull((Object)this.ds.getDTU(TEST_DTU[0], false));
    }

    public void testDeleteDtu() throws ServiceException {
        if (this.ds.getDTU(TEST_DTU[0], false) != null) {
            this.ds.deleteDTU(TEST_DTU[0]);
        }
        this.ds.addDTU(TEST_DTU[0], null, null);
        DesktopUnit dtu = this.ds.getDTU(TEST_DTU[0], false);
        DesktopUnitTest.assertNotNull((Object)dtu);
        this.ds.deleteDTU(TEST_DTU[0]);
        dtu = this.ds.getDTU(TEST_DTU[0], false);
        DesktopUnitTest.assertNull((Object)dtu);
    }

    public void testGetAllRegisteredDtus() throws ServiceException {
        List dtus = this.ds.getDTUs(null);
        DesktopUnitTest.assertNotNull((String)"Error retrieving registered DTUs!", (Object)dtus);
        System.out.println("Total number of registered DTUs: " + dtus.size());
        Iterator it = dtus.iterator();
        while (it.hasNext()) {
            DesktopUnit dtu = (DesktopUnit)it.next();
            DesktopUnitTest.assertTrue((boolean)dtu.isRegistered());
        }
        this.ds.addDTU(TEST_DTU[0], null, null);
        List newDtus = this.ds.getDTUs(null);
        System.out.println("Total number of registered DTUs after new registration: " + newDtus.size());
        DesktopUnitTest.assertTrue((dtus.size() + 1 == newDtus.size() ? 1 : 0) != 0);
        this.ds.deleteDTU(TEST_DTU[0]);
        newDtus = this.ds.getDTUs(null);
        DesktopUnitTest.assertTrue((dtus.size() == newDtus.size() ? 1 : 0) != 0);
    }

    public void testGetDtus() throws ServiceException {
        Iterator it = this.ds.getHosts().iterator();
        while (it.hasNext()) {
            Host host = (Host)it.next();
            List dtus = this.ds.getConnectedDTUs(host.getName());
            Iterator dtuIt = dtus.iterator();
            while (dtuIt.hasNext()) {
                DesktopUnit dtu = (DesktopUnit)dtuIt.next();
                DesktopUnitTest.assertNotNull((Object)dtu);
                DesktopUnit dtu2 = this.ds.getDTU(dtu.getId(), true);
                DesktopUnitTest.assertNotNull((Object)dtu2);
                DesktopUnitTest.assertTrue((boolean)dtu.getServer().equals(dtu2.getServer()));
                System.out.println(dtu.getId() + ", " + dtu.getServer());
            }
        }
    }

    public void testGetConnectedtDtus() throws ServiceException {
        Iterator it = this.ds.getHosts().iterator();
        while (it.hasNext()) {
            Host host = (Host)it.next();
            List dtus = this.ds.getConnectedDTUs(host.getName());
            Iterator dtuIt = dtus.iterator();
            System.out.println("Connected DTUs at " + host.getName());
            while (dtuIt.hasNext()) {
                DesktopUnit dtu = (DesktopUnit)dtuIt.next();
                System.out.println(dtu.getId() + ", " + dtu.getLocation() + ", " + dtu.getDescription());
                DesktopUnitTest.assertTrue((boolean)host.getName().equals(dtu.getServer()));
                DesktopUnitTest.assertTrue((boolean)dtu.isConnected());
            }
        }
    }

    public void testNumberConnectedtDtus() throws ServiceException {
        Iterator it = this.ds.getHosts().iterator();
        while (it.hasNext()) {
            Host host = (Host)it.next();
            List dtus = this.ds.getConnectedDTUs(host.getName());
            DesktopUnitTest.assertTrue((this.ds.getNumberOfConnectedDTUs(host.getName()) == dtus.size() ? 1 : 0) != 0);
        }
    }

    public void testGetTokenFromtDtu() throws ServiceException {
        Iterator it = this.ds.getHosts().iterator();
        while (it.hasNext()) {
            Host host = (Host)it.next();
            List dtus = this.ds.getConnectedDTUs(host.getName());
            Iterator dtuIt = dtus.iterator();
            while (dtuIt.hasNext()) {
                DesktopUnit dtu = (DesktopUnit)dtuIt.next();
                String token = this.ds.getTokenFromDTU(host.getName(), dtu.getId());
                if (token.startsWith(NO_SMARTCARD_INSERTED)) {
                    DesktopUnitTest.assertTrue((token.indexOf(dtu.getId()) > 0 ? 1 : 0) != 0);
                }
                System.out.println(dtu.getId() + ": " + token);
            }
            DesktopUnitTest.assertNull((Object)this.ds.getTokenFromDTU(host.getName(), TEST_DTU[0]));
        }
    }

    public void testGetTokenFromInvalidReader() {
        try {
            String token = this.ds.getTokenFromReader(TEST_DTU[0]);
            DesktopUnitTest.fail((String)"Invalid token reader is accepted for retrieving tokens");
        }
        catch (ServiceException ex) {
            System.out.println("Caught expected exception.");
        }
    }

    public void testSearchDtu() throws ServiceException {
        this.ds.addDTU(TEST_DTU[0], TEST_DTU[1], TEST_DTU[2]);
        List dtus = this.ds.getDTUs("(utid=" + TEST_DTU[0] + ")");
        DesktopUnitTest.assertTrue((dtus.size() == 1 ? 1 : 0) != 0);
        dtus = this.ds.getDTUs("(utlocation=" + TEST_DTU[1] + ")");
        DesktopUnitTest.assertTrue((dtus.size() >= 1 ? 1 : 0) != 0);
        dtus = this.ds.getDTUs("(utotherinfo=" + TEST_DTU[2] + ")");
        DesktopUnitTest.assertTrue((dtus.size() >= 1 ? 1 : 0) != 0);
        String searchCriteria = "Test";
        StringBuffer filter = new StringBuffer();
        filter.append("(|(utlocation=*");
        filter.append(searchCriteria);
        filter.append("*)(utotherinfo=*");
        filter.append(searchCriteria);
        filter.append("*)(utid=*");
        filter.append(searchCriteria);
        filter.append("*))");
        dtus = this.ds.getDTUs(filter.toString());
        DesktopUnitTest.assertTrue((dtus.size() >= 1 ? 1 : 0) != 0);
        this.ds.deleteDTU(TEST_DTU[0]);
    }

    public void testGetTokenFromReader() throws ServiceException {
        DesktopUnit reader = null;
        Host host = null;
        Iterator it = this.ds.getHosts().iterator();
        while (it.hasNext()) {
            host = (Host)it.next();
            List dtus = this.ds.getConnectedDTUs(host.getName());
            Iterator dtuIt = dtus.iterator();
            if (!dtuIt.hasNext()) continue;
            reader = (DesktopUnit)dtuIt.next();
            break;
        }
        if (reader != null) {
            String token;
            UtReader readerCmd = new UtReader();
            readerCmd.addReader(reader.getId());
            System.out.println("Configured " + reader.getId() + " as token reader");
            UtRestartTest test = new UtRestartTest();
            test.setUp();
            test.testColdRestart();
            test.tearDown();
            System.out.println("Active readers:");
            List readers = this.ds.getTokenReaders();
            DesktopUnitTest.assertNotNull((Object)readers);
            Iterator readersIt = readers.iterator();
            while (readersIt.hasNext()) {
                String name = (String)readersIt.next();
                System.out.println(name);
            }
            System.out.println("Done reader list");
            for (int i = 0; i < 20; ++i) {
                DesktopUnit dtu = this.ds.getDTU(reader.getId(), true);
                if (dtu != null && dtu.getServer() != null) {
                    System.out.println("Reader is online again");
                    break;
                }
                try {
                    System.out.println("Waiting for reader connect");
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if ((token = this.ds.getTokenFromReader(reader.getId())).length() > 0) {
                System.out.println("Retrieved token from reader: " + token);
            } else {
                System.out.println("No smart card found.");
            }
            readerCmd.removeReader(reader.getId());
            test.setUp();
            test.testColdRestart();
            test.tearDown();
        } else {
            System.out.println("No dtus connected. Can not perform token reader test.");
        }
    }

    public void testGetMultiheadGroups() throws ServiceException {
        List groups = this.ds.getMultiheadGroups();
        DesktopUnitTest.assertNotNull((Object)groups);
        if (groups.size() > 0) {
            Iterator it = groups.iterator();
            System.out.println("Multihead groups:");
            while (it.hasNext()) {
                MultiheadGroup multi = (MultiheadGroup)it.next();
                System.out.println(multi.getName() + ", " + multi.getGeometry());
            }
        } else {
            System.out.println("No multihead groups found");
        }
    }

    public void testGetMultiheadGroup() throws ServiceException {
        DesktopUnitTest.assertNull((Object)this.ds.getMultiheadGroup(TEST_DTU[0]));
        List groups = this.ds.getMultiheadGroups();
        DesktopUnitTest.assertNotNull((Object)groups);
        if (groups.size() > 0) {
            Iterator it = groups.iterator();
            System.out.println("Multihead groups:");
            while (it.hasNext()) {
                MultiheadGroup multi = (MultiheadGroup)it.next();
                MultiheadGroup multi2 = this.ds.getMultiheadGroup(multi.getName());
                DesktopUnitTest.assertTrue((boolean)multi.getGeometry().equals(multi2.getGeometry()));
                DesktopUnitTest.assertTrue((boolean)multi.getPrimaryDTU().equals(multi2.getPrimaryDTU()));
                String[] members = multi2.getMembers();
                for (int i = 0; i < members.length; ++i) {
                    System.out.print(members[i] + " ");
                }
                System.out.println("=> " + multi2.getName());
            }
        } else {
            System.out.println("No multihead groups found");
        }
    }
}

