/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.jni;

import com.sun.ut.service.Policy;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.jni.Datastore;
import com.sun.ut.service.jni.DatastoreFactory;
import junit.framework.TestCase;

public class PolicyTest
extends TestCase {
    private Datastore ds;

    protected final void setUp() throws ServiceException {
        this.ds = DatastoreFactory.getDatastore();
    }

    protected final void tearDown() {
        this.ds = null;
    }

    public void testPolicyGetContent() {
        Policy policy = new Policy();
        policy.setMultihead(true);
        System.out.println("Multihead enabled: " + policy.getContent());
        PolicyTest.assertTrue((policy.getContent().indexOf("-m") >= 0 ? 1 : 0) != 0);
        policy.setNscm(true);
        System.out.println("NSCM enabled: " + policy.getContent());
        PolicyTest.assertTrue((policy.getContent().indexOf("-M") >= 0 ? 1 : 0) != 0);
        policy.setUnixAuthentication(false);
        System.out.println("Unix authentication disabled: " + policy.getContent());
        PolicyTest.assertTrue((policy.getContent().indexOf("-p") >= 0 ? 1 : 0) != 0);
        policy.setNscm(false);
        System.out.println("NSCM disabled: " + policy.getContent());
        PolicyTest.assertFalse((policy.getContent().indexOf("-M") >= 0 ? 1 : 0) != 0);
        policy.setMultihead(false);
        System.out.println("Multihead disabled: " + policy.getContent());
        PolicyTest.assertFalse((policy.getContent().indexOf("-m") >= 0 ? 1 : 0) != 0);
        policy.setUnixAuthentication(true);
        System.out.println("Unix authentication enabled: " + policy.getContent());
        PolicyTest.assertFalse((policy.getContent().indexOf("-p") >= 0 ? 1 : 0) != 0);
        policy.setNscmExit(false);
        System.out.println("NSCM exit disabled: " + policy.getContent());
        PolicyTest.assertTrue((policy.getContent().indexOf("-d") >= 0 ? 1 : 0) != 0);
        policy.setKioskMode("both");
        System.out.println("Kiosk enabled for both: " + policy.getContent());
        PolicyTest.assertTrue((policy.getContent().indexOf("-k") >= 0 ? 1 : 0) != 0);
        PolicyTest.assertTrue((policy.getContent().indexOf("both") >= 0 ? 1 : 0) != 0);
        policy.setKioskMode("card");
        System.out.println("Kiosk enabled for card: " + policy.getContent());
        PolicyTest.assertTrue((policy.getContent().indexOf("-k") >= 0 ? 1 : 0) != 0);
        PolicyTest.assertTrue((policy.getContent().indexOf("card") >= 0 ? 1 : 0) != 0);
        policy.setKioskMode("pseudo");
        System.out.println("Kiosk enabled for pseudo: " + policy.getContent());
        PolicyTest.assertTrue((policy.getContent().indexOf("-k") >= 0 ? 1 : 0) != 0);
        PolicyTest.assertTrue((policy.getContent().indexOf("pseudo") >= 0 ? 1 : 0) != 0);
        policy.setKioskMode(null);
        System.out.println("Kiosk disabled: " + policy.getContent());
        PolicyTest.assertFalse((policy.getContent().indexOf("-k") >= 0 ? 1 : 0) != 0);
        PolicyTest.assertFalse((policy.getContent().indexOf("pseudo") >= 0 ? 1 : 0) != 0);
        policy.setNscmExit(true);
        System.out.println("NSCM exit enabled: " + policy.getContent());
        PolicyTest.assertFalse((policy.getContent().indexOf("-d") >= 0 ? 1 : 0) != 0);
        policy.setRegisteredTokensAccess("both");
        System.out.println("Access for registered tokens both: " + policy.getContent());
        PolicyTest.assertTrue((policy.getContent().indexOf("-r") >= 0 ? 1 : 0) != 0);
        PolicyTest.assertTrue((policy.getContent().indexOf("both") >= 0 ? 1 : 0) != 0);
        policy.setRegisteredTokensAccess(null);
        System.out.println("Access for registered tokens disabled: " + policy.getContent());
        PolicyTest.assertFalse((policy.getContent().indexOf("-r") >= 0 ? 1 : 0) != 0);
        PolicyTest.assertFalse((policy.getContent().indexOf("both") >= 0 ? 1 : 0) != 0);
        policy.setRegisteredTokensAccess("card");
        System.out.println("Access for registered tokens card: " + policy.getContent());
        PolicyTest.assertTrue((policy.getContent().indexOf("-r") >= 0 ? 1 : 0) != 0);
        PolicyTest.assertTrue((policy.getContent().indexOf("card") >= 0 ? 1 : 0) != 0);
        policy.setSelfRegisteredTokensAccess("card");
        System.out.println("Access for self-registered tokens card: " + policy.getContent());
        PolicyTest.assertTrue((policy.getContent().indexOf("-s") >= 0 ? 1 : 0) != 0);
    }

    public void testPolicySetContent() {
        Policy policy = new Policy();
        policy.setContent("-m");
        System.out.println("Multihead enabled: " + policy.getContent());
        PolicyTest.assertTrue((boolean)policy.isMultiheadEnabled());
        policy.setContent("-m -M");
        System.out.println("NSCM enabled: " + policy.getContent());
        PolicyTest.assertTrue((boolean)policy.isMultiheadEnabled());
        PolicyTest.assertTrue((boolean)policy.isNscmEnabled());
        PolicyTest.assertTrue((boolean)policy.isUnixAuthenticationRequired());
        policy.setContent("-k both");
        System.out.println("Kiosk enabled for both: " + policy.getContent());
        PolicyTest.assertTrue((boolean)policy.getKioskMode().equals("both"));
        policy.setContent("-m -M -p -r card");
        System.out.println("Policy set to: " + policy.getContent());
        PolicyTest.assertTrue((boolean)policy.getRegisteredTokensAccess().equals("card"));
        PolicyTest.assertTrue((boolean)policy.isMultiheadEnabled());
        PolicyTest.assertTrue((boolean)policy.isNscmEnabled());
        PolicyTest.assertFalse((boolean)policy.isUnixAuthenticationRequired());
        policy.setContent("-r pseudo -s pseudo -d -k both");
        System.out.println("Policy set to: " + policy.getContent());
        PolicyTest.assertTrue((boolean)policy.getRegisteredTokensAccess().equals("pseudo"));
        PolicyTest.assertTrue((boolean)policy.getSelfRegisteredTokensAccess().equals("pseudo"));
        PolicyTest.assertTrue((boolean)policy.getKioskMode().equals("both"));
        PolicyTest.assertFalse((boolean)policy.isNscmExitAllowed());
    }

    public void testSetPolicy() throws ServiceException {
        Policy policy = new Policy();
        policy.setRegisteredTokensAccess("pseudo");
        policy.setNscm(true);
        System.out.println("Policy set to " + policy.getContent());
        this.ds.modifyPolicy(policy.getContent());
        String content = this.ds.getPolicy();
        PolicyTest.assertNotNull((String)"Failed to retrieve new policy", (Object)content);
        System.out.println("Policy retrieved from datastore " + content);
        Policy p = new Policy(content);
        PolicyTest.assertTrue((boolean)p.isNscmEnabled());
        PolicyTest.assertTrue((boolean)p.getRegisteredTokensAccess().equals("pseudo"));
    }

    public void testRemovePolicy() throws ServiceException {
        System.out.println("Set empty policy");
        this.ds.modifyPolicy("");
        String content = this.ds.getPolicy();
        PolicyTest.assertNotNull((String)"Failed to retrieve new policy", (Object)content);
        Policy p = new Policy(content);
        PolicyTest.assertTrue((boolean)p.isUnixAuthenticationRequired());
    }
}

