/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.jni;

import com.sun.ut.service.Host;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.jni.Datastore;
import com.sun.ut.service.jni.DatastoreFactory;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class ServerTest
extends TestCase {
    private Datastore ds;

    protected final void setUp() {
        this.ds = DatastoreFactory.getDatastore();
    }

    protected final void tearDown() {
        this.ds = null;
    }

    public void testGetTrustedAndAvailableServers() throws ServiceException {
        List hosts = this.ds.getHosts();
        ServerTest.assertNotNull((String)"No Sun Ray servers found!", (Object)hosts);
        ServerTest.assertFalse((String)"Returned server number is 0!", (boolean)hosts.isEmpty());
        Iterator it = hosts.iterator();
        while (it.hasNext()) {
            Host host = (Host)it.next();
            System.out.println(host.getName() + ", " + host.getStartTime() + ", " + host.getPrimaryAddress());
        }
    }

    public void testGetHostsWithInterfaces() throws ServiceException {
        List hosts = this.ds.getHostsWithInterfaces("localhost");
        ServerTest.assertNotNull((String)"No Sun Ray servers found!", (Object)hosts);
        ServerTest.assertFalse((String)"Returned server number is 0!", (boolean)hosts.isEmpty());
        Iterator it = hosts.iterator();
        while (it.hasNext()) {
            Host host = (Host)it.next();
            System.out.println("Server: '" + host.getName() + "'");
            ServerTest.assertTrue((host.getName().length() > 0 ? 1 : 0) != 0);
        }
    }

    public void testGetDiskSpace() throws ServiceException {
        long[] info = this.ds.getDiskSpace("/");
        System.out.println("Disk space info for: '/'");
        this.assertDiskSpace(info);
        info = this.ds.getDiskSpace("/tmp");
        System.out.println("Disk space info for: '/tmp'");
        this.assertDiskSpace(info);
    }

    public void testGetSwapSpace() throws ServiceException {
        long[] info = this.ds.getSwapSpace();
        System.out.println("Swap space info:");
        this.assertDiskSpace(info);
    }

    private void assertDiskSpace(long[] info) throws ServiceException {
        ServerTest.assertNotNull((Object)info);
        long total = info[0];
        long available = info[1];
        long occupied = info[2];
        System.out.println("(total/occupied/available): " + total + ", " + occupied + ", " + available);
        ServerTest.assertFalse((total == 0L ? 1 : 0) != 0);
        ServerTest.assertFalse((available == 0L ? 1 : 0) != 0);
        ServerTest.assertTrue((String)"Error total disk space is less than available space", (available <= total ? 1 : 0) != 0);
        ServerTest.assertTrue((String)"Error total disk space is less than occupied space", (occupied <= total ? 1 : 0) != 0);
    }
}

