/*
 * Decompiled with CFR 0.152.
 */
package auth.sdk;

import auth.sdk.Syslog;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Log {
    private static Log theLog = null;
    private static boolean addTimeStamp = false;
    private static int debugPri = -1;
    private static int clientErrPri = 4;
    private static int unexpectedErrorPri = 3;
    private static int noticePri = 5;
    private static int warningPri = 4;
    private static int configErrorPri = 2;

    private Log(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        addTimeStamp = bl;
        debugPri = n;
        clientErrPri = n2;
        unexpectedErrorPri = n3;
        noticePri = n4;
        configErrorPri = n6;
    }

    public static synchronized void init(String string, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7) throws Exception {
        if (theLog != null) {
            Log.unexpectedError("Attempt to reconfigure the Log class");
            return;
        }
        theLog = new Log(bl, n2, n3, n4, n5, n6, n7);
        Syslog.init("utauthd", n);
    }

    private static void log(int n, String string) {
        Object object;
        String string2 = Thread.currentThread().getName();
        String string3 = "";
        if (n == -1) {
            return;
        }
        if (addTimeStamp) {
            object = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS zzz ");
            string3 = ((DateFormat)object).format(new Date());
        }
        object = string3 + string2 + " " + string;
        Syslog.syslog(n, (String)object);
    }

    public static void debug(String string) {
        Log.log(debugPri, "DEBUG: " + string);
    }

    public static void clientError(String string) {
        Log.log(warningPri, "CLIENT_ERROR: " + string);
    }

    public static void unexpectedError(String string) {
        Log.log(unexpectedErrorPri, "UNEXPECTED: " + string);
    }

    public static void notice(String string) {
        Log.log(noticePri, "NOTICE: " + string);
    }

    public static void configError(String string) {
        Log.log(configErrorPri, "CONFIG_ERROR: " + string);
    }
}

