/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.AccessControl;
import auth.sdk.Authentication;
import auth.sdk.AuthenticationClient;
import auth.sdk.Log;
import auth.utauthd.AuthClassLoader;
import auth.utauthd.Configuration;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class AuthModule {
    private static AuthClassLoader loader = null;
    private static Vector module = new Vector();
    private String name;
    private Authentication auth;
    String moduleType;
    private File configFile;

    public String getName() {
        return this.name;
    }

    public static boolean loadAllModules(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            String string = (String)hashtable.get("name");
            String string2 = (String)hashtable.get("param");
            if (!AuthModule.load(Configuration.root.getAbsolutePath(), string, string2)) {
                Log.configError((String)("Cannot find module " + Configuration.root.getAbsolutePath() + File.separator + string));
                return false;
            }
            Log.notice((String)("Loaded module " + Configuration.root.getAbsolutePath() + File.separator + string));
        }
        int n = AuthModule.nLoaded();
        Log.notice((String)(n + " authentication module" + (n == 1 ? "" : "s") + " loaded."));
        return n > 0;
    }

    public static boolean load(String string, String string2, String string3) {
        String string4;
        int n;
        if (loader == null) {
            loader = new AuthClassLoader(string);
        }
        if ((n = string2.indexOf(46)) == -1) {
            string4 = string2;
        } else {
            if (n == 0) {
                return false;
            }
            string4 = string2.substring(0, n);
        }
        string4 = "auth.module." + string4 + "." + string4;
        AuthModule authModule = new AuthModule(string2, string3);
        try {
            int n2;
            Log.debug((String)("Loading " + string4));
            Class<?> clazz = loader.loadClass(string4);
            Class<?>[] classArray = clazz.getInterfaces();
            for (n2 = 0; n2 < classArray.length; ++n2) {
                Log.debug((String)(clazz + " implements " + Modifier.toString(classArray[n2].getModifiers()) + " " + classArray[n2]));
            }
            n2 = clazz.getModifiers();
            if (!Modifier.isPublic(n2)) {
                return false;
            }
            String string5 = new String();
            Method method = clazz.getMethod("getAuthenticationObject", string5.getClass(), string5.getClass());
            if (method == null) {
                return false;
            }
            n2 = method.getModifiers();
            if (!Modifier.isStatic(n2) || !Modifier.isPublic(n2)) {
                return false;
            }
            try {
                authModule.auth = (Authentication)method.invoke(null, string2, string3);
            }
            catch (IllegalAccessException illegalAccessException) {
                authModule = null;
                Log.configError((String)("AuthModule.load(" + string4 + "): " + illegalAccessException));
                return false;
            }
            if (authModule.auth == null) {
                Log.configError((String)("XXX CANNOT instantiate module instance=" + string2 + " param=\"" + string3 + "\""));
                return false;
            }
            module.addElement(authModule);
            return true;
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("Error " + exception + "\n\t" + "while instantiating module. " + "instance=" + string2 + " param=\"" + string3 + "\""));
            return false;
        }
    }

    public static int nLoaded() {
        return module.size();
    }

    public static void unload() {
    }

    private AuthModule() {
    }

    private AuthModule(String string, String string2) {
        int n = string.indexOf(46);
        this.name = string;
        this.moduleType = n == -1 ? this.name : string.substring(0, n);
    }

    public boolean isConfigured() {
        return this.auth != null;
    }

    public static AuthenticationClient select(Hashtable hashtable, AccessControl accessControl) {
        int n = 0;
        if (hashtable.get("currentMod") != null) {
            n = (Integer)hashtable.get("currentMod") + 1;
        }
        for (int i = n; i < module.size(); ++i) {
            AuthModule authModule = (AuthModule)module.elementAt(i);
            Log.debug((String)("AuthModule.select: Query " + authModule.getName() + " with param=" + hashtable));
            if (!authModule.isConfigured()) {
                Log.unexpectedError((String)("UNCONFIGUED MODULE " + authModule.getName()));
                continue;
            }
            AuthenticationClient authenticationClient = authModule.auth.isMyTokenType(hashtable, accessControl);
            if (authenticationClient == null) continue;
            Log.notice((String)("CLAIMED by " + authModule.getName() + " NAME: " + authenticationClient.getGlobalName() + " PARAMETERS: " + hashtable));
            hashtable.put("currentMod", new Integer(i));
            return authenticationClient;
        }
        Log.notice((String)("NOT_CLAIMED PARAMETERS: " + hashtable));
        return null;
    }
}

