/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import java.io.FileDescriptor;
import java.io.InterruptedIOException;
import java.lang.reflect.Field;

public class Poller {
    public static final short POLLIN = 1;
    public static final short POLLPRI = 2;
    public static final short POLLOUT = 4;
    public static final short POLLERR = 8;
    public static final short POLLHUP = 16;
    public static final short POLLNVAL = 32;
    public static final short POLLRDNORM = 64;
    public static final short POLLWRNORM = 4;
    public static final short POLLRDBAND = 128;
    public static final short POLLWRBAND = 256;
    public static final short POLLNORM = 64;
    public static final short POLLTIMEOUT = 4096;
    private static final Object globalSync = new Object();
    private int handle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Poller() throws Exception {
        Object object = globalSync;
        synchronized (object) {
            this.handle = this.nativeCreatePoller(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Poller(int n) throws Exception {
        Object object = globalSync;
        synchronized (object) {
            this.handle = this.nativeCreatePoller(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = globalSync;
        synchronized (object) {
            this.nativeDestroyPoller(this.handle);
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(int n) throws Exception {
        Object object = globalSync;
        synchronized (object) {
            this.nativeDestroyPoller(this.handle);
            this.handle = this.nativeCreatePoller(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws Exception {
        Object object = globalSync;
        synchronized (object) {
            this.nativeDestroyPoller(this.handle);
            this.handle = this.nativeCreatePoller(-1);
        }
    }

    public synchronized int add(FileDescriptor fileDescriptor, short s) throws Exception {
        return this.nativeAddFd(this.handle, this.findfd(fileDescriptor), s);
    }

    public synchronized boolean remove(FileDescriptor fileDescriptor) throws Exception {
        return this.nativeRemoveFd(this.handle, this.findfd(fileDescriptor)) == 1;
    }

    public synchronized boolean isMember(FileDescriptor fileDescriptor) throws Exception {
        return this.nativeIsMember(this.handle, this.findfd(fileDescriptor)) == 1;
    }

    public synchronized int waitMultiple(int n, int[] nArray, short[] sArray, long l) throws Exception {
        int n2;
        if (sArray == null || nArray == null) {
            if (n > 0) {
                throw new NullPointerException("fds or revents is null");
            }
        } else if (n < 0 || n > sArray.length || n > nArray.length) {
            throw new IllegalArgumentException("maxRet out of range");
        }
        if ((n2 = this.nativeWait(this.handle, n, nArray, sArray, l)) < 0) {
            throw new InterruptedIOException();
        }
        return n2;
    }

    public int waitMultiple(int n, int[] nArray, short[] sArray) throws Exception {
        return this.waitMultiple(n, nArray, sArray, -1L);
    }

    public synchronized int waitMultiple(int[] nArray, short[] sArray, long l) throws Exception {
        if (sArray == null && nArray == null) {
            return this.nativeWait(this.handle, 0, null, null, l);
        }
        if (sArray == null || nArray == null) {
            throw new NullPointerException("revents or fds is null");
        }
        if (nArray.length == sArray.length) {
            return this.nativeWait(this.handle, nArray.length, nArray, sArray, l);
        }
        throw new IllegalArgumentException("fds.length != revents.length");
    }

    public int waitMultiple(int[] nArray, short[] sArray) throws Exception {
        if (sArray == null || nArray == null) {
            throw new NullPointerException("fds or revents is null");
        }
        if (nArray.length == sArray.length) {
            return this.waitMultiple(sArray.length, nArray, sArray, -1L);
        }
        throw new IllegalArgumentException("fds.length != revents.length");
    }

    protected int findfd(FileDescriptor fileDescriptor) throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = fileDescriptor.getClass();
        Field field = clazz.getDeclaredField("fd");
        field.setAccessible(true);
        return (Integer)field.get(fileDescriptor);
    }

    private static native int nativeInit();

    private native int nativeCreatePoller(int var1) throws Exception;

    private native void nativeDestroyPoller(int var1) throws Exception;

    private native int nativeAddFd(int var1, int var2, short var3) throws Exception;

    private native int nativeRemoveFd(int var1, int var2) throws Exception;

    private native int nativeRemoveIndex(int var1, int var2) throws Exception;

    private native int nativeIsMember(int var1, int var2) throws Exception;

    private native int nativeWait(int var1, int var2, int[] var3, short[] var4, long var5) throws Exception;

    public static native int getNumCPUs();

    static {
        System.loadLibrary("poller");
        Poller.nativeInit();
    }
}

