/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.advanced;

import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.ut.console.BaseHandler;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.SmartCard;
import com.sun.web.ui.model.Option;
import java.util.ArrayList;
import java.util.List;

public class SmartCardHandler
extends BaseHandler {
    private TableDataProvider registeredSmartCards;
    private Option[] items;
    private String[] selected;

    public SmartCardHandler() {
        this.getRegisteredSmartCards();
        this.getItems();
    }

    public TableDataProvider getRegisteredSmartCards() {
        if (this.registeredSmartCards == null) {
            try {
                List smartCards = this.getProvider().getRegisteredSmartCards();
                this.registeredSmartCards = new ObjectListDataProvider(smartCards);
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("probe_alert_get", se);
            }
        }
        return this.registeredSmartCards;
    }

    public Option[] getItems() {
        if (this.items == null) {
            List smartCards = new ArrayList();
            try {
                smartCards = this.getProvider().getAvailableSmartCards();
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("probe_alert_get", se);
            }
            this.items = new Option[smartCards.size()];
            for (int i = 0; i < this.items.length; ++i) {
                SmartCard smartCard = (SmartCard)smartCards.get(i);
                this.items[i] = new Option((Object)(smartCard.getName() + " (" + smartCard.getVersion() + ")"));
            }
        }
        return this.items;
    }

    public String[] getSelected() {
        if (this.selected == null) {
            List smartCards = new ArrayList();
            try {
                smartCards = this.getProvider().getRegisteredSmartCards();
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("probe_alert_get", se);
            }
            this.selected = new String[smartCards.size()];
            for (int i = 0; i < this.selected.length; ++i) {
                SmartCard smartCard = (SmartCard)smartCards.get(i);
                this.selected[i] = smartCard.getName() + " (" + smartCard.getVersion() + ")";
            }
        }
        return this.selected;
    }

    public void setItems(Option[] items) {
        this.items = items;
    }

    public void setSelected(String[] selected) {
        this.selected = selected;
    }

    public String save() {
        ArrayList<SmartCard> newSmartCards = new ArrayList<SmartCard>();
        for (int i = 0; i < this.selected.length; ++i) {
            String s = this.selected[i];
            int index = s.indexOf(" (");
            int end = s.indexOf(")");
            if (index <= 0 || end <= index) continue;
            String name = s.substring(0, index);
            String version = s.substring(index + 2, end);
            SmartCard smartCard = new SmartCard(name, null, null, null, version, null, null, null);
            newSmartCards.add(smartCard);
        }
        try {
            this.getProvider().saveSmartCards(newSmartCards);
            Object[] args = new Object[]{this.getSmartCardsString(newSmartCards)};
            this.getAuditService().publishEvent("Smartcards", "smart_card_order_changed", args, 0);
            this.getNotification().setRestartRequired(true);
            this.getStatusMessage().restartRequired(true);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("probe_alert_save", se);
            return "";
        }
        return "viewProbeOrder";
    }

    private String getSmartCardsString(List cardsList) {
        String cards = "";
        if (cardsList != null && cardsList.size() != 0) {
            cards = cards + "[";
            for (int i = 0; i < cardsList.size(); ++i) {
                SmartCard card = (SmartCard)cardsList.get(i);
                cards = i == 0 ? cards + card.getName() : cards + ", " + card.getName();
            }
            cards = cards + "]";
        }
        return cards;
    }
}

