/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.dtus;

import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.ut.console.I18N;
import com.sun.ut.console.dtus.DesktopUnitHelper;
import com.sun.ut.console.dtus.DesktopUnitsHandler;
import com.sun.ut.service.DesktopUnit;
import com.sun.ut.service.MultiheadGroup;
import com.sun.ut.service.ServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SearchResultsHandler
extends DesktopUnitsHandler {
    public TableDataProvider getDtus() {
        String filter = DesktopUnitHelper.getSearchCriteria().getFilter();
        String searchString = DesktopUnitHelper.getSearchCriteria().getSearchString();
        this.setDtusList(Collections.EMPTY_LIST);
        try {
            if (filter.equals("all")) {
                this.setDtusList(this.getProvider().searchDTUs(searchString));
            } else {
                if (filter.equals("current")) {
                    this.setDtusList(this.getProvider().getCurrentDTUs());
                } else if (filter.equals("readers")) {
                    this.setDtusList(this.getProvider().getTokenReaders());
                } else if (filter.equals("multiheads")) {
                    List mhgList = null;
                    mhgList = this.getProvider().getMultiheadGroups();
                    this.setDtusList(new ArrayList());
                    if (mhgList != null) {
                        Iterator mhgIt = mhgList.iterator();
                        while (mhgIt.hasNext()) {
                            MultiheadGroup group = (MultiheadGroup)mhgIt.next();
                            String primaryDtuId = group.getPrimaryDTU();
                            DesktopUnit primaryDtu = null;
                            primaryDtu = this.getProvider().getDTU(primaryDtuId);
                            primaryDtu.setMultiheadGroup(group);
                            this.getDtusList().add(primaryDtu);
                        }
                    }
                }
                this.filter(this.getDtusList());
            }
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error(se);
        }
        return new ObjectListDataProvider(this.getDtusList());
    }

    public String getTableTooltip() {
        String filter = DesktopUnitHelper.getSearchCriteria().getFilter();
        Object[] args = new String[]{I18N.getResource("dtus_tab_label")};
        if (filter.equals("multiheads")) {
            args[0] = I18N.getResource("dtu_title_multihead");
        } else if (filter.equals("current")) {
            args[0] = I18N.getResource("dtu_title_current");
        } else if (filter.equals("readers")) {
            args[0] = I18N.getResource("dtu_title_token_readers");
        }
        return I18N.getResource("dtu_table_search_tooltip", args);
    }

    public String getBackToLabel() {
        Object[] args = new Object[]{this.getServerName()};
        return I18N.getResource("back_to_button2", args);
    }

    protected void filter(List list) {
        String searchString = DesktopUnitHelper.getSearchCriteria().getSearchString();
        if (searchString.length() > 0) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                DesktopUnit dtu = (DesktopUnit)it.next();
                if (this.matchSearchString(searchString, dtu)) continue;
                it.remove();
            }
        }
    }

    protected boolean matchSearchString(String searchString, DesktopUnit dtu) {
        boolean foundMatch = false;
        String search = searchString.toUpperCase();
        if ("*".equals(search)) {
            foundMatch = true;
        } else if (dtu.getId().toUpperCase().indexOf(search) >= 0) {
            foundMatch = true;
        } else if (dtu.getLocation() != null && dtu.getLocation().toUpperCase().indexOf(search) >= 0) {
            foundMatch = true;
        } else if (dtu.getDescription() != null && dtu.getDescription().toUpperCase().indexOf(search) >= 0) {
            foundMatch = true;
        } else if (dtu.getServer() != null && dtu.getServer().toUpperCase().indexOf(search) >= 0) {
            foundMatch = true;
        } else if (dtu.getMultiheadGroup() != null && dtu.getMultiheadGroup().getName() != null && dtu.getMultiheadGroup().getName().toUpperCase().indexOf(search) >= 0) {
            foundMatch = true;
        }
        return foundMatch;
    }
}

