/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.server;

import com.sun.ut.console.I18N;

public class DiskSpaceInfo {
    public static final String USED_COLOR = "#5382A1";
    public static final String CRITICAL_COLOR = "#E76F00";
    public static final String AVAILABLE_COLOR = "#BDBEC0";
    private static final int HUNDRED_PERCENT = 100;
    private static final int CRITICAL_DISK_USAGE = 90;
    private static final int MIN_PERCENT = 3;
    private String description;
    private long available;
    private long used;
    private long total;
    private long usedPercent;
    private long availablePercent;

    public DiskSpaceInfo(String description, long used, long available, long total) {
        this.description = description;
        this.available = available;
        this.used = used;
        this.total = total;
        this.usedPercent = used * 100L / total;
        this.availablePercent = 100L - this.usedPercent;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTotal() {
        return Long.toString(this.total);
    }

    public String getAvailable() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.availablePercent);
        buffer.append("% (");
        buffer.append(this.available);
        buffer.append(")");
        return buffer.toString();
    }

    public String getUsed() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.usedPercent);
        buffer.append("% (");
        buffer.append(this.used);
        buffer.append(")");
        return buffer.toString();
    }

    public String getChart() {
        Object[] args = new String[]{this.usedPercent + "%"};
        String title = I18N.getResource("serverDetails_graph_tooltip", args);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table width=\"100%\" title=\"");
        buffer.append(title);
        buffer.append("\" style=\"border: 0px solid; border-spacing: 0px; padding: 0px !important; height: 10px;\">");
        buffer.append("<tr width=\"100%\">");
        if (this.usedPercent >= 3L) {
            buffer.append("<td width=\"");
            buffer.append(this.usedPercent);
            buffer.append("%\" style=\"border: 0px !important; background: ");
            if (this.usedPercent > 90L) {
                buffer.append(CRITICAL_COLOR);
            } else {
                buffer.append(USED_COLOR);
            }
            buffer.append("; height: 10px;\">");
            buffer.append("<div style=\"height: 5px;\">&nbsp;</div>");
            buffer.append("</td>");
        }
        buffer.append("<td width=\"");
        buffer.append(this.availablePercent);
        buffer.append("%\" style=\"border: 0px !important; background: ");
        buffer.append(AVAILABLE_COLOR);
        buffer.append("; height: 10px;\">");
        buffer.append("<div style=\"height: 5px;\">&nbsp;</div>");
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("</table>");
        return buffer.toString();
    }
}

