/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.server;

import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.I18N;
import com.sun.ut.console.InterfaceWrapper;
import com.sun.ut.console.server.ServerHelper;
import com.sun.ut.service.Host;
import com.sun.ut.service.Interface;
import com.sun.ut.service.ServiceException;
import com.sun.web.ui.component.ImageComponent;
import com.sun.web.ui.component.StaticText;
import com.sun.web.ui.component.Table;
import com.sun.web.ui.component.TableColumn;
import com.sun.web.ui.component.TableRowGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;

public class NetworkStatusHandler
extends BaseHandler {
    private String selectedHostName;
    private Host selectedHost;
    private List hosts;
    private List trustedHosts = new ArrayList();
    private List networks = new ArrayList();
    private Table table;

    public NetworkStatusHandler() {
        this.getTable();
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        if (this.table == null) {
            this.getSelectedHostName();
            this.hosts = new ArrayList();
            try {
                this.hosts = this.getProvider().getHostsWithInterfaces(this.selectedHostName);
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error(se);
            }
            TreeSet set = new TreeSet();
            for (int i = 0; i < this.hosts.size(); ++i) {
                Host host = (Host)this.hosts.get(i);
                if (host.getName().equals(this.selectedHostName)) {
                    this.selectedHost = host;
                } else if (host.isTrusted()) {
                    this.trustedHosts.add(host);
                }
                Map ifaces = host.getInterfaces();
                if (ifaces == null) continue;
                set.addAll(ifaces.keySet());
                Iterator it = ifaces.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    entry.setValue(new InterfaceWrapper((Interface)entry.getValue()));
                }
            }
            this.networks.addAll(set);
            this.table = new Table();
            this.table.setTitle(I18N.getResource("network_pageTitle"));
            this.table.setTransient(true);
            TableRowGroup rowGroup = this.buildRowGroup("selectedHosts");
            this.table.getChildren().add(rowGroup);
            rowGroup = this.buildRowGroup("trustedHosts");
            rowGroup.setHeaderText(I18N.getResource("network_trusted_servers_header"));
            rowGroup.setGroupToggleButton(true);
            this.table.getChildren().add(rowGroup);
        }
        return this.table;
    }

    public String getSelectedHostName() {
        this.selectedHostName = ServerHelper.getSelectedId();
        return this.selectedHostName;
    }

    public ObjectListDataProvider getSelectedHosts() {
        ArrayList<Host> list = new ArrayList<Host>();
        if (this.selectedHost != null) {
            list.add(this.selectedHost);
        }
        return new ObjectListDataProvider(list);
    }

    public ObjectListDataProvider getTrustedHosts() {
        return new ObjectListDataProvider(this.trustedHosts);
    }

    public String getBackToLabel() {
        Object[] args = new Object[]{this.getSelectedHostName()};
        return I18N.getResource("back_to_button2", args);
    }

    private TableRowGroup buildRowGroup(String binding) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        String sourceVar = binding + "RowGroup";
        TableRowGroup rowGroup = new TableRowGroup();
        rowGroup.setValueBinding("sourceData", application.createValueBinding("#{networkStatusHandler." + binding + "}"));
        rowGroup.setSourceVar(sourceVar);
        TableColumn column = new TableColumn();
        if (binding.equals("selectedHosts")) {
            column.setHeaderText(I18N.getResource("network_server_header"));
        }
        StaticText staticText = new StaticText();
        staticText.setValueBinding("text", application.createValueBinding("#{" + sourceVar + ".value.name}"));
        column.getChildren().add(staticText);
        rowGroup.getChildren().add(column);
        for (int i = 0; i < this.networks.size(); ++i) {
            String network = (String)this.networks.get(i);
            column = new TableColumn();
            if (binding.equals("selectedHosts")) {
                column.setHeaderText(network);
            }
            TableColumn col = new TableColumn();
            if (binding.equals("selectedHosts")) {
                col.setHeaderText(I18N.getResource("network_address_header"));
            }
            staticText = new StaticText();
            staticText.setValueBinding("text", application.createValueBinding("#{" + sourceVar + ".value.interfaces['" + network + "'].address}"));
            col.getChildren().add(staticText);
            column.getChildren().add(col);
            col = new TableColumn();
            if (binding.equals("selectedHosts")) {
                col.setHeaderText(I18N.getResource("network_status_header"));
            }
            ImageComponent image = new ImageComponent();
            image.setIcon("ALERT_OK_SMALL");
            image.setValueBinding("rendered", application.createValueBinding("#{!empty " + sourceVar + ".value.interfaces['" + network + "'].address and " + sourceVar + ".value.interfaces['" + network + "'].up}"));
            col.getChildren().add(image);
            image = new ImageComponent();
            image.setIcon("ALARM_CRITICAL_MEDIUM");
            image.setValueBinding("rendered", application.createValueBinding("#{!empty " + sourceVar + ".value.interfaces['" + network + "'].address and !" + sourceVar + ".value.interfaces['" + network + "'].up}"));
            col.getChildren().add(image);
            staticText = new StaticText();
            staticText.setText((Object)"&#160;");
            staticText.setEscape(false);
            col.getChildren().add(staticText);
            staticText = new StaticText();
            staticText.setValueBinding("text", application.createValueBinding("#{" + sourceVar + ".value.interfaces['" + network + "'].status}"));
            col.getChildren().add(staticText);
            column.getChildren().add(col);
            col = new TableColumn();
            if (binding.equals("selectedHosts")) {
                col.setHeaderText(I18N.getResource("network_type_header"));
            }
            staticText = new StaticText();
            staticText.setValueBinding("text", application.createValueBinding("#{" + sourceVar + ".value.interfaces['" + network + "'].type}"));
            col.getChildren().add(staticText);
            column.getChildren().add(col);
            rowGroup.getChildren().add(column);
        }
        return rowGroup;
    }
}

