/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.server;

import com.sun.ut.service.AdminContext;
import com.sun.ut.service.Host;
import com.sun.ut.service.ServiceException;

public class RestartServicesTask
extends Thread {
    private Host host;
    private boolean isColdRestart;
    private AdminContext ctx;

    public RestartServicesTask(AdminContext ctx, Host host, boolean isColdRestart) {
        this.ctx = ctx;
        this.host = host;
        this.isColdRestart = isColdRestart;
    }

    public void run() {
        this.host.setRestartStatus("restarting");
        try {
            this.ctx.getProvider().restartHost(this.host.getName(), this.isColdRestart);
        }
        catch (ServiceException se) {
            this.ctx.getLogger().severe(se.toString());
            this.host.setRestartStatus("restart_failed");
            return;
        }
        this.host.setRestartStatus("restart_done");
    }

    public boolean isColdRestart() {
        return this.isColdRestart;
    }
}

