/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.server;

import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.Context;
import com.sun.ut.console.I18N;
import com.sun.ut.console.dtus.DesktopUnitHelper;
import com.sun.ut.console.dtus.SearchCriteria;
import com.sun.ut.console.server.DiskSpaceInfo;
import com.sun.ut.console.server.RestartServicesTask;
import com.sun.ut.console.server.ServerHelper;
import com.sun.ut.service.Host;
import com.sun.ut.service.ServiceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ServerDetailsHandler
extends BaseHandler {
    public static final String RESTART_TASK = "RestartTask";
    public static final String RESTARTED_HOST = "RestartedHost";
    public static final String RESTART_TIME = "RestartTime";
    public static final String TOTAL_DTUS = "TotalDtus";
    public static final String TOTAL_USER_SESSIONS = "TotalUserSessions";
    public static final String TOTAL_DISCONNECTED_USER_SESSIONS = "TotalDisconnectedUserSessions";
    public static final String TOTAL_GREETER_SESSIONS = "TotalGreeterSessions";
    public static final String TOTAL_DISCONNECTED_GREETER_SESSIONS = "TotalDisconnectedGreeterSessions";
    public static final String DISK_SPACE_PROVIDER = "DiskSpaceProvider";
    public static final String CACHED_DATA = "CachedData";
    public static final String HOSTNAME = "DetailsHostname";
    public static final int ONE_SECOND = 1000;
    public static final int USER_SESSIONS = 0;
    public static final int USER_SESSIONS_DISC = 1;
    public static final int IDLE_SESSIONS = 2;
    public static final int IDLE_SESSIONS_DISC = 3;
    private String name;
    private Host host;
    private long elapsedTime;
    private boolean bLocalhost;
    private ObjectListDataProvider diskSpaceProvider;
    private int totalDtus;
    private int totalUserSessions;
    private int totalDisconnectedUserSessions;
    private int totalGreeterSessions;
    private int totalDisconnectedGreeterSessions;
    private HashMap cachedServer;

    public ServerDetailsHandler() {
        this.getServerInfo();
        this.getDiskSpaceInfo();
    }

    public void getServerInfo() {
        block23: {
            ObjectListDataProvider allHostsProvider;
            this.name = ServerHelper.getSelectedId();
            String localhost = this.getProvider().getCurrentHostName();
            this.bLocalhost = localhost.indexOf(this.name) == 0;
            HashMap cachedData = (HashMap)Context.getSessionAttribute(CACHED_DATA);
            if (cachedData != null) {
                this.cachedServer = (HashMap)cachedData.get(this.name);
            }
            if (this.cachedServer == null) {
                this.cachedServer = new HashMap();
            }
            if (this.host == null && (allHostsProvider = (ObjectListDataProvider)Context.getSessionAttribute("AllServers")) != null) {
                List allHosts = allHostsProvider.getList();
                Iterator it = allHosts.iterator();
                while (it.hasNext()) {
                    Host nextHost = (Host)it.next();
                    if (this.name.compareTo(nextHost.getName()) != 0 || nextHost.getRestartStatus() == null || !nextHost.getRestartStatus().equals("restarting")) continue;
                    this.host = nextHost;
                    break;
                }
            }
            if (this.host == null || !this.host.getName().equals(this.name)) {
                List hosts = null;
                try {
                    hosts = this.getProvider().getHosts();
                    if (hosts == null) break block23;
                    Iterator it = hosts.iterator();
                    while (it.hasNext()) {
                        this.host = (Host)it.next();
                        if (this.name.compareTo(this.host.getName()) != 0) continue;
                        int role = this.getProvider().getReplicationRole(this.host.getName());
                        switch (role) {
                            case 2: {
                                this.host.setType(I18N.getResource("server_type_primary"));
                                break;
                            }
                            case 4: {
                                this.host.setType(I18N.getResource("server_type_secondary"));
                                break;
                            }
                            case 1: {
                                this.host.setType(I18N.getResource("server_type_standalone"));
                                break;
                            }
                            default: {
                                this.host.setType(I18N.getResource("server_type_unknown"));
                                break;
                            }
                        }
                        break;
                    }
                }
                catch (ServiceException se) {
                    this.getLogger().severe(se.toString());
                    this.getStatusMessage().error(se);
                }
            }
        }
        if (this.host != null && this.host.getRestartStatus() != null && this.host.getRestartStatus().equals("restarting")) {
            if (this.cachedServer.get(TOTAL_DTUS) != null) {
                this.totalDtus = (Integer)this.cachedServer.get(TOTAL_DTUS);
            }
            if (this.cachedServer.get(TOTAL_USER_SESSIONS) != null) {
                this.totalUserSessions = (Integer)this.cachedServer.get(TOTAL_USER_SESSIONS);
            }
            if (this.cachedServer.get(TOTAL_DISCONNECTED_USER_SESSIONS) != null) {
                this.totalDisconnectedUserSessions = (Integer)this.cachedServer.get(TOTAL_DISCONNECTED_USER_SESSIONS);
            }
            if (this.cachedServer.get(TOTAL_GREETER_SESSIONS) != null) {
                this.totalGreeterSessions = (Integer)this.cachedServer.get(TOTAL_GREETER_SESSIONS);
            }
            if (this.cachedServer.get(TOTAL_DISCONNECTED_GREETER_SESSIONS) != null) {
                this.totalDisconnectedGreeterSessions = (Integer)this.cachedServer.get(TOTAL_DISCONNECTED_GREETER_SESSIONS);
            }
        } else {
            this.totalDtus = this.getProvider().getCurrentDTUsNumber(this.name);
            try {
                int[] sessions = this.getProvider().getSessionNumbers(this.name);
                if (sessions != null) {
                    this.totalUserSessions = sessions[0];
                    this.totalDisconnectedUserSessions = sessions[1];
                    this.totalGreeterSessions = sessions[2];
                    this.totalDisconnectedGreeterSessions = sessions[3];
                }
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("sessions_alert_get_numbers", se);
            }
        }
    }

    public TableDataProvider getDiskSpaceInfo() {
        if (this.host.getRestartStatus() != null && this.host.getRestartStatus().equals("restarting")) {
            this.diskSpaceProvider = (ObjectListDataProvider)this.cachedServer.get(DISK_SPACE_PROVIDER);
        }
        if (this.diskSpaceProvider == null) {
            ArrayList<DiskSpaceInfo> list = new ArrayList<DiskSpaceInfo>();
            try {
                long[] info = this.getProvider().getDiskSpace("/");
                list.add(new DiskSpaceInfo(I18N.getResource("serverDetails_root"), info[2], info[1], info[0]));
                info = this.getProvider().getDiskSpace("/tmp");
                list.add(new DiskSpaceInfo(I18N.getResource("serverDetails_tmp"), info[2], info[1], info[0]));
                info = this.getProvider().getSwapSpace();
                list.add(new DiskSpaceInfo(I18N.getResource("serverDetails_swap"), info[2], info[1], info[0]));
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error(se);
            }
            this.diskSpaceProvider = new ObjectListDataProvider(list);
        }
        return this.diskSpaceProvider;
    }

    public String getName() {
        return this.name;
    }

    public Host getHost() {
        return this.host;
    }

    public String getSoftwareVersion() {
        return this.getProvider().getSoftwareVersion();
    }

    public String getOperatingSystem() {
        String architecture;
        String versionOS;
        StringBuffer buffer = new StringBuffer();
        String nameOS = System.getProperty("os.name");
        if (nameOS != null) {
            buffer.append(nameOS);
        }
        if ((versionOS = System.getProperty("os.version")) != null) {
            buffer.append(" ");
            buffer.append(versionOS);
        }
        if ((architecture = System.getProperty("os.arch")) != null) {
            buffer.append(" (");
            buffer.append(architecture);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String getElapsedTime() {
        this.elapsedTime = 0L;
        Long startTime = (Long)this.cachedServer.get(RESTART_TIME);
        if (startTime != null) {
            this.elapsedTime = (System.currentTimeMillis() - startTime) / 1000L;
        }
        return String.valueOf(this.elapsedTime);
    }

    public int getTotalDtus() {
        return this.totalDtus;
    }

    public int getTotalUserSessions() {
        return this.totalUserSessions + this.totalDisconnectedUserSessions;
    }

    public int getUserSessions() {
        return this.totalUserSessions;
    }

    public int getTotalGreeterSessions() {
        return this.totalGreeterSessions + this.totalDisconnectedGreeterSessions;
    }

    public String showDTUs() {
        SearchCriteria criteria = DesktopUnitHelper.getSearchCriteria();
        criteria.setFilter("current");
        criteria.setSearchString(this.getName());
        DesktopUnitHelper.setSelectedId(null);
        return "viewServerDesktopUnits";
    }

    public boolean isLocalHost() {
        return this.bLocalhost;
    }

    protected void restart(boolean isColdRestart) {
        if (this.host != null) {
            Host nextHost;
            RestartServicesTask task = new RestartServicesTask(this.getAdminContext(), this.host, isColdRestart);
            ObjectListDataProvider dataProvider = (ObjectListDataProvider)Context.getSessionAttribute("AllServers");
            ArrayList<Host> restarting = (ArrayList<Host>)Context.getSessionAttribute("ServersRestarting");
            if (restarting == null) {
                restarting = new ArrayList<Host>();
                restarting.add(this.host);
            } else {
                boolean isNewRestarter = true;
                for (int i = 0; i < restarting.size(); ++i) {
                    nextHost = (Host)restarting.get(i);
                    if (this.host.getName().compareTo(nextHost.getName()) != 0) continue;
                    restarting.set(i, this.host);
                    isNewRestarter = false;
                }
                if (isNewRestarter) {
                    restarting.add(this.host);
                }
            }
            List<Host> hosts = new ArrayList();
            if (dataProvider == null) {
                try {
                    hosts = this.getProvider().getHosts();
                }
                catch (ServiceException se) {
                    this.getLogger().severe(se.toString());
                    this.getStatusMessage().error(se);
                }
            } else {
                hosts = dataProvider.getList();
            }
            for (int i = 0; i < hosts.size(); ++i) {
                nextHost = (Host)hosts.get(i);
                if (this.host.getName().compareTo(nextHost.getName()) != 0) continue;
                hosts.set(i, this.host);
            }
            HashMap<String, HashMap> cachedData = (HashMap<String, HashMap>)Context.getSessionAttribute(CACHED_DATA);
            if (cachedData == null) {
                cachedData = new HashMap<String, HashMap>();
            }
            this.cachedServer.put(TOTAL_DTUS, new Integer(this.totalDtus));
            this.cachedServer.put(TOTAL_USER_SESSIONS, new Integer(this.totalUserSessions));
            this.cachedServer.put(TOTAL_DISCONNECTED_USER_SESSIONS, new Integer(this.totalDisconnectedUserSessions));
            this.cachedServer.put(TOTAL_GREETER_SESSIONS, new Integer(this.totalGreeterSessions));
            this.cachedServer.put(TOTAL_DISCONNECTED_GREETER_SESSIONS, new Integer(this.totalDisconnectedGreeterSessions));
            this.cachedServer.put(DISK_SPACE_PROVIDER, this.diskSpaceProvider);
            Context.setSessionAttribute("AllServers", new ObjectListDataProvider(hosts));
            Context.setSessionAttribute("ServersRestarting", restarting);
            this.cachedServer.put(RESTART_TIME, new Long(System.currentTimeMillis()));
            cachedData.put(this.host.getName(), this.cachedServer);
            Context.setSessionAttribute(CACHED_DATA, cachedData);
            this.host.setRestartStatus("restarting");
            if (isColdRestart) {
                this.host.setLastRestartType("cold_restart");
            } else {
                this.host.setLastRestartType("warm_restart");
            }
            task.start();
        }
    }

    public String warmRestart() {
        this.getNotification().setRestartRequired(false);
        this.restart(false);
        return "success";
    }

    public String coldRestart() {
        this.getNotification().setColdRestartRequired(false);
        this.restart(true);
        return "success";
    }

    public boolean isRestartInProgress() {
        boolean restartInProgress = false;
        ArrayList serversRestarting = (ArrayList)Context.getSessionAttribute("ServersRestarting");
        if (serversRestarting == null || !this.isServerInRestartList(serversRestarting)) {
            restartInProgress = false;
        } else if (this.isCurrentServerRestarting(serversRestarting)) {
            restartInProgress = true;
        } else {
            Host restartedHost = this.getServerFromRestartList(serversRestarting);
            String restartedHostName = "";
            if (restartedHost != null) {
                restartedHostName = restartedHost.getName();
            }
            String statusRestartType = I18N.getResource("servers_table_warm_restart_button");
            String auditRestartType = this.getAuditService().getMessage("restart_warm");
            if (this.isColdRestart(restartedHost)) {
                auditRestartType = this.getAuditService().getMessage("restart_cold");
                statusRestartType = I18N.getResource("servers_table_cold_restart_button");
            }
            if (this.isRestartSuccessful(restartedHost)) {
                Object[] auditArgs = new String[]{auditRestartType, restartedHostName};
                this.getAuditService().publishEvent("servers_restart", auditArgs);
                Object[] args = new String[]{statusRestartType, restartedHostName};
                this.getStatusMessage().info("server_restart_done", I18N.getResource("restart_success_single", args));
            } else {
                Object[] auditArgs = new String[]{auditRestartType, restartedHostName};
                this.getAuditService().publishEvent("servers_restart_failed", auditArgs);
                String[] args = new String[]{restartedHostName};
                this.getStatusMessage().error("server_restart_failed_alert", "");
            }
            this.updateCachedData();
            restartInProgress = false;
            this.getServerInfo();
        }
        return restartInProgress;
    }

    public String getWarmRestartOnClick() {
        return "javascript: if (confirmWarmRestart(\"" + I18N.getResource("server_restart_warm_popup2") + "\" ) == false) return false";
    }

    public String getColdRestartOnClick() {
        return "javascript: if (confirmColdRestart(\"" + I18N.getResource("server_restart_cold_popup2") + "\" ) == false) return false";
    }

    private boolean isRestartSuccessful(Host server) {
        return !"restart_failed".equals(server.getRestartStatus());
    }

    private void updateCachedData() {
        ObjectListDataProvider allServers = (ObjectListDataProvider)Context.getSessionAttribute("AllServers");
        ArrayList restartingServers = (ArrayList)Context.getSessionAttribute("ServersRestarting");
        HashMap cachedData = (HashMap)Context.getSessionAttribute(CACHED_DATA);
        if (!this.isAnyServerRestarting(allServers.getList())) {
            Context.setSessionAttribute("AllServers", null);
        }
        if (restartingServers != null) {
            for (int i = 0; i < restartingServers.size(); ++i) {
                Host server = (Host)restartingServers.get(i);
                if (this.host.getName().compareTo(server.getName()) != 0) continue;
                restartingServers.remove(i);
                break;
            }
            if (restartingServers.size() == 0) {
                Context.setSessionAttribute("ServersRestarting", null);
            } else {
                Context.setSessionAttribute("ServersRestarting", restartingServers);
            }
        }
        if (cachedData.get(this.host.getName()) != null) {
            cachedData.remove(this.host.getName());
        }
        if (cachedData.isEmpty()) {
            Context.setSessionAttribute(CACHED_DATA, null);
        } else {
            Context.setSessionAttribute(CACHED_DATA, cachedData);
        }
    }

    private boolean isCurrentServerRestarting(ArrayList servers) {
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Host server = (Host)servers.get(i);
                if (this.host.getName().compareTo(server.getName()) != 0 || server.getRestartStatus() == null || !server.getRestartStatus().equals("restarting")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAnyServerRestarting(List servers) {
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Host server = (Host)servers.get(i);
                if (server.getRestartStatus() == null || !server.getRestartStatus().equals("restarting")) continue;
                return true;
            }
        }
        return false;
    }

    private Host getServerFromRestartList(ArrayList servers) {
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Host server = (Host)servers.get(i);
                if (this.host.getName().compareTo(server.getName()) != 0) continue;
                return server;
            }
        }
        return null;
    }

    private boolean isServerInRestartList(ArrayList servers) {
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Host server = (Host)servers.get(i);
                if (this.host.getName().compareTo(server.getName()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isColdRestart(Host server) {
        return !server.getLastRestartType().equals("warm_restart");
    }
}

