/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.session;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.Context;
import com.sun.ut.console.I18N;
import com.sun.ut.console.SelectHelper;
import com.sun.ut.console.dtus.DesktopUnitHelper;
import com.sun.ut.console.server.ServerHelper;
import com.sun.ut.console.session.SearchCriteria;
import com.sun.ut.console.session.SessionHelper;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.Session;
import com.sun.web.ui.component.TableRowGroup;
import java.util.List;

public abstract class BaseSessionHandler
extends BaseHandler {
    private SelectHelper idleSessionSelectHelper;
    private SelectHelper userSessionSelectHelper = new SelectHelper("#{sessionRowGroup.tableRow}");
    private TableRowGroup userSessionRowGroup;
    private TableRowGroup idleSessionRowGroup;
    private ObjectListDataProvider userSessionProvider;
    private ObjectListDataProvider idleSessionProvider;
    private List userSessions;
    private List idleSessions;
    private SearchCriteria searchCriteria;

    public BaseSessionHandler() {
        this.idleSessionSelectHelper = new SelectHelper("#{sessionRowGroup.tableRow}");
        this.searchCriteria = new SearchCriteria();
    }

    protected abstract void initSessions();

    public ObjectListDataProvider getUserSessions() {
        if (this.userSessions == null) {
            this.initSessions();
        }
        this.userSessionProvider = new ObjectListDataProvider(this.userSessions);
        return this.userSessionProvider;
    }

    public ObjectListDataProvider getIdleSessions() {
        if (this.idleSessions == null) {
            this.initSessions();
        }
        this.idleSessionProvider = new ObjectListDataProvider(this.idleSessions);
        return this.idleSessionProvider;
    }

    public String terminate() {
        int numberTerminated = 0;
        RowKey[] rowKeys = this.userSessionRowGroup.getRenderedSelectedRowKeys();
        try {
            Object[] args;
            Session session;
            RowKey rowKey;
            int i;
            if (rowKeys != null) {
                for (i = 0; i < rowKeys.length; ++i) {
                    rowKey = rowKeys[i];
                    session = (Session)this.getUserSessions().getObject(rowKey);
                    this.getProvider().terminateSession(session.getServer(), session.getDisplay(), session.getTokenID());
                    args = new Object[]{session.getTokenID(), session.getDisplay(), session.getServer()};
                    this.getAuditService().publishEvent("Sessions", "session_terminated", args, 0);
                }
                numberTerminated = rowKeys.length;
                this.userSessionProvider = null;
                this.userSessions = null;
                this.userSessionSelectHelper.clear();
            }
            if ((rowKeys = this.idleSessionRowGroup.getRenderedSelectedRowKeys()) != null) {
                for (i = 0; i < rowKeys.length; ++i) {
                    rowKey = rowKeys[i];
                    session = (Session)this.getIdleSessions().getObject(rowKey);
                    this.getProvider().terminateSession(session.getServer(), session.getDisplay(), session.getTokenID());
                    args = new Object[]{session.getTokenID(), session.getDisplay(), session.getServer()};
                    this.getAuditService().publishEvent("Sessions", "session_terminated", args, 0);
                }
                numberTerminated += rowKeys.length;
                this.idleSessionProvider = null;
                this.idleSessions = null;
                this.idleSessionSelectHelper.clear();
            }
            this.getStatusMessage().info(I18N.getResource("sessions_terminate"), null);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("sessions_terminate_error", se);
        }
        return "success";
    }

    public TableRowGroup getUserSessionRowGroup() {
        return this.userSessionRowGroup;
    }

    public void setUserSessionRowGroup(TableRowGroup tableRowGroup) {
        this.userSessionRowGroup = tableRowGroup;
    }

    public TableRowGroup getIdleSessionRowGroup() {
        return this.idleSessionRowGroup;
    }

    public void setIdleSessionRowGroup(TableRowGroup tableRowGroup) {
        this.idleSessionRowGroup = tableRowGroup;
    }

    public SelectHelper getUserSessionSelectHelper() {
        return this.userSessionSelectHelper;
    }

    public SelectHelper getIdleSessionSelectHelper() {
        return this.idleSessionSelectHelper;
    }

    public String showServerDetails() {
        String serverName = Context.getRequestParameter("serverName");
        if (serverName != null) {
            ServerHelper.setSelectedId(serverName);
        }
        return "viewServerDetails";
    }

    public String showDesktopUnitDetails() {
        String dtuID = Context.getRequestParameter("dtu");
        if (dtuID != null) {
            DesktopUnitHelper.setSelectedId(dtuID);
        }
        return "viewDesktopUnitDetails";
    }

    public String getTitle() {
        String filter = SessionHelper.getSearchCriteria().getFilter();
        if (filter.equals("all")) {
            return I18N.getResource("sessions_pageTitle");
        }
        return I18N.getResource("sessions_pageTitle") + " " + filter;
    }

    public SearchCriteria getSearchCriteria() {
        return this.searchCriteria;
    }

    public String search() {
        SearchCriteria search = (SearchCriteria)Context.getSessionAttribute("sessionSearchCriteria");
        if (search == null) {
            search = new SearchCriteria();
            Context.setSessionAttribute("sessionSearchCriteria", search);
        }
        search.setFilter(this.searchCriteria.getFilter());
        search.setSearchString(this.searchCriteria.getSearchString());
        return "viewSessionsSearchResults";
    }

    public List getUserSessionList() {
        return this.userSessions;
    }

    public void setUserSessionList(List newUserSessions) {
        this.userSessions = newUserSessions;
    }

    public List getIdleSessionList() {
        return this.idleSessions;
    }

    public void setIdleSessionList(List newIdleSessions) {
        this.idleSessions = newIdleSessions;
    }

    public String getTerminateOnClick() {
        return "javascript: if (confirmSelectedRowsForTermination(\"" + I18N.getResource("sessions_terminate_popup") + "\" ) == false) return false";
    }
}

