/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.session;

import com.sun.ut.console.session.BaseSessionHandler;
import com.sun.ut.console.session.SessionHelper;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.Session;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SearchResultsHandler
extends BaseSessionHandler {
    protected void initSessions() {
        this.setUserSessionList(new ArrayList());
        this.setIdleSessionList(new ArrayList());
        String filter = SessionHelper.getSearchCriteria().getFilter();
        String searchString = SessionHelper.getSearchCriteria().getSearchString();
        List sessions = new ArrayList();
        try {
            sessions = filter.equals("all") ? this.getProvider().getSessions(null, null) : this.getProvider().getSessions(null, filter);
            Iterator it = sessions.iterator();
            while (it.hasNext()) {
                Session session = (Session)it.next();
                if (!this.matchSearchString(searchString, session)) continue;
                if (session.isIdle()) {
                    this.getIdleSessionList().add(session);
                    continue;
                }
                this.getUserSessionList().add(session);
            }
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("sessions_alert_get", se);
        }
    }

    protected boolean matchSearchString(String searchString, Session session) {
        boolean foundMatch = false;
        String search = searchString.toUpperCase();
        if ("*".equals(search)) {
            foundMatch = true;
        } else if (session.getTokenID().toUpperCase().indexOf(search) >= 0) {
            foundMatch = true;
        } else if (session.getUserName() != null && session.getUserName().toUpperCase().indexOf(search) >= 0) {
            foundMatch = true;
        } else if (session.getUnixID() != null && session.getUnixID().toUpperCase().indexOf(search) >= 0) {
            foundMatch = true;
        } else if (session.getDisplay().indexOf(search) >= 0) {
            foundMatch = true;
        } else if (session.getServer().toUpperCase().indexOf(search) >= 0) {
            foundMatch = true;
        }
        return foundMatch;
    }

    public String search() {
        this.initSessions();
        return "success";
    }
}

