/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.session;

import com.sun.ut.console.Configuration;
import com.sun.ut.console.session.BaseSessionHandler;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.Session;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SessionHandler
extends BaseSessionHandler {
    private boolean showLocalSessionsOnly = false;
    private String serverName;

    public SessionHandler() {
        try {
            Configuration config = new Configuration();
            if (this.getProvider().getHosts().size() > config.getServerLimit()) {
                this.showLocalSessionsOnly = true;
                this.serverName = this.getProvider().getCurrentHostName();
                Object[] args = new String[]{this.serverName};
                this.getStatusMessage().info("sessions_performance_alert_summary", "sessions_performance_alert_details", args);
            }
        }
        catch (ServiceException ex) {
            this.getLogger().severe(ex.toString());
            this.getStatusMessage().error(ex);
        }
    }

    protected void initSessions() {
        this.setUserSessionList(new ArrayList());
        this.setIdleSessionList(new ArrayList());
        List sessions = new ArrayList();
        try {
            sessions = this.showLocalSessionsOnly ? this.getProvider().getSessions(null, this.serverName) : this.getProvider().getSessions(null, null);
            Iterator it = sessions.iterator();
            while (it.hasNext()) {
                Session session = (Session)it.next();
                if (session.isIdle()) {
                    this.getIdleSessionList().add(session);
                    continue;
                }
                this.getUserSessionList().add(session);
            }
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error(se);
        }
    }
}

