/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.tokens;

import com.sun.ut.console.I18N;
import com.sun.web.ui.model.Option;

public class SearchCriteria {
    public static final String REGISTERED = "registered";
    public static final String CURRENT = "current";
    public static final String DEFAULT_SEARCH_STRING = "*";
    private Option[] filterOptions = new Option[2];
    private String filter;
    private String searchString;

    public SearchCriteria() {
        this.filterOptions[0] = new Option((Object)REGISTERED, I18N.getResource("tokens_title_registered"));
        this.filterOptions[1] = new Option((Object)CURRENT, I18N.getResource("tokens_title_current"));
        this.setFilter(REGISTERED);
        this.setSearchString(DEFAULT_SEARCH_STRING);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString.length() == 0 ? DEFAULT_SEARCH_STRING : searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public Option[] getOptions() {
        return this.filterOptions;
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        if (this.filter.equals(REGISTERED)) {
            buffer.append(I18N.getResource("tokens_title_registered"));
        } else {
            buffer.append(I18N.getResource("tokens_title_current"));
        }
        if (!this.searchString.equals(DEFAULT_SEARCH_STRING)) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("\"");
            buffer.append(this.searchString);
            buffer.append("\"");
        }
        return buffer.toString();
    }
}

