/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import com.sun.ut.service.Kiosk;

public class KioskDescriptor {
    private String id;
    private String label;
    private boolean launcher;
    private String icon;
    private String description;
    private Kiosk recommendations;

    public KioskDescriptor(String id, String label, boolean launcher, String icon, String description, Kiosk recommendations) {
        this.id = id;
        this.label = label;
        this.launcher = launcher;
        this.icon = icon;
        this.description = description;
        this.recommendations = recommendations;
    }

    public KioskDescriptor(KioskDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        this.id = descriptor.id;
        this.label = descriptor.label;
        this.launcher = descriptor.launcher;
        this.icon = descriptor.icon;
        this.description = descriptor.description;
        this.recommendations = descriptor.recommendations;
        if (descriptor.recommendations != null) {
            this.recommendations = new Kiosk(descriptor.recommendations);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isLauncher() {
        return this.launcher;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public Kiosk getRecommendations() {
        return this.recommendations;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id=");
        sb.append(this.id);
        sb.append(", label=");
        sb.append(this.label);
        sb.append(", launcher=");
        sb.append(this.launcher);
        sb.append(", icon=");
        sb.append(this.icon);
        sb.append(", description=");
        sb.append(this.description);
        sb.append(", recommendations={");
        sb.append(this.recommendations);
        sb.append("}");
        return sb.toString();
    }
}

