/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import java.io.File;
import java.util.Date;

public class LogFile
implements Comparable {
    private static final int KILO_BYTE = 1024;
    private String name;
    private String date;
    private String size;

    public LogFile(File file) {
        this.name = file.getName();
        this.date = "" + new Date(file.lastModified());
        long length = file.length();
        this.size = "" + length + " bytes";
        if (length > 0x100000L) {
            this.size = "" + length / 0x100000L + " MB";
        } else if (length > 1024L) {
            this.size = "" + length / 1024L + " KB";
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDate() {
        return this.date;
    }

    public String getSize() {
        return this.size;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name=");
        sb.append(this.name);
        sb.append(", date=");
        sb.append(this.date);
        sb.append(", size=");
        sb.append(this.size);
        return sb.toString();
    }

    public int compareTo(Object object) {
        LogFile logFile = (LogFile)object;
        return this.name.compareTo(logFile.name);
    }
}

