/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import com.sun.ut.service.ReplicationListener;
import com.sun.ut.service.ServiceException;
import java.util.Date;
import junit.framework.TestCase;

public class ReplicationListenerTest
extends TestCase {
    private static final int MAX_WAIT_LOOPS = 5;

    public void testSuccessfulReplication() throws ServiceException {
        System.out.println("\nStart Replication Test");
        Date startTime = new Date();
        ReplicationListener listener = new ReplicationListener(){

            public boolean isReplicated() throws ServiceException {
                System.out.println("Checking replication status");
                return true;
            }
        };
        listener.waitForReplication();
        System.out.println("Replication succeeded. Took " + this.getTimePeriod(startTime) + " ms");
    }

    public void testDelayedSuccessfulReplication() throws ServiceException {
        System.out.println("\nStart Replication Test");
        Date startTime = new Date();
        int[] counter = new int[]{0};
        ReplicationListener listener = new ReplicationListener(counter){

            public boolean isReplicated() throws ServiceException {
                int[] counter = (int[])this.getData();
                System.out.println("Checking replication status Counter: " + counter[0]);
                counter[0] = counter[0] + 1;
                return counter[0] == 5;
            }
        };
        listener.waitForReplication();
        System.out.println("Replication succeeded. Took " + this.getTimePeriod(startTime) + " ms");
    }

    public void testFailedReplication() throws ServiceException {
        System.out.println("\nStart Replication Test");
        Date startTime = new Date();
        try {
            ReplicationListener listener = new ReplicationListener(){

                public boolean isReplicated() throws ServiceException {
                    System.out.println("Checking replication status");
                    return false;
                }
            };
            listener.waitForReplication();
            ReplicationListenerTest.fail((String)"Expected replication to fail.");
        }
        catch (ServiceException ex) {
            System.out.println("Replication failed as expected. Took " + this.getTimePeriod(startTime) + " ms");
        }
    }

    private long getTimePeriod(Date startTime) {
        Date currentTime = new Date();
        return currentTime.getTime() - startTime.getTime();
    }
}

