/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.authentication;

public class AuthenticationMessage {
    public static final String CONNECT = "CONNECT";
    public static final String DISCONNECT = "DISCONNECT";
    public static final String DATA = "DATA";
    public static final String OK = "OK";
    private String type;
    private String sessionId;
    private String data;

    public AuthenticationMessage(byte[] rawMessage) {
        this(new String(rawMessage));
    }

    public AuthenticationMessage(String message) {
        int pos = message.indexOf("\u0000");
        String header = message.substring(0, pos);
        if (pos < message.length() - 1) {
            this.data = message.substring(pos, message.length() - 1);
        }
        pos = header.indexOf(" ");
        this.type = header.substring(0, pos);
        this.sessionId = header.substring(pos, header.length());
    }

    public AuthenticationMessage(String type, String sessionId, String data) {
        this.type = type;
        this.sessionId = sessionId;
        this.data = data;
    }

    public String getType() {
        return this.type;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getData() {
        return this.data;
    }

    public String getMessage() {
        StringBuffer buffer = new StringBuffer(this.type);
        buffer.append(" ");
        buffer.append(this.sessionId);
        buffer.append("\u0000");
        if (this.data != null) {
            buffer.append(this.data);
            buffer.append("\u0000");
        }
        return buffer.toString();
    }

    public boolean isOk() {
        return this.type.compareTo(OK) == 0;
    }

    public boolean isDisconnect() {
        return this.type.compareTo(DISCONNECT) == 0;
    }

    public boolean isData() {
        return this.type.compareTo(DATA) == 0;
    }
}

