/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.authentication;

import com.sun.ut.service.authentication.AuthenticationMessage;
import com.sun.ut.service.command.Task;
import com.sun.ut.service.command.UtGuiAuth;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Random;

public class LoginModule {
    public static final String PIPE_PATH = "/var/opt/SUNWut/tmp/pipes/";
    private static final int MAX_WAIT_ITERATIONS = 10;
    private static final int WAIT_TIME = 100;
    private static final int RANDOM_BASE_NUMBER = 100000;
    private static final int BIT_NUMBER = 8;
    private static final int SHORT_BITS = 255;
    private static final int UPPER_SHORT_BITS = 65280;
    private static final int LOWER_SHORT_BITS = 255;
    private String pipeName;
    private File inputPipe;
    private File outputPipe;
    private String sessionId;
    private Task guiAuthProcess;

    public void init() throws Exception {
        this.pipeName = this.sessionId = this.generateRandomString();
        this.guiAuthProcess = new UtGuiAuth(this.pipeName);
        this.guiAuthProcess.start();
        this.waitForPipes(this.pipeName);
        this.sendMessage("CONNECT");
        AuthenticationMessage msg = this.receiveMessage();
        if (!msg.isOk()) {
            throw new Exception("Error init login module");
        }
    }

    public AuthenticationMessage login(String input) throws Exception {
        if (input != null) {
            this.sendMessage("DATA", input);
        }
        return this.receiveMessage();
    }

    public void commit() throws Exception {
        this.sendMessage("OK");
    }

    public void abort() throws Exception {
        this.sendMessage("DISCONNECT");
    }

    public boolean isAlive() {
        return this.guiAuthProcess.isAlive();
    }

    protected void waitForPipes(String pipe) throws Exception {
        this.inputPipe = new File(PIPE_PATH + pipe + ".in");
        this.outputPipe = new File(PIPE_PATH + pipe + ".out");
        for (int i = 0; !(i >= 10 || this.inputPipe.exists() && this.outputPipe.exists()); ++i) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
    }

    protected String generateRandomString() {
        Random random = new Random();
        int result = random.nextInt(100000);
        return Integer.toString(result);
    }

    protected void sendMessage(String type) throws Exception {
        this.sendMessage(type, null);
    }

    protected void sendMessage(String type, String data) throws Exception {
        if (!this.isAlive()) {
            throw new Exception("Login Timeout");
        }
        FileOutputStream os = new FileOutputStream(this.inputPipe);
        AuthenticationMessage msg = new AuthenticationMessage(type, this.sessionId, data);
        byte[] content = msg.getMessage().getBytes();
        byte[] rawMessage = new byte[content.length + 2];
        rawMessage = this.integerToShort(content.length, rawMessage);
        System.arraycopy(content, 0, rawMessage, 2, content.length);
        os.write(rawMessage);
        os.close();
    }

    protected AuthenticationMessage receiveMessage() throws Exception {
        FileInputStream is = new FileInputStream(this.outputPipe);
        byte[] unsignedShort = new byte[2];
        is.read(unsignedShort);
        int msgSize = this.shortToInteger(unsignedShort);
        byte[] rawMessage = new byte[msgSize];
        is.read(rawMessage, 0, msgSize);
        is.close();
        return new AuthenticationMessage(rawMessage);
    }

    protected int shortToInteger(byte[] unsignedShort) {
        int result = (0xFF & unsignedShort[0]) << 8;
        return result |= 0xFF & unsignedShort[1];
    }

    protected byte[] integerToShort(int signedInteger, byte[] unsignedShort) {
        unsignedShort[0] = (byte)((signedInteger & 0xFF00) >> 8);
        unsignedShort[1] = (byte)(signedInteger & 0xFF);
        return unsignedShort;
    }
}

