/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.command;

import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.RemoteCommand;
import com.sun.ut.service.command.Task;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class UtDevadm
extends Task {
    private static final String UT_DEVADM_CMD = "/opt/SUNWut/sbin/utdevadm";
    public static final String SERIAL_SERVICE = "internal_serial";
    public static final String SMARTCARD_SERVICE = "internal_smartcard_reader";
    public static final String USB_SERVICE = "usb";
    public static final String ALL_SERVICES = "all";
    public static final String ENABLE_OPTION = "-e";
    public static final String DISABLE_OPTION = "-d";
    public static final String SERVICE_OPTION = "-s";
    public static final String ENABLED_STRING = "enabled";
    private String serviceName;
    private boolean status;

    public UtDevadm() {
        this.serviceName = null;
        this.status = false;
    }

    public UtDevadm(String serviceName, boolean status) {
        this.serviceName = serviceName;
        this.status = status;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public boolean getStatus() {
        return this.status;
    }

    public String[] getElements() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(UT_DEVADM_CMD);
        if (this.serviceName != null) {
            list.add(SERVICE_OPTION);
            list.add(this.serviceName);
            if (this.status) {
                list.add(ENABLE_OPTION);
            } else {
                list.add(DISABLE_OPTION);
            }
        }
        String[] command = new String[list.size()];
        command = list.toArray(command);
        return command;
    }

    public Object[][] getServicesStatus() throws ServiceException {
        this.serviceName = null;
        this.status = false;
        this.run();
        if (this.getExitCode() != 0) {
            throw new ServiceException(this.getSyntax(), this.getExitCode());
        }
        ArrayList<Object[]> serviceList = new ArrayList<Object[]>();
        StringTokenizer tokenizer = new StringTokenizer(this.getOutputMsg(), "\n");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token == null) continue;
            if (token.startsWith(SERIAL_SERVICE)) {
                serviceList.add(this.parseStatus(SERIAL_SERVICE, token));
                continue;
            }
            if (token.startsWith(SMARTCARD_SERVICE)) {
                serviceList.add(this.parseStatus(SMARTCARD_SERVICE, token));
                continue;
            }
            if (!token.startsWith(USB_SERVICE)) continue;
            serviceList.add(this.parseStatus(USB_SERVICE, token));
        }
        Object[][] list = new Object[serviceList.size()][2];
        return (Object[][])serviceList.toArray((T[])list);
    }

    public boolean isServiceEnabled(String service) throws ServiceException {
        this.serviceName = null;
        this.status = false;
        this.run();
        if (this.getExitCode() != 0) {
            throw new ServiceException(this.getSyntax(), this.getExitCode());
        }
        StringTokenizer tokenizer = new StringTokenizer(this.getOutputMsg(), "\n");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token == null || !token.startsWith(service)) continue;
            Object[] info = this.parseStatus(service, token);
            Boolean mode = (Boolean)info[1];
            return mode;
        }
        return false;
    }

    protected Object[] parseStatus(String service, String message) {
        int index = message.indexOf(ENABLED_STRING, service.length());
        Object[] result = new Object[]{service, index > 0 ? Boolean.TRUE : Boolean.FALSE};
        return result;
    }

    public void setServiceStatus(String service, boolean newStatus) throws ServiceException {
        this.serviceName = service;
        this.status = newStatus;
        RemoteCommand cmd = new RemoteCommand(this.getElements());
        cmd.run();
        if (cmd.getExitCode() != 0) {
            throw new ServiceException("devices_alert_modify", cmd.getSyntax(), cmd.getExitCode());
        }
    }

    public void enableService(String service) throws ServiceException {
        this.setServiceStatus(service, true);
    }

    public void disableService(String service) throws ServiceException {
        this.setServiceStatus(service, false);
    }
}

