/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.command;

import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.UtProdinfo;
import junit.framework.TestCase;

public class UtProdinfoTest
extends TestCase {
    public static final String SUNW_UTA_PACKAGE = "SUNWuta";
    public static final String NON_EXISTING_PACKAGE = "SUNWutxxxx";
    private static final int PKGNAME_INDEX = 3;

    public void testGetAllPackageNames() throws ServiceException {
        UtProdinfo cmd = new UtProdinfo();
        String[] pkgNames = cmd.getAllPackageNames();
        UtProdinfoTest.assertTrue((String)"Exit code of utprodinfo command is not zero!", (cmd.getExitCode() == 0 ? 1 : 0) != 0);
        UtProdinfoTest.assertNotNull((String)"utprodinfo returned null", (Object)pkgNames);
        UtProdinfoTest.assertTrue((String)"Could not find any package names", (pkgNames.length > 0 ? 1 : 0) != 0);
        System.out.println(cmd.getSyntax());
        for (int i = 0; i < pkgNames.length; ++i) {
            System.out.println(pkgNames[i]);
        }
    }

    public void testGetBaseDir() throws ServiceException {
        UtProdinfo cmd = new UtProdinfo();
        String baseDir = cmd.getBaseDirectory(SUNW_UTA_PACKAGE);
        UtProdinfoTest.assertTrue((String)"Exit code of utprodinfo command is not zero!", (cmd.getExitCode() == 0 ? 1 : 0) != 0);
        UtProdinfoTest.assertNotNull((String)"utprodinfo returned null", (Object)baseDir);
        UtProdinfoTest.assertTrue((String)"Returned wrong base directory", (boolean)baseDir.equals("/opt"));
        System.out.println(cmd.getSyntax());
        System.out.println(baseDir);
    }

    public void testGetPackageInfo() throws ServiceException {
        UtProdinfo cmd = new UtProdinfo();
        String[] opts = new String[]{"NAME", "VERSION", "PSTAMP", "PKGNAME"};
        String[] pkgInfo = cmd.getPackageInfo(SUNW_UTA_PACKAGE, opts);
        UtProdinfoTest.assertTrue((String)"Exit code of utprodinfo command is not zero!", (cmd.getExitCode() == 0 ? 1 : 0) != 0);
        UtProdinfoTest.assertNotNull((String)"utprodinfo returned null", (Object)pkgInfo);
        UtProdinfoTest.assertTrue((String)"Returned wrong package info number", (pkgInfo.length == opts.length ? 1 : 0) != 0);
        UtProdinfoTest.assertTrue((String)"Returned wrong package name", (boolean)pkgInfo[3].equals(SUNW_UTA_PACKAGE));
        System.out.println(cmd.getSyntax());
        for (int i = 0; i < pkgInfo.length; ++i) {
            System.out.println(pkgInfo[i]);
        }
    }

    public void testGetPackageInfoForAllPackages() throws ServiceException {
        UtProdinfo cmd = new UtProdinfo();
        String[] opts = new String[]{"NAME", "VERSION", "PSTAMP"};
        String[] pkgNames = cmd.getAllPackageNames();
        for (int i = 0; i < pkgNames.length; ++i) {
            UtProdinfoTest.assertNotNull((String)"Invalid package name", (Object)pkgNames[i]);
            String[] pkgInfo = cmd.getPackageInfo(pkgNames[i], opts);
            UtProdinfoTest.assertNotNull((String)"Invalid package info", (Object)pkgInfo[0]);
            UtProdinfoTest.assertNotNull((String)"Invalid package info", (Object)pkgInfo[1]);
            UtProdinfoTest.assertNotNull((String)"Invalid package info", (Object)pkgInfo[2]);
            System.out.println(pkgNames[i] + "\t" + pkgInfo[0] + "\t" + pkgInfo[1] + "\t" + pkgInfo[2]);
        }
    }

    public void testExceptionsGetBaseDir() {
        UtProdinfo cmd = new UtProdinfo();
        try {
            String baseDir = cmd.getBaseDirectory(NON_EXISTING_PACKAGE);
            UtProdinfoTest.fail((String)"Should raise a ServiceException");
        }
        catch (ServiceException ex) {
            System.out.println(cmd.getSyntax());
            System.out.println(ex.getMessage());
        }
    }

    public void testExceptionsGetPackageInfo() {
        UtProdinfo cmd = new UtProdinfo();
        try {
            String[] opts = new String[]{"NAME", "VERSION", "PSTAMP"};
            String[] pkgInfo = cmd.getPackageInfo(NON_EXISTING_PACKAGE, opts);
            UtProdinfoTest.fail((String)"Should raise a ServiceException");
        }
        catch (ServiceException ex) {
            System.out.println(cmd.getSyntax());
            System.out.println(ex.getMessage());
        }
    }
}

