/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.command;

import com.sun.ut.service.Host;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.UtRestart;
import com.sun.ut.service.jni.Datastore;
import com.sun.ut.service.jni.DatastoreFactory;
import java.util.Iterator;
import junit.framework.TestCase;

public class UtRestartTest
extends TestCase {
    private static final int WAIT_LOOPS = 60;
    private static final int WAIT_TIME = 2000;
    private static final int ONE_SECOND = 1000;
    private Datastore ds;

    public void setUp() {
        this.ds = DatastoreFactory.getDatastore();
    }

    public void tearDown() {
        this.ds = null;
    }

    public void testWarmRestart() throws ServiceException {
        Iterator it = this.ds.getHosts().iterator();
        Host host = (Host)it.next();
        int[] oldStartTimes = this.ds.getHostStartTimes(host.getName());
        UtRestart cmd = new UtRestart();
        cmd.warmRestart(host.getName());
        System.out.println("Initiating WARM restart of " + host.getName());
        UtRestartTest.assertTrue((String)"Warm restart timed out", (boolean)this.restartCompleted(cmd, host.getName(), oldStartTimes));
    }

    public void testColdRestart() throws ServiceException {
        Iterator it = this.ds.getHosts().iterator();
        Host host = (Host)it.next();
        int[] oldStartTimes = this.ds.getHostStartTimes(host.getName());
        UtRestart cmd = new UtRestart();
        cmd.coldRestart(host.getName());
        System.out.println("Initiating COLD restart of " + host.getName());
        UtRestartTest.assertTrue((String)"Cold restart timed out", (boolean)this.restartCompleted(cmd, host.getName(), oldStartTimes));
    }

    private boolean restartCompleted(UtRestart cmd, String hostname, int[] oldStartTimes) throws ServiceException {
        long startTime = System.currentTimeMillis();
        Thread poller = null;
        for (int i = 0; i < 60; ++i) {
            long elapsedTime = (System.currentTimeMillis() - startTime) / 1000L;
            System.out.println("Wait for restart completion. Elapsed time: " + elapsedTime + " seconds");
            if (!cmd.isRunning()) {
                if (poller == null) {
                    poller = new Poller(hostname);
                    poller.start();
                } else if (!poller.isAlive()) {
                    int[] newStartTimes = ((Poller)poller).getStartTimes();
                    poller = null;
                    if (cmd.isColdRestart()) {
                        if (newStartTimes[0] != oldStartTimes[0] && newStartTimes[1] != oldStartTimes[1]) {
                            System.out.println("COLD restart done for " + hostname);
                            return true;
                        }
                    } else if (newStartTimes[0] != oldStartTimes[0]) {
                        System.out.println("WARM restart done for " + hostname);
                        return true;
                    }
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException ex) {
                System.out.println(ex.getMessage());
            }
        }
        return false;
    }

    class Poller
    extends Thread {
        private String hostname;
        private int[] startTimes;

        public Poller(String hostname) {
            this.hostname = hostname;
        }

        public int[] getStartTimes() {
            return this.startTimes;
        }

        public void run() {
            try {
                this.startTimes = UtRestartTest.this.ds.getHostStartTimes(this.hostname);
            }
            catch (ServiceException ex) {
                System.out.println(ex.getMessage());
                this.startTimes = null;
            }
        }
    }
}

