/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.jni;

import com.sun.ut.service.AdminContext;
import com.sun.ut.service.AuditService;
import junit.framework.TestCase;

public class AuditingTest
extends TestCase {
    private static final int STATUS = 1;
    private static final String SERVICE = "Unit Test";
    private static final String USERNAME = "nobody";
    private static final String MESSAGE_A = "Testing audit functionality";
    private static final String MESSAGE_B = "Testing audit functionality: {0}, {1}, {2}";
    private static final String MESSAGE_C = "authentication_timeout";
    private static final String[] PARAMETERS = new String[]{"A", "B", "C"};
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private AuditService audit;
    private static final long HALF_SECOND = 500L;
    private static final long TWO_SECONDS = 2000L;
    private static final long TWO_DOT_HALF_SECONDS = 2500L;
    private static final long THIRTY_SECONDS = 30000L;
    private static final long THREE_MINUTES = 180000L;
    private static final long THREE_DOT_HALF_MINUTES = 210000L;
    private static final long FOUR_HOURS = 14400000L;
    private static final long FOUR_DOT_THREE_HOURS = 14580000L;
    private static final long FOUR_HOURS_AND_MORE = 14610000L;
    private static final long FIVE_DAYS = 432000000L;
    private static final long FIVE_DAYS_AND_MORE = 446610000L;

    protected final void setUp() {
        AdminContext ctx = new AdminContext();
        ctx.setUserName(USERNAME);
        this.audit = new AuditService();
        this.audit.init(ctx);
    }

    protected final void tearDown() {
        this.audit.release();
    }

    public void testAuditMessage() {
        this.audit.publishEvent(MESSAGE_A);
    }

    public void testAuditMessage2() {
        this.audit.publishEvent(MESSAGE_B, PARAMETERS);
    }

    public void testAuditMessage3() {
        this.audit.publishEvent(MESSAGE_A, 1);
    }

    public void testAuditMessage4() {
        this.audit.publishEvent(MESSAGE_B, PARAMETERS, 1);
    }

    public void testAuditMessage5() {
        this.audit.publishEvent(SERVICE, MESSAGE_A, 1);
    }

    public void testAuditMessage6() {
        this.audit.publishEvent(SERVICE, MESSAGE_B, PARAMETERS, 1);
    }

    public void testAuditMessage7() {
        this.audit.publishEvent(MESSAGE_A, PARAMETERS);
    }

    public void testAuditMessage8() {
        Object[] args = new Object[]{USERNAME, this.audit.getFormattedDuration(3600000L)};
        this.audit.publishEvent(MESSAGE_C, args);
    }

    public void testGetFormattedDuration() {
        this.assertFormattedDuration(0L, "0 seconds");
        this.assertFormattedDuration(500L, "0 seconds");
        this.assertFormattedDuration(1000L, "1 second");
        this.assertFormattedDuration(2000L, "2 seconds");
        this.assertFormattedDuration(2500L, "2 seconds");
        this.assertFormattedDuration(60000L, "1 minute");
        this.assertFormattedDuration(210000L, "3 minutes, 30 seconds");
        this.assertFormattedDuration(3600000L, "1 hour");
        this.assertFormattedDuration(14400000L, "4 hours");
        this.assertFormattedDuration(14580000L, "4 hours, 3 minutes");
        this.assertFormattedDuration(14610000L, "4 hours, 3 minutes");
        this.assertFormattedDuration(86400000L, "1 day");
        this.assertFormattedDuration(432000000L, "5 days");
        this.assertFormattedDuration(446610000L, "5 days, 4 hours, 3 minutes");
    }

    private void assertFormattedDuration(long duration, String expected) {
        String msg = this.audit.getFormattedDuration(duration);
        System.out.println(msg);
        AuditingTest.assertEquals((String)expected, (String)msg);
    }
}

