/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Observable;
import java.util.Observer;

public class DevControl
extends Thread
implements Observer {
    private static final String SCCS_ID = "@(#)DevControl.java\t1.25\t06/04/13 SMI";
    static final int QUERY_LEN = 48;
    static final int NEWT_HEADER_LEN = 16;
    static final int EXTRA_SETTING_LEN = 8;
    static final int MAX_NUM_DEVS = 256;
    static final int NUM_DEVS = 24;
    static final int N_DAMAGE_REPAIR = -1409286144;
    static final int N_DEVICE_CTRL = -671088640;
    static final int N_MODEL_INFO = -973078528;
    static final int N_MAX_SEQ = 0xFFFFFF;
    static final int N_KBD_STATE = -1056964608;
    static final int N_PTR_STATE = -1040187392;
    static final int N_ACTIVE_REG_OBSOLETE = -1023410176;
    static final int STATUS = -1;
    static final int PING = -2;
    static final int NONE = -3;
    static final int SOCKET_TIMEOUT = 1000;
    static final int SOCKET_RETRY_WAIT = 3000;
    static final int SEND_DEVCTL_INTERVAL = 5000;
    static final int SEND_PING_INTERVAL = 1000;
    static final int CHK_RESPONSES_INTERVAL = 1000;
    static final int MAX_RESPONSE_TIME = 3000;
    static final int NO_DEVCTL_TIMEOUT = 8000;
    static final int CALLME_PORT = 99999;
    static final int LOWPORT = 40000;
    static final int HIPORT = 42000;
    private SettingsGUI settings_gui;
    private DatagramSocket dsocket;
    private boolean reader_started = false;
    private ModelInfo mi;
    private long start_time;
    private long last_outgoing_packet_time;
    private long last_outgoing_devctl_time;
    private long last_response_check_time;
    private long last_incoming_devctl_time;
    private boolean connected;
    private boolean first_send = true;
    private volatile boolean do_poll = true;
    private int header_sequence;
    private int epoch;
    private int cmd_sequence;
    private short contract;
    private boolean using_session;
    private Session session;
    private String target_host;
    private int target_port;
    private InetAddress target_in_addr;
    private InetAddress myHost;
    private int myPort;
    private String[] settings_names = new String[]{"mic_gain", "linein_l_gain", "linein_r_gain", "input_select", "sidetone_attn", "amp_volume", "amp_balance", "amp_treble", "amp_bass", "amp_out", "amp_mute", "amp_enhance", "mouse_thresh", "mouse_velocity", "disp_rez", "disp_blank", "vidin_select", "vidin_bright", "vidin_contrast", "vidin_color", "vidin_tint", "vidin_filter", "vidin_trap", "vidin_colorkill"};

    private static native int getServByName(String var0, String var1);

    public DevControl(SettingsGUI settingsGUI, String string, int n) {
        int n2;
        Debug.printme("in DevControl constructor");
        this.start_time = System.currentTimeMillis();
        this.settings_gui = settingsGUI;
        this.connected = false;
        int n3 = DevControl.getServByName("utservices-low", "udp");
        if (n3 < 0) {
            n3 = 40000;
        }
        if ((n2 = DevControl.getServByName("utservices-high", "udp")) < 0) {
            n2 = 42000;
        }
        try {
            this.dsocket = new DatagramSocket(null);
            this.myPort = n3 + 1;
            while (this.myPort < n2) {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this.myPort);
                try {
                    this.dsocket.bind(inetSocketAddress);
                    break;
                }
                catch (SocketException socketException) {
                    this.dsocket = new DatagramSocket(null);
                    ++this.myPort;
                }
            }
            this.dsocket.setSoTimeout(1000);
            this.myHost = this.dsocket.getLocalAddress();
            this.myPort = this.dsocket.getLocalPort();
            Debug.printme("myPort = " + this.myPort);
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        if (string == null || n == -1) {
            Debug.printme("getting session info and connecting to session manager");
            this.using_session = true;
            this.session = new Session();
            this.session.addObserver(this);
            if (this.session.connect_and_join()) {
                Debug.printme("joined session.");
                this.session.print();
            } else {
                Debug.printme("couldn't join");
                this.settings_gui.post_error("Errors.Connection.SessionManager");
                System.exit(0);
            }
        } else {
            this.using_session = false;
            this.target_host = string;
            this.target_port = n;
            try {
                this.target_in_addr = InetAddress.getByName(this.target_host);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            Debug.printme("using overrides - " + this.target_host + " " + this.target_port);
        }
        this.start();
    }

    private void initialize() {
        this.settings_gui.unpost_all_errors();
        this.mi = new ModelInfo();
        this.header_sequence = 1;
        this.epoch = 0;
        this.cmd_sequence = 0;
        this.contract = 0;
        this.last_outgoing_packet_time = 0L;
        this.last_outgoing_devctl_time = 0L;
        this.last_incoming_devctl_time = 0L;
        if (this.session.desktop_port() == 99999) {
            this.session.send_callme(this.myHost, this.myPort, 0, "utsettings");
        }
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        Debug.printme("+++++ in DevControl::update (" + string + ")");
        if (string.equals("connect")) {
            this.initialize();
            this.connected = true;
        } else {
            this.connected = false;
        }
    }

    public void dump_a_rama(int n) {
        int n2;
        int n3;
        if (n == -1) {
            n3 = 0;
            n2 = 23;
        } else {
            n3 = n;
            n2 = n;
        }
        Debug.printme("  indx \tsg \tenable \tgui \tnewt \tlval0 \tlval1 \tltime");
        for (int i = n3; i <= n2; ++i) {
            int n4 = this.settings_gui.get_control_value(i);
            Debug.printme("  " + i + "\t" + n4 + "\t" + this.mi.send_to_newt_enabled[i] + "\t" + this.mi.gui_val[i] + "\t" + this.mi.newt_val[i] + "\t" + this.mi.last_val_sent[i][0] + "\t" + this.mi.last_val_sent[i][1] + "\t" + this.mi.last_sent_time[i]);
        }
    }

    public synchronized int get_newt_value(int n) {
        return this.mi.newt_val[n];
    }

    public synchronized void poll_pause() {
        this.do_poll = false;
    }

    public synchronized void poll_continue() {
        this.do_poll = true;
        this.notifyAll();
    }

    public synchronized void gui_control_changed(int n, int n2) {
        Debug.printme("+++++ in DevControl::gui_control_changed (" + n + ", " + n2 + ")");
        if (!this.mi.got_initial_settings) {
            return;
        }
        this.mi.gui_val[n] = (short)n2;
        if (this.mi.send_to_newt_enabled[n]) {
            if (this.mi.newt_val[n] != this.mi.gui_val[n]) {
                Debug.printme("  gui_control_changed case 1 - sending " + n2 + " to newt");
                this.mi.send_to_newt_enabled[n] = false;
                this.send_cmd(n, this.mi.newt_val[n], n2, -3, 0, 0);
            } else {
                Debug.printme("  gui_control_changed case 2 (programatic set) - not sending to newt");
            }
        } else {
            Debug.printme("  gui_control_changed case 3 (send disabled) - not sending to newt");
        }
    }

    public synchronized void gui_control_changed(int n, int n2, int n3, int n4) {
        Debug.printme("+++++ in DevControl::gui_control_changed (" + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        if (!this.mi.got_initial_settings) {
            return;
        }
        this.mi.gui_val[n] = (short)n2;
        this.mi.gui_val[n3] = (short)n4;
        if (this.mi.send_to_newt_enabled[n] != this.mi.send_to_newt_enabled[n3]) {
            Debug.printme("*** Enable flags differ for linked settings: " + n + "(" + this.mi.send_to_newt_enabled[n] + ") " + n3 + "(" + this.mi.send_to_newt_enabled[n3] + ")");
        }
        boolean bl = this.mi.newt_val[n] == this.mi.gui_val[n];
        boolean bl2 = this.mi.newt_val[n3] == this.mi.gui_val[n3];
        if (n2 == n4 && bl != bl2) {
            Debug.printme("*** Sync state differs for linked settings:\n  mi.newt_val[" + n + "] = " + this.mi.newt_val[n] + "\n" + "  mi.gui_val[" + n + "] = " + this.mi.gui_val[n] + "\n" + "  mi.newt_val[" + n3 + "] = " + this.mi.newt_val[n3] + "\n" + "  mi.gui_val[" + n3 + "] = " + this.mi.gui_val[n3] + "\n");
        }
        if (this.mi.send_to_newt_enabled[n] || this.mi.send_to_newt_enabled[n3]) {
            if (this.mi.newt_val[n] != this.mi.gui_val[n] || this.mi.newt_val[n3] != this.mi.gui_val[n3]) {
                Debug.printme("  gui_control_changed case 1 - sending " + n2 + " and " + n4 + " to newt");
                this.mi.send_to_newt_enabled[n] = false;
                this.mi.send_to_newt_enabled[n3] = false;
                this.send_cmd(n, this.mi.newt_val[n], n2, n3, this.mi.newt_val[n3], n4);
            } else {
                Debug.printme("  gui_control_changed case 2 (programatic set) - not sending to newt");
            }
        } else {
            Debug.printme("  gui_control_changed case 3 (send disabled) - not sending to newt");
        }
    }

    private synchronized void send_cmd(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n >= 0) {
            Debug.printme("+++++ in DevControl::send_cmd (" + n + ", " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ", " + n6 + ")");
        }
        if (this.using_session) {
            if (!this.connected) {
                Debug.printme("session not connected 1...skipping");
                return;
            }
            if (!this.session.session_connected()) {
                Debug.printme("session not connected 2...skipping *****");
                return;
            }
        }
        Debug.printme("desktop_port " + this.session.desktop_port() + " CALLME " + 99999);
        if (this.session.desktop_port() == 99999) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = n == -2 ? new ByteArrayOutputStream(16) : (n4 == -3 ? new ByteArrayOutputStream(48) : new ByteArrayOutputStream(56));
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            InetAddress inetAddress;
            int n7;
            int n8;
            if (this.epoch == 0) {
                this.epoch = 1;
            }
            if (this.cmd_sequence >= 0xFFFFFE) {
                this.cmd_sequence = 0;
                ++this.epoch;
            }
            dataOutputStream.writeShort(this.header_sequence);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(this.contract);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeShort(32);
            dataOutputStream.writeShort(0);
            if (n != -2) {
                n8 = 0xAC000000 | this.cmd_sequence + 1;
                dataOutputStream.writeInt(n8);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
            }
            if (n != -2) {
                dataOutputStream.writeInt(this.epoch);
                dataOutputStream.writeInt(this.cmd_sequence);
            }
            if (n != -2) {
                n8 = 0xD8000000 | this.cmd_sequence + 2;
                dataOutputStream.writeInt(n8);
                dataOutputStream.writeShort(n);
                if (n4 == -3) {
                    dataOutputStream.writeShort(0);
                } else {
                    dataOutputStream.writeShort(1);
                }
                dataOutputStream.writeShort(n2);
                dataOutputStream.writeShort(n3);
            }
            if (n4 != -3) {
                dataOutputStream.writeShort(n4);
                dataOutputStream.writeShort(0);
                dataOutputStream.writeShort(n5);
                dataOutputStream.writeShort(n6);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (this.using_session) {
                if (!this.session.session_connected()) {
                    Debug.printme("WHOA! session's not connected right now!");
                }
                String string = this.session.desktop_ip_addr();
                n7 = this.session.desktop_port();
                inetAddress = this.session.desktop_inet_addr();
            } else {
                String string = this.target_host;
                n7 = this.target_port;
                inetAddress = this.target_in_addr;
            }
            Debug.printme("desktop_port " + n7 + " CALLME " + 99999);
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n7);
            this.dsocket.send(datagramPacket);
            this.last_outgoing_packet_time = System.currentTimeMillis();
            if (n >= -1) {
                this.last_outgoing_devctl_time = this.last_outgoing_packet_time;
            }
            if (n >= 0) {
                this.mi.last_val_sent[n][1] = this.mi.last_val_sent[n][0];
                this.mi.last_val_sent[n][0] = (short)n3;
                this.mi.last_sent_time[n] = System.currentTimeMillis();
            }
            if (n4 >= 0) {
                this.mi.last_val_sent[n4][1] = this.mi.last_val_sent[n4][0];
                this.mi.last_val_sent[n4][0] = (short)n6;
                this.mi.last_sent_time[n4] = System.currentTimeMillis();
            }
            if (n != -2) {
                this.cmd_sequence += 2;
            }
            ++this.header_sequence;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private boolean filter_message(byte[] byArray, int n) {
        if (n <= 16) {
            return true;
        }
        int n2 = 16;
        int n3 = byArray[n2] & 0xFF;
        return n3 == 193 || n3 == 194 || n3 == 195;
    }

    private short adjust_value(int n, int n2) {
        int n3 = n == 0 || n == 16 ? n2 & Short.MAX_VALUE : n2;
        return (short)n3;
    }

    private synchronized void find_info(byte[] byArray, int n) {
        int n2 = 198;
        if (this.using_session && !this.connected) {
            Debug.printme("***** we're not connected!!");
        }
        if (n <= 16) {
            return;
        }
        int n3 = 16;
        int n4 = byArray[n3] & 0xFF;
        if (n4 != n2) {
            return;
        }
        this.last_incoming_devctl_time = System.currentTimeMillis();
        this.clear_all_times();
        n3 = 22;
        byte by = byArray[n3];
        if (!this.mi.got_initial_settings) {
            int n5;
            Debug.printme("MMMMMM name begins at offset " + ++n3);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(by + 1);
            byteArrayOutputStream.write(byArray, n3, by);
            this.mi.model_name = byteArrayOutputStream.toString();
            Debug.printme("MMMMMM model_name is " + this.mi.model_name);
            this.mi.num_settings = byArray[n3 += by];
            this.extract_read_only_bits(byArray, ++n3, this.mi.num_settings);
            Debug.printme("MMMMMM settings begin at offset " + (n3 += (this.mi.num_settings + 7) / 8));
            if ((n3 & 1) == 1) {
                ++n3;
            }
            Debug.printme("MMMMMM settings begin at offset " + n3);
            for (n5 = 0; n5 < this.mi.num_settings; ++n5) {
                short s = this.build_short(byArray[n3 + 2 * n5], byArray[n3 + 2 * n5 + 1]);
                this.mi.newt_val[n5] = this.adjust_value(n5, s);
            }
            this.mi.got_initial_settings = true;
            for (n5 = 0; n5 < 24; ++n5) {
                this.settings_gui.set_control_value(n5, this.mi.newt_val[n5]);
            }
            for (n5 = 0; n5 < 24; ++n5) {
                if (!this.mi.read_only[n5]) continue;
                this.settings_gui.set_control_state(n5, false);
            }
        } else {
            Debug.printme("+++++ in DevControl::find_info () - got subsequent MODEL_INFO");
            n3 = n3 + 1 + by + 1 + (this.mi.num_settings + 7) / 8;
            if ((n3 & 1) == 1) {
                ++n3;
            }
            for (int i = 0; i < 24; ++i) {
                short s = this.build_short(byArray[n3 + 2 * i], byArray[n3 + 2 * i + 1]);
                s = this.adjust_value(i, s);
                if (this.mi.send_to_newt_enabled[i]) {
                    if (s == this.mi.newt_val[i]) continue;
                    Debug.printme("  setting " + i + ": CASE 1 - " + "currently enabled, so msg " + "must be external...setting slider to " + s);
                    this.mi.newt_val[i] = s;
                    this.settings_gui.set_control_value(i, s);
                    continue;
                }
                Debug.printme("  not enabled, doing compare");
                if (this.mi.gui_val[i] == s) {
                    this.mi.send_to_newt_enabled[i] = true;
                    this.mi.newt_val[i] = s;
                    Debug.printme("  setting " + i + ": CASE 2 - " + "incoming value = gui value, turning enable on");
                    Debug.printme("|");
                    Debug.printme("|");
                    continue;
                }
                Debug.printme("  incoming value (" + s + ") != " + "gui value (" + this.mi.gui_val[i] + ")");
                if (this.mi.newt_val[i] == s) {
                    Debug.printme("  setting " + i + ": CASE 3a - " + "we got the same value twice in a row");
                    if (this.mi.last_val_sent[i][0] == this.mi.last_val_sent[i][1]) {
                        Debug.printme("    BOUNCE!");
                        Debug.printme("      mi.last_val_sent[" + i + "][0] = " + this.mi.last_val_sent[i][0] + "\n" + "      mi.last_val_sent[" + i + "][1] = " + this.mi.last_val_sent[i][1] + "\n" + "      mi.newt_val[" + i + "] = " + this.mi.newt_val[i] + "\n" + "      value = " + s);
                        this.mi.newt_val[i] = s;
                        this.mi.send_to_newt_enabled[i] = true;
                        this.settings_gui.set_control_value(i, s);
                        continue;
                    }
                    Debug.printme("    TRYING AGAIN, sending " + this.mi.gui_val[i]);
                    this.send_cmd(i, s, this.mi.gui_val[i], -3, 0, 0);
                    this.mi.newt_val[i] = s;
                    continue;
                }
                Debug.printme("    CATCH-UP, sending " + this.mi.gui_val[i]);
                this.send_cmd(i, s, this.mi.gui_val[i], -3, 0, 0);
                this.mi.newt_val[i] = s;
            }
        }
    }

    private boolean is_bit_set(byte by, int n) {
        byte by2 = (byte)Math.pow(2.0, n);
        byte by3 = (byte)(by & by2);
        return by3 / by2 == 1;
    }

    private void extract_read_only_bits(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 7;
        for (int i = 0; i < n2; ++i) {
            this.mi.read_only[i] = this.is_bit_set(byArray[n + n3], n4);
            Debug.printme("%%% mi.read_only[" + i + "] = " + this.mi.read_only[i]);
            if (n4 == 0) {
                ++n3;
                n4 = 7;
                continue;
            }
            --n4;
        }
    }

    private short build_short(byte by, byte by2) {
        int n = by & 0xFF;
        int n2 = by2 & 0xFF;
        int n3 = n * 256 + n2;
        return (short)n3;
    }

    private void print_packet(char c, byte[] byArray, int n) {
        Debug.printme("---------------------------------");
        int n2 = 0;
        for (int i = 0; i < n; i += 4) {
            Debug.printme(c + " " + n2 + "   | " + (byArray[i] & 0xFF) + " | " + (byArray[i + 1] & 0xFF) + " | " + (byArray[i + 2] & 0xFF) + " | " + (byArray[i + 3] & 0xFF) + " | ");
            ++n2;
        }
    }

    private void clear_all_times() {
        for (int i = 0; i < 24; ++i) {
            this.mi.last_sent_time[i] = 0L;
        }
    }

    private boolean check_for_missing_responses() {
        long l = System.currentTimeMillis();
        boolean bl = false;
        for (int i = 0; i < 24; ++i) {
            if (this.mi.last_sent_time[i] == 0L) continue;
            bl = true;
            if (l <= this.mi.last_sent_time[i] + 3000L) continue;
            Debug.printme("TIMEOUT waiting for response on setting " + i);
            Debug.printme("  last was " + this.mi.last_val_sent[i][0]);
            this.send_cmd(i, this.mi.newt_val[i], this.mi.last_val_sent[i][0], -3, 0, 0);
        }
        this.last_response_check_time = System.currentTimeMillis();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] byArray = new byte[2048];
        boolean bl = false;
        boolean bl2 = false;
        Debug.printme("in run");
        Thread thread = Thread.currentThread();
        thread.setName("DevControl");
        while (true) {
            boolean bl3 = true;
            long l = System.currentTimeMillis();
            if (l > this.last_response_check_time + 1000L) {
                Debug.printme("RRR check");
                boolean bl4 = bl3 = !this.check_for_missing_responses();
            }
            if (bl3 && !this.do_poll) {
                DevControl devControl = this;
                synchronized (devControl) {
                    while (!this.do_poll) {
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (!this.do_poll) {
                Debug.printme("quiescent");
            } else if (l > this.last_outgoing_devctl_time + 5000L) {
                Debug.printme("RRR devctl");
                this.send_cmd(-1, 0, 0, -3, 0, 0);
            } else if (l > this.last_outgoing_packet_time + 1000L) {
                Debug.printme("RRR ping");
                this.send_cmd(-2, 0, 0, -3, 0, 0);
            }
            if (this.last_incoming_devctl_time == 0L && !bl) {
                if (this.using_session) {
                    if (l > this.session.get_connect_time() + 8000L) {
                        this.settings_gui.post_error("Errors.Connection.Desktop");
                        bl = true;
                    }
                } else if (l > this.start_time + 8000L) {
                    this.settings_gui.post_error("Errors.Connection.Desktop");
                    bl = true;
                }
            }
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.reader_started = true;
                this.dsocket.receive(datagramPacket);
                if (this.session.desktop_port() == 99999) {
                    this.session.setPort(datagramPacket.getPort());
                    Debug.printme("got port " + datagramPacket.getPort());
                }
                byte[] byArray2 = datagramPacket.getData();
                if (datagramPacket.getLength() >= 16) {
                    this.contract = this.build_short(byArray2[4], byArray2[5]);
                    if (this.contract != 1) {
                        Debug.printme("HEY!! received contract = " + this.contract);
                    }
                }
                if (this.filter_message(byArray2, datagramPacket.getLength())) continue;
                this.find_info(byArray2, datagramPacket.getLength());
                continue;
            }
            catch (InterruptedIOException interruptedIOException) {
                Debug.printme("RRR received timed out");
                try {
                    DevControl.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            break;
        }
    }

    class ModelInfo {
        boolean got_initial_settings = false;
        String model_name;
        int num_settings;
        boolean[] read_only = new boolean[256];
        boolean[] send_to_newt_enabled = new boolean[256];
        short[] newt_val = new short[256];
        short[] gui_val = new short[256];
        short[][] last_val_sent = new short[256][2];
        long[] last_sent_time = new long[256];

        public ModelInfo() {
            for (int i = 0; i < 256; ++i) {
                this.send_to_newt_enabled[i] = true;
                this.newt_val[i] = 0;
                this.gui_val[i] = 0;
                this.last_val_sent[i][0] = -1;
                this.last_val_sent[i][1] = -1;
                this.last_sent_time[i] = 0L;
            }
        }

        public void print() {
            for (int i = 0; i < this.num_settings; ++i) {
                Debug.printme(i + " " + DevControl.this.settings_names[i] + " " + this.read_only[i] + " " + this.newt_val[i]);
            }
        }
    }
}

