/*
 * Decompiled with CFR 0.152.
 */
import auth.sdk.InvalidSessionException;
import auth.sdk.Log;
import auth.sdk.ParseOptions;
import auth.sdk.SessionCred;
import auth.sdk.Token;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class SettingsGUI
extends Frame {
    private static final String SCCS_ID = "@(#)SettingsGUI.java\t1.50 07/05/23 SMI";
    static final int NUM_DEVS = 24;
    static final int MAX_NEWT_VOL = 31;
    static final int RES_CHANGE_TIMEOUT = 10;
    static final int DEFAULT_PORT = 5496;
    static final String DEFAULT_HOTKEY = "Shift SunProps";
    static final int OSD_ICON_HEIGHT = 128;
    static final int OSD_VERT_SPACE = 16;
    static final String SITEWIDE_DEFAULTS_FILE = "/etc/opt/SUNWut/utsettings_defaults.properties";
    static final String USER_DEFAULTS_FILE = ".utsettings.properties";
    static final String SITEWIDE_MANDATORY_DEFAULTS_FILE = "/etc/opt/SUNWut/utsettings_mandatory.properties";
    static final int BALANCE_MIDDLE = 32;
    static final int TONE_MIDDLE = 6;
    static final int MOTIF_DEFAULT_BG = -9265153;
    static final String PREFS_HELPER_PATH = "/opt/SUNWut/lib/utprefs-helper";
    private DevControl devctl;
    private Component[] control;
    private Component[] display;
    private CDialog conf_dialog;
    private CDialog error_dialog;
    private Button test_set_button;
    private Button test_get_button;
    private TextField test_index_tf;
    private TextField test_val_tf;
    boolean hotkey_mode = false;
    boolean exit_on_hotkey_mode = false;
    private ResourceBundle rb;
    private Choice choice1;
    private Label choice_cap;
    private Label card_label;
    private Label copyright_cap;
    private Panel cardholder;
    private Panel audio_input_panel;
    private Panel audio_output_panel;
    private Panel display_panel;
    private Panel video_panel;
    private Panel audio_input_panel2;
    private Panel audio_output_panel2;
    private Panel display_panel2;
    private Panel video_panel2;
    private Label audio_output_label;
    private Label output_sel_cap;
    private Label vol_cap;
    private Label balance_cap;
    private Label mute_cap;
    private Label enhance_cap;
    private Label treble_cap;
    private Label bass_cap;
    private CLabel vol_display;
    private CLabel balance_display;
    private CLabel treble_display;
    private CLabel bass_display;
    private Checkbox output_sel_rad1;
    private Checkbox output_sel_rad2;
    private Checkbox output_sel_rad3;
    private Checkbox mute_cb;
    private Checkbox enhance_cb;
    private CScrollbar vol_hsb;
    private CScrollbar balance_hsb;
    private CScrollbar treble_hsb;
    private CScrollbar bass_hsb;
    private Label audio_input_label;
    private Label input_sel_cap;
    private Label mic_gain_cap;
    private Label line_gain_left_cap;
    private Label line_gain_right_cap;
    private Label mon_vol_cap;
    private CLabel mic_gain_display;
    private CLabel line_gain_left_display;
    private CLabel line_gain_right_display;
    private CLabel mon_vol_display;
    private Checkbox input_sel_rad1;
    private Checkbox input_sel_rad2;
    private CheckboxGroup input_sel_group;
    private CScrollbar mic_gain_hsb;
    private CScrollbar line_gain_left_hsb;
    private CScrollbar line_gain_right_hsb;
    private CScrollbar mon_vol_hsb;
    private Label display_label;
    private Label res_cap;
    private Choice res_choice;
    private Label video_label;
    private Label brightness_cap;
    private Label contrast_cap;
    private Label color_cap;
    private Label tint_cap;
    private Label filter_cap;
    private Label trap_cap;
    private CLabel brightness_display;
    private CLabel contrast_display;
    private CLabel color_display;
    private CLabel tint_display;
    private CLabel filter_display;
    private Checkbox trap_cb;
    private CScrollbar brightness_hsb;
    private CScrollbar contrast_hsb;
    private CScrollbar color_hsb;
    private CScrollbar tint_hsb;
    private CScrollbar filter_hsb;

    public native int watchForHotKeys(String var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public native boolean privilegedUser();

    public static native void printThread(String var0);

    public static native int getPID();

    public static native int getTID();

    public static native int getLWPID();

    public static void main(String[] stringArray) {
        new SettingsGUI(stringArray);
    }

    public SettingsGUI(String[] stringArray) {
        Object object;
        Serializable serializable;
        String string;
        String string2 = null;
        int n = -1;
        String string3 = null;
        String string4 = System.getProperty("SETTINGS_DEBUG");
        if (string4 != null) {
            Debug.set_debug_string(string4);
        }
        Thread thread = Thread.currentThread();
        thread.setName("SettingsGUI");
        try {
            this.rb = ResourceBundle.getBundle("UTSettings");
        }
        catch (MissingResourceException missingResourceException) {
            System.err.print("Error: could not find resource bundle\n");
            System.exit(1);
        }
        ParseOptions parseOptions = new ParseOptions(stringArray, "Hek:");
        Object object2 = parseOptions.keys();
        block13: while (object2.hasMoreElements()) {
            Character c = (Character)object2.nextElement();
            Object object3 = parseOptions.getValue(c);
            switch (c.charValue()) {
                case 'H': {
                    this.hotkey_mode = true;
                    continue block13;
                }
                case 'e': {
                    this.exit_on_hotkey_mode = true;
                    continue block13;
                }
                case 'k': {
                    string3 = (String)object3;
                    continue block13;
                }
            }
            string = this.simple_msg("Errors.CommandLine.InvalidOption", parseOptions.errorOpt);
            System.err.print(string + "\n\n");
            this.usage();
            System.exit(1);
        }
        if (n != -1 && string2 == null) {
            string = this.rb.getString("Errors.CommandLine.NoHost");
            System.err.print(string + "\n\n");
            System.exit(1);
        } else if (string2 != null && n == -1) {
            n = 5496;
        }
        if (this.exit_on_hotkey_mode && !this.hotkey_mode) {
            this.exit_on_hotkey_mode = false;
        }
        if (this.hotkey_mode && string3 == null) {
            string3 = DEFAULT_HOTKEY;
            Debug.printme("using default hotkey of " + string3);
        } else {
            Debug.printme("hotkey is " + string3);
        }
        SystemColor systemColor = SystemColor.control;
        int n2 = systemColor.getRGB();
        if (n2 != -9265153) {
            this.setBackground(systemColor);
            systemColor = SystemColor.controlText;
            this.setForeground(systemColor);
        }
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
        if (string2 == null) {
            this.setTitle(this.rb.getString("GUI.Title"));
        } else {
            this.setTitle(this.rb.getString("GUI.Title") + " - " + string2);
        }
        Panel panel = new Panel(new GridBagLayout());
        this.choice_cap = new Label(this.rb.getString("GUI.CategoryPulldown.Caption") + ":");
        this.choice_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(panel, this.choice_cap, 0, 0, 1, 1, 10, 0, 0, 0, 0, 0, 0, 0);
        this.choice1 = new Choice();
        this.choice1.addItem(this.rb.getString("GUI.CategoryPulldown.AudioOutput"));
        this.choice1.addItem(this.rb.getString("GUI.CategoryPulldown.AudioInput"));
        this.choice1.addItem(this.rb.getString("GUI.CategoryPulldown.Display"));
        this.choice1.addItem(this.rb.getString("GUI.CategoryPulldown.Video"));
        try {
            this.choice1.select(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.gb_add(panel, this.choice1, 1, 0, 1, 1, 10, 0, 0, 0, 0, 0, 0, 0);
        this.gb_add(this, panel, 0, 0, 1, 1, 10, 8, 0, 0, 0, 0, 0, 0);
        this.card_label = new Label("  " + this.rb.getString("GUI.CategoryPulldown.AudioOutput").toUpperCase());
        this.card_label.setFont(new Font("Dialog", 1, 12));
        this.card_label.setBackground(Color.gray);
        this.gb_add(this, this.card_label, 0, 1, 1, 1, 10, 8, 0, 0, 0, 2, 0, 0);
        this.cardholder = new Panel();
        this.cardholder.setLayout(new CardLayout(0, 0));
        this.gb_add(this, this.cardholder, 0, 2, 1, 1, 10, 10, 0, 0, 0, 0, 0, 0);
        Panel panel2 = new Panel(new GridBagLayout());
        this.copyright_cap = new Label(this.rb.getString("GUI.Copyright.Caption"));
        this.gb_add(panel2, this.copyright_cap, 0, 0, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.gb_add(this, panel2, 0, 3, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.audio_output_panel = new Panel(new GridBagLayout());
        this.audio_output_panel.setVisible(false);
        this.cardholder.add(this.rb.getString("GUI.CategoryPulldown.AudioOutput"), this.audio_output_panel);
        this.audio_output_panel2 = new Panel(new GridBagLayout());
        this.output_sel_cap = new Label(this.rb.getString("GUI.AudioOutput.OutputSelect") + ":", 2);
        this.output_sel_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.audio_output_panel2, this.output_sel_cap, 0, 0, 1, 1, 13, 0, 0, 0, 8, 0, 0, 0);
        Panel panel3 = new Panel(new GridBagLayout());
        this.output_sel_rad1 = new Checkbox(this.rb.getString("GUI.AudioOutput.OutputSelect.Auto"), true);
        this.gb_add(panel3, this.output_sel_rad1, 0, 0, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.output_sel_rad2 = new Checkbox(this.rb.getString("GUI.AudioOutput.OutputSelect.Speaker"), false);
        this.gb_add(panel3, this.output_sel_rad2, 1, 0, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.output_sel_rad3 = new Checkbox(this.rb.getString("GUI.AudioOutput.OutputSelect.Headphone"), false);
        this.gb_add(panel3, this.output_sel_rad3, 2, 0, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.gb_add(this.audio_output_panel2, panel3, 1, 0, 2, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.vol_cap = new Label(this.rb.getString("GUI.AudioOutput.Volume") + ":", 2);
        this.vol_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.audio_output_panel2, this.vol_cap, 0, 1, 1, 1, 13, 10, 0, 0, 8, 0, 0, 0);
        this.vol_hsb = new CScrollbar(0, 0, 1, 0, 32);
        this.vol_hsb.setBlockIncrement(4);
        this.vol_hsb.set_preferred_size_overrides(120, 14);
        this.gb_add(this.audio_output_panel2, this.vol_hsb, 1, 1, 1, 1, 17, 10, 0, 0, 0, 0, 0, 0);
        this.vol_display = new CLabel("", 2);
        this.gb_add(this.audio_output_panel2, this.vol_display, 2, 1, 1, 1, 17, 10, 0, 0, 0, 0, 0, 0);
        this.balance_cap = new Label(this.rb.getString("GUI.AudioOutput.Balance") + ":", 2);
        this.balance_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.audio_output_panel2, this.balance_cap, 0, 2, 1, 1, 13, 0, 0, 0, 8, 0, 0, 0);
        this.balance_hsb = new CScrollbar(0, 0, 1, 0, 65);
        this.balance_hsb.setBlockIncrement(4);
        this.balance_hsb.set_preferred_size_overrides(120, 14);
        this.gb_add(this.audio_output_panel2, this.balance_hsb, 1, 2, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.balance_display = new CLabel("", 2);
        this.gb_add(this.audio_output_panel2, this.balance_display, 2, 2, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.mute_cap = new Label(this.rb.getString("GUI.AudioOutput.Mute") + ":", 2);
        this.mute_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.audio_output_panel2, this.mute_cap, 0, 3, 1, 1, 13, 0, 0, 0, 8, 0, 0, 0);
        Panel panel4 = new Panel(new GridBagLayout());
        this.mute_cb = new Checkbox("");
        this.gb_add(panel4, this.mute_cb, 0, 0, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.enhance_cap = new Label(this.rb.getString("GUI.AudioOutput.StereoEnhance") + ":", 2);
        this.enhance_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(panel4, this.enhance_cap, 1, 0, 1, 1, 17, 0, 0, 0, 8, 0, 0, 0);
        this.enhance_cb = new Checkbox("");
        this.gb_add(panel4, this.enhance_cb, 2, 0, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.gb_add(this.audio_output_panel2, panel4, 1, 3, 2, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.treble_cap = new Label(this.rb.getString("GUI.AudioOutput.Treble") + ":", 2);
        this.treble_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.audio_output_panel2, this.treble_cap, 0, 4, 1, 1, 13, 10, 0, 0, 8, 0, 0, 0);
        this.treble_hsb = new CScrollbar(0, 0, 1, 0, 13);
        this.treble_hsb.setBlockIncrement(2);
        this.treble_hsb.set_preferred_size_overrides(120, 14);
        this.gb_add(this.audio_output_panel2, this.treble_hsb, 1, 4, 1, 1, 17, 10, 0, 0, 0, 0, 0, 0);
        this.treble_display = new CLabel("", 2);
        this.gb_add(this.audio_output_panel2, this.treble_display, 2, 4, 1, 1, 17, 10, 0, 0, 0, 0, 0, 0);
        this.bass_cap = new Label(this.rb.getString("GUI.AudioOutput.Bass") + ":", 2);
        this.bass_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.audio_output_panel2, this.bass_cap, 0, 5, 1, 1, 13, 0, 0, 15, 8, 0, 0, 0);
        this.bass_hsb = new CScrollbar(0, 0, 1, 0, 13);
        this.bass_hsb.setBlockIncrement(2);
        this.bass_hsb.set_preferred_size_overrides(120, 14);
        this.gb_add(this.audio_output_panel2, this.bass_hsb, 1, 5, 1, 1, 17, 0, 0, 15, 0, 0, 0, 0);
        this.bass_display = new CLabel("", 2);
        this.gb_add(this.audio_output_panel2, this.bass_display, 2, 5, 1, 1, 17, 0, 0, 15, 0, 0, 0, 0);
        this.gb_add(this.audio_output_panel, this.audio_output_panel2, 0, 0, 1, 1, 11, 0, 0, 0, 0, 0, 0, 1);
        this.audio_input_panel = new Panel(new GridBagLayout());
        this.cardholder.add(this.rb.getString("GUI.CategoryPulldown.AudioInput"), this.audio_input_panel);
        this.audio_input_panel2 = new Panel(new GridBagLayout());
        this.input_sel_cap = new Label(this.rb.getString("GUI.AudioInput.InputSelect") + ":", 2);
        this.input_sel_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.audio_input_panel2, this.input_sel_cap, 0, 0, 1, 1, 13, 0, 0, 0, 8, 0, 0, 0);
        this.input_sel_group = new CheckboxGroup();
        Panel panel5 = new Panel(new GridBagLayout());
        this.input_sel_rad1 = new Checkbox(" " + this.rb.getString("GUI.AudioInput.InputSelect.Microphone"), this.input_sel_group, false);
        this.gb_add(panel5, this.input_sel_rad1, 0, 0, 1, 1, 17, 0, 0, 0, 8, 0, 0, 0);
        this.input_sel_rad2 = new Checkbox(" " + this.rb.getString("GUI.AudioInput.InputSelect.LineIn"), this.input_sel_group, false);
        this.gb_add(panel5, this.input_sel_rad2, 1, 0, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.gb_add(this.audio_input_panel2, panel5, 1, 0, 2, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.mic_gain_cap = new Label(this.rb.getString("GUI.AudioInput.MicGain") + ":", 2);
        this.mic_gain_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.audio_input_panel2, this.mic_gain_cap, 0, 1, 1, 1, 13, 10, 0, 0, 8, 0, 0, 0);
        this.mic_gain_hsb = new CScrollbar(0, 0, 1, 0, 76);
        this.mic_gain_hsb.setBlockIncrement(4);
        this.mic_gain_hsb.set_preferred_size_overrides(120, 14);
        this.gb_add(this.audio_input_panel2, this.mic_gain_hsb, 1, 1, 1, 1, 17, 10, 0, 0, 8, 2, 0, 0);
        this.mic_gain_display = new CLabel("", 2);
        this.gb_add(this.audio_input_panel2, this.mic_gain_display, 2, 1, 1, 1, 17, 10, 0, 0, 0, 0, 0, 0);
        this.line_gain_left_cap = new Label(this.rb.getString("GUI.AudioInput.LineInGainL") + ":", 2);
        this.line_gain_left_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.audio_input_panel2, this.line_gain_left_cap, 0, 2, 1, 1, 13, 10, 0, 0, 8, 0, 0, 0);
        this.line_gain_left_hsb = new CScrollbar(0, 0, 1, 0, 16);
        this.line_gain_left_hsb.setBlockIncrement(3);
        this.line_gain_left_hsb.set_preferred_size_overrides(120, 14);
        this.gb_add(this.audio_input_panel2, this.line_gain_left_hsb, 1, 2, 1, 1, 17, 10, 0, 0, 8, 2, 0, 0);
        this.line_gain_left_display = new CLabel("", 2);
        this.gb_add(this.audio_input_panel2, this.line_gain_left_display, 2, 2, 1, 1, 17, 10, 0, 0, 0, 0, 0, 0);
        this.line_gain_right_cap = new Label(this.rb.getString("GUI.AudioInput.LineInGainR") + ":", 2);
        this.line_gain_right_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.audio_input_panel2, this.line_gain_right_cap, 0, 3, 1, 1, 13, 0, 0, 0, 8, 0, 0, 0);
        this.line_gain_right_hsb = new CScrollbar(0, 0, 1, 0, 16);
        this.line_gain_right_hsb.setBlockIncrement(3);
        this.line_gain_right_hsb.set_preferred_size_overrides(120, 14);
        this.gb_add(this.audio_input_panel2, this.line_gain_right_hsb, 1, 3, 1, 1, 17, 0, 0, 0, 8, 2, 0, 0);
        this.line_gain_right_display = new CLabel("", 2);
        this.gb_add(this.audio_input_panel2, this.line_gain_right_display, 2, 3, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.mon_vol_cap = new Label(this.rb.getString("GUI.AudioInput.MonitorVolume") + ":", 2);
        this.mon_vol_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.audio_input_panel2, this.mon_vol_cap, 0, 4, 1, 1, 13, 10, 0, 15, 8, 0, 0, 0);
        this.mon_vol_hsb = new CScrollbar(0, 0, 1, 0, 65);
        this.mon_vol_hsb.setBlockIncrement(8);
        this.mon_vol_hsb.set_preferred_size_overrides(120, 14);
        this.gb_add(this.audio_input_panel2, this.mon_vol_hsb, 1, 4, 1, 1, 17, 10, 0, 15, 8, 2, 0, 0);
        this.mon_vol_display = new CLabel("", 2);
        this.gb_add(this.audio_input_panel2, this.mon_vol_display, 2, 4, 1, 1, 17, 10, 0, 15, 0, 0, 0, 0);
        this.gb_add(this.audio_input_panel, this.audio_input_panel2, 0, 0, 1, 1, 11, 0, 0, 0, 0, 0, 0, 1);
        this.display_panel = new Panel(new GridBagLayout());
        this.display_panel.setVisible(false);
        this.cardholder.add(this.rb.getString("GUI.CategoryPulldown.Display"), this.display_panel);
        this.display_panel2 = new Panel(new GridBagLayout());
        this.res_cap = new Label(this.rb.getString("GUI.Display.ResRefresh") + ":", 2);
        this.res_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.display_panel2, this.res_cap, 0, 0, 1, 1, 13, 0, 0, 0, 8, 0, 0, 0);
        this.res_choice = new Choice();
        this.res_choice.addItem(this.rb.getString("GUI.Display.ResRefresh.Standard"));
        this.res_choice.addItem(this.rb.getString("GUI.Display.ResRefresh.Monitor"));
        object2 = "Site-Defined";
        try {
            object2 = this.rb.getString("GUI.Display.ResRefresh.SiteDefined");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.res_choice.addItem((String)object2);
        this.res_choice.addItem("640x480 @ 60 Hz");
        this.res_choice.addItem("640x480 @ 75 Hz");
        this.res_choice.addItem("640x480 @ 85 Hz");
        this.res_choice.addItem("800x600 @ 60 Hz");
        this.res_choice.addItem("800x600 @ 75 Hz");
        this.res_choice.addItem("800x600 @ 85 Hz");
        this.res_choice.addItem("1024x768 @ 60 Hz");
        this.res_choice.addItem("1024x768 @ 75 Hz");
        this.res_choice.addItem("1024x768 @ 85 Hz");
        this.res_choice.addItem("1152x900 @ 66 Hz");
        this.res_choice.addItem("1152x900 @ 76 Hz");
        this.res_choice.addItem("1280x1024 @ 60 Hz");
        this.res_choice.addItem("1280x1024 @ 66 Hz");
        this.res_choice.addItem("1280x1024 @ 75 Hz");
        this.res_choice.addItem("1280x1024 @ 76 Hz");
        this.res_choice.addItem("1280x1024 @ 85 Hz");
        this.res_choice.addItem("1400x1050 @ 60 Hz");
        this.res_choice.addItem("1440x900 @ 60 Hz");
        this.res_choice.addItem("1600x1024 @ 60 Hz");
        this.res_choice.addItem("1600x1200 @ 60 Hz");
        this.res_choice.addItem("1600x1200 @ 60 Hz [D]");
        this.res_choice.addItem("1600x1200 @ 75 Hz");
        this.res_choice.addItem("1680x1050 @ 60 Hz");
        this.res_choice.addItem("1920x1080 @ 60 Hz [D]");
        this.res_choice.addItem("1920x1080 @ 70 Hz");
        this.res_choice.addItem("1920x1080 @ 72 Hz");
        this.res_choice.addItem("1920x1200 @ 60 Hz [D]");
        this.res_choice.addItem("1920x1200 @ 70 Hz");
        try {
            this.res_choice.select(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.gb_add(this.display_panel2, this.res_choice, 1, 0, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        Panel panel6 = new Panel(new GridBagLayout());
        this.gb_add(this.display_panel2, panel6, 1, 1, 1, 1, 17, 10, 0, 0, 0, 0, 0, 0);
        this.gb_add(this.display_panel, this.display_panel2, 0, 0, 1, 1, 11, 0, 0, 0, 0, 0, 0, 1);
        this.video_panel = new Panel(new GridBagLayout());
        this.video_panel.setVisible(false);
        this.cardholder.add(this.rb.getString("GUI.CategoryPulldown.Video"), this.video_panel);
        this.video_panel2 = new Panel(new GridBagLayout());
        this.brightness_cap = new Label(this.rb.getString("GUI.Video.Brightness") + ":", 2);
        this.brightness_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.video_panel2, this.brightness_cap, 0, 0, 1, 1, 13, 0, 0, 0, 8, 0, 0, 0);
        this.brightness_hsb = new CScrollbar(0, 0, 1, 0, 256);
        this.brightness_hsb.set_preferred_size_overrides(120, 14);
        this.brightness_hsb.setBlockIncrement(8);
        this.gb_add(this.video_panel2, this.brightness_hsb, 1, 0, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.brightness_display = new CLabel("", 2);
        this.gb_add(this.video_panel2, this.brightness_display, 2, 0, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.contrast_cap = new Label(this.rb.getString("GUI.Video.Contrast") + ":", 2);
        this.contrast_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.video_panel2, this.contrast_cap, 0, 1, 1, 1, 13, 0, 0, 0, 8, 0, 0, 0);
        this.contrast_hsb = new CScrollbar(0, 0, 1, 0, 64);
        this.contrast_hsb.set_preferred_size_overrides(120, 14);
        this.contrast_hsb.setBlockIncrement(2);
        this.gb_add(this.video_panel2, this.contrast_hsb, 1, 1, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.contrast_display = new CLabel("", 2);
        this.gb_add(this.video_panel2, this.contrast_display, 2, 1, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.color_cap = new Label(this.rb.getString("GUI.Video.Color") + ":", 2);
        this.color_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.video_panel2, this.color_cap, 0, 2, 1, 1, 13, 0, 0, 0, 8, 0, 0, 0);
        this.color_hsb = new CScrollbar(0, 0, 1, 0, 128);
        this.color_hsb.set_preferred_size_overrides(120, 14);
        this.color_hsb.setBlockIncrement(4);
        this.gb_add(this.video_panel2, this.color_hsb, 1, 2, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.color_display = new CLabel("", 2);
        this.gb_add(this.video_panel2, this.color_display, 2, 2, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.tint_cap = new Label(this.rb.getString("GUI.Video.Tint") + ":", 2);
        this.tint_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.video_panel2, this.tint_cap, 0, 3, 1, 1, 13, 0, 0, 0, 8, 0, 0, 0);
        this.tint_hsb = new CScrollbar(0, 0, 1, 0, 256);
        this.tint_hsb.set_preferred_size_overrides(120, 14);
        this.tint_hsb.setBlockIncrement(8);
        this.gb_add(this.video_panel2, this.tint_hsb, 1, 3, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.tint_display = new CLabel("", 2);
        this.gb_add(this.video_panel2, this.tint_display, 2, 3, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0);
        this.filter_cap = new Label(this.rb.getString("GUI.Video.Filter") + ":", 2);
        this.filter_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.video_panel2, this.filter_cap, 0, 4, 1, 1, 13, 10, 0, 0, 8, 0, 0, 0);
        this.filter_hsb = new CScrollbar(0, 0, 1, 0, 4);
        this.filter_hsb.set_preferred_size_overrides(120, 14);
        this.filter_hsb.setBlockIncrement(1);
        this.gb_add(this.video_panel2, this.filter_hsb, 1, 4, 1, 1, 17, 10, 0, 0, 0, 0, 0, 0);
        this.filter_display = new CLabel("", 2);
        this.gb_add(this.video_panel2, this.filter_display, 2, 4, 1, 1, 17, 10, 0, 0, 0, 0, 0, 0);
        this.trap_cap = new Label(this.rb.getString("GUI.Video.ColorTrap") + ":", 2);
        this.trap_cap.setFont(new Font("Dialog", 1, 12));
        this.gb_add(this.video_panel2, this.trap_cap, 0, 5, 1, 1, 13, 0, 0, 0, 8, 0, 0, 0);
        this.trap_cb = new Checkbox("");
        this.gb_add(this.video_panel2, this.trap_cb, 1, 5, 1, 1, 17, 0, -5, 0, 8, 0, 0, 0);
        this.gb_add(this.video_panel, this.video_panel2, 0, 0, 1, 1, 11, 0, 0, 0, 0, 0, 0, 1);
        Toolkit toolkit = this.getToolkit();
        if (toolkit != null) {
            serializable = toolkit.getScreenSize();
            Debug.printme("SSS screen width = " + ((Dimension)serializable).width + ", height = " + ((Dimension)serializable).height);
            int n3 = ((Dimension)serializable).width / 2;
            int n4 = ((Dimension)serializable).height / 2 - 64 - 16 - 60;
            Debug.printme("SSS temp placing at " + n3 + ", " + n4);
            this.setLocation(n3, n4);
            this.pack();
            object = this.getSize();
            Debug.printme("SSS dialog width = " + ((Dimension)object).width + ", height = " + ((Dimension)object).height);
            n3 = ((Dimension)serializable).width / 2 - ((Dimension)object).width / 2;
            n4 = ((Dimension)serializable).height / 2 - 64 - ((Dimension)object).height - 16;
            if (n4 < 0) {
                n4 = ((Dimension)serializable).height / 2 - ((Dimension)object).height / 2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            Debug.printme("SSS placing at " + n3 + ", " + n4);
            this.setLocation(n3, n4);
        }
        ((CardLayout)this.cardholder.getLayout()).show(this.cardholder, this.rb.getString("GUI.CategoryPulldown.AudioOutput"));
        this.control = new Component[24];
        this.display = new Component[24];
        this.control[0] = this.mic_gain_hsb;
        this.control[1] = this.line_gain_left_hsb;
        this.control[2] = this.line_gain_right_hsb;
        serializable = new CheckboxHolder(2);
        ((CheckboxHolder)serializable).hold_checkbox(0, this.input_sel_rad1);
        ((CheckboxHolder)serializable).hold_checkbox(1, this.input_sel_rad2);
        this.control[3] = serializable;
        this.control[4] = this.mon_vol_hsb;
        this.display[0] = this.mic_gain_display;
        this.display[1] = this.line_gain_left_display;
        this.display[2] = this.line_gain_right_display;
        this.display[3] = null;
        this.display[4] = this.mon_vol_display;
        this.control[5] = this.vol_hsb;
        this.control[6] = this.balance_hsb;
        this.control[7] = this.treble_hsb;
        this.control[8] = this.bass_hsb;
        serializable = new CheckboxHolder(3);
        ((CheckboxHolder)serializable).hold_checkbox(0, this.output_sel_rad1);
        ((CheckboxHolder)serializable).hold_checkbox(1, this.output_sel_rad2);
        ((CheckboxHolder)serializable).hold_checkbox(2, this.output_sel_rad3);
        this.control[9] = serializable;
        this.control[10] = this.mute_cb;
        this.control[11] = this.enhance_cb;
        this.display[5] = this.vol_display;
        this.display[6] = this.balance_display;
        this.display[7] = this.treble_display;
        this.display[8] = this.bass_display;
        this.display[9] = null;
        this.display[10] = null;
        this.display[11] = null;
        this.display[12] = null;
        this.display[13] = null;
        this.control[14] = this.res_choice;
        this.display[14] = null;
        this.display[15] = null;
        this.control[16] = null;
        this.control[17] = this.brightness_hsb;
        this.control[18] = this.contrast_hsb;
        this.control[19] = this.color_hsb;
        this.control[20] = this.tint_hsb;
        this.control[21] = this.filter_hsb;
        this.control[22] = this.trap_cb;
        this.control[23] = null;
        this.display[16] = null;
        this.display[17] = this.brightness_display;
        this.display[18] = this.contrast_display;
        this.display[19] = this.color_display;
        this.display[20] = this.tint_display;
        this.display[21] = this.filter_display;
        this.display[22] = null;
        this.display[23] = null;
        this.conf_dialog = new CDialog((Frame)this, this.rb.getString("GUI.ConfirmationDialog.OK"), this.rb.getString("GUI.ConfirmationDialog.Cancel"));
        this.conf_dialog.setTitle(this.rb.getString("GUI.ConfirmationDialog.Title"));
        object = new WindowA();
        this.addWindowListener((WindowListener)object);
        AdjustmentL adjustmentL = new AdjustmentL();
        this.mic_gain_hsb.addAdjustmentListener(adjustmentL);
        this.line_gain_left_hsb.addAdjustmentListener(adjustmentL);
        this.line_gain_right_hsb.addAdjustmentListener(adjustmentL);
        this.mon_vol_hsb.addAdjustmentListener(adjustmentL);
        this.vol_hsb.addAdjustmentListener(adjustmentL);
        this.balance_hsb.addAdjustmentListener(adjustmentL);
        this.treble_hsb.addAdjustmentListener(adjustmentL);
        this.bass_hsb.addAdjustmentListener(adjustmentL);
        this.brightness_hsb.addAdjustmentListener(adjustmentL);
        this.contrast_hsb.addAdjustmentListener(adjustmentL);
        this.color_hsb.addAdjustmentListener(adjustmentL);
        this.tint_hsb.addAdjustmentListener(adjustmentL);
        this.filter_hsb.addAdjustmentListener(adjustmentL);
        ActionL actionL = new ActionL();
        if (this.test_set_button != null) {
            this.test_set_button.addActionListener(actionL);
        }
        if (this.test_get_button != null) {
            this.test_get_button.addActionListener(actionL);
        }
        ItemL itemL = new ItemL();
        this.choice1.addItemListener(itemL);
        this.input_sel_rad1.addItemListener(itemL);
        this.input_sel_rad2.addItemListener(itemL);
        this.output_sel_rad1.addItemListener(itemL);
        this.output_sel_rad2.addItemListener(itemL);
        this.output_sel_rad3.addItemListener(itemL);
        this.mute_cb.addItemListener(itemL);
        this.enhance_cb.addItemListener(itemL);
        this.res_choice.addItemListener(itemL);
        this.trap_cb.addItemListener(itemL);
        this.devctl = new DevControl(this, string2, n);
        if (this.hotkey_mode) {
            this.enable_hotkey_detection(string3);
            if (this.exit_on_hotkey_mode) {
                this.set_visible(true);
            } else {
                this.set_visible(false);
            }
        } else {
            this.set_visible(true);
        }
    }

    private String simple_msg(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        String string3 = MessageFormat.format(this.rb.getString(string), objectArray);
        return string3;
    }

    private String simple_msg(String string, char c) {
        Character c2 = new Character(c);
        Object[] objectArray = new Object[]{c2.toString()};
        String string2 = MessageFormat.format(this.rb.getString(string), objectArray);
        return string2;
    }

    private String simple_msg(String string, int n) {
        Integer n2 = new Integer(n);
        Object[] objectArray = new Object[]{n2.toString()};
        String string2 = MessageFormat.format(this.rb.getString(string), objectArray);
        return string2;
    }

    private void usage() {
        System.err.print(this.rb.getString("Errors.CommandLine.Usage") + "\n\n");
    }

    private void enable_hotkey_detection(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("Shift")) {
                bl = true;
                continue;
            }
            if (string3.equals("Ctrl")) {
                bl2 = true;
                continue;
            }
            if (string3.equals("Alt")) {
                bl3 = true;
                continue;
            }
            if (string3.equals("Meta")) {
                bl4 = true;
                continue;
            }
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            System.err.println(this.rb.getString("Errors.HotKey.MultipleKeys") + "\n");
        }
        HotKeyThread hotKeyThread = new HotKeyThread(string2, bl, bl2, bl3, bl4);
        hotKeyThread.start();
    }

    public void toggle_visibility() {
        Debug.printme("XXX visibility toggled\n");
        if (this.exit_on_hotkey_mode) {
            System.exit(0);
        }
        if (this.isVisible()) {
            this.setVisible(false);
            this.devctl.poll_pause();
        } else {
            this.setVisible(true);
            this.devctl.poll_continue();
        }
    }

    public void post_error(String string) {
        if (this.error_dialog == null) {
            this.error_dialog = new CDialog((Frame)this, this.rb.getString("GUI.ErrorDialog.OK"), this.rb.getString("GUI.ErrorDialog.Cancel"));
            this.error_dialog.set_title(this.rb.getString("GUI.ErrorDialog.Title"));
        }
        this.error_dialog.setVisible(false);
        this.error_dialog.set_message_text(this.rb.getString(string), false);
        this.error_dialog.setVisible(true);
    }

    public void unpost_all_errors() {
        if (this.error_dialog != null && this.error_dialog.isVisible()) {
            this.error_dialog.setVisible(false);
        }
    }

    public void set_visible(boolean bl) {
        if (bl) {
            this.devctl.poll_continue();
        } else {
            this.devctl.poll_pause();
        }
        super.setVisible(bl);
    }

    private void gb_add(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        if (n6 > 0 || n7 > 0 || n8 > 0 || n9 > 0) {
            gridBagConstraints.insets = new Insets(n6, n7, n8, n9);
        }
        gridBagConstraints.fill = n10;
        gridBagConstraints.weightx = n11;
        gridBagConstraints.weighty = n12;
        if (component == this.cardholder) {
            gridBagConstraints.ipadx = 20;
        }
        container.add(component, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        Font font = this.vol_display.getFont();
        if (font == null) {
            Debug.printme("addNotify(): ERROR - couldn't get font");
            return;
        }
        FontMetrics fontMetrics = this.vol_display.getFontMetrics(font);
        if (fontMetrics == null) {
            Debug.printme("addNotify(): ERROR - couldn't get font metrics");
            return;
        }
        int n = fontMetrics.getMaxAdvance();
        Debug.printme("max advance is " + n);
        this.mic_gain_display.set_preferred_size_overrides(n * 2, -1);
        this.line_gain_left_display.set_preferred_size_overrides(n * 2, -1);
        this.line_gain_right_display.set_preferred_size_overrides(n * 2, -1);
        this.mon_vol_display.set_preferred_size_overrides(n * 2, -1);
        this.vol_display.set_preferred_size_overrides(n * 3, -1);
        this.balance_display.set_preferred_size_overrides(n * 3, -1);
        this.treble_display.set_preferred_size_overrides(n * 3, -1);
        this.bass_display.set_preferred_size_overrides(n * 3, -1);
        this.brightness_display.set_preferred_size_overrides(n * 3, -1);
        this.contrast_display.set_preferred_size_overrides(n * 3, -1);
        this.color_display.set_preferred_size_overrides(n * 3, -1);
        this.tint_display.set_preferred_size_overrides(n * 3, -1);
        this.filter_display.set_preferred_size_overrides(n * 3, -1);
    }

    private int component_to_setting_index(Component component) {
        for (int i = 0; i < 24; ++i) {
            if (this.control[i] == null) continue;
            String string = this.control[i].getClass().getName();
            if (!string.equals("CheckboxHolder")) {
                if (component != this.control[i]) continue;
                return i;
            }
            CheckboxHolder checkboxHolder = (CheckboxHolder)this.control[i];
            for (int j = 0; j < checkboxHolder.get_num_checkboxes(); ++j) {
                if (component != checkboxHolder.get_checkbox(j)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean set_control_value(int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int[] nArray = new int[]{0, 1, 5, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 11, 3, 6, 2, 4, 7, 21, 23, 24, 26, 27, 28, 29, 30, 22, 19, 20, 25};
        if (n >= this.control.length) {
            System.err.println("Unrecognised device parameter index (" + n + ") ignored");
            return false;
        }
        if (this.control[n] == null) {
            return false;
        }
        Debug.printme("+++++ in SettingsGUI::set_control_value (" + n + ", " + n2 + ")");
        String string = this.control[n].getClass().getName();
        if (string.equals("CScrollbar")) {
            Debug.printme("about to call setValue (" + n2 + ")");
            ((CScrollbar)this.control[n]).setValue(n2);
        } else if (string.equals("java.awt.Checkbox")) {
            if (n2 == 0) {
                ((Checkbox)this.control[n]).setState(false);
            } else {
                if (n2 != 1) return false;
                ((Checkbox)this.control[n]).setState(true);
            }
        } else if (string.equals("CheckboxHolder")) {
            if (n == 9) {
                boolean[] blArray = new boolean[3];
                CheckboxHolder checkboxHolder = (CheckboxHolder)this.control[n];
                if ((n2 & 0x8000) != 0) {
                    n2 &= Short.MAX_VALUE;
                    bl4 = true;
                }
                if (n2 == 0) {
                    Debug.printme("set checkboxes case 1\n");
                    blArray[0] = true;
                    if (bl4) {
                        blArray[1] = false;
                        blArray[2] = true;
                    } else {
                        blArray[1] = true;
                        blArray[2] = false;
                    }
                } else {
                    Debug.printme("set checkboxes case 2\n");
                    blArray[0] = false;
                    blArray[1] = n2 == 1 || n2 == 3;
                    blArray[2] = n2 == 2 || n2 == 3;
                }
                Debug.printme("cbvalue[0] = " + blArray[0]);
                Debug.printme("cbvalue[1] = " + blArray[1]);
                Debug.printme("cbvalue[2] = " + blArray[2]);
                checkboxHolder.set_checkbox_state(0, blArray[0]);
                checkboxHolder.set_checkbox_state(1, blArray[1]);
                checkboxHolder.set_checkbox_state(2, blArray[2]);
                if (blArray[0]) {
                    checkboxHolder.get_checkbox(1).setEnabled(false);
                    checkboxHolder.get_checkbox(2).setEnabled(false);
                } else {
                    checkboxHolder.get_checkbox(1).setEnabled(true);
                    checkboxHolder.get_checkbox(2).setEnabled(true);
                }
            } else {
                ((CheckboxHolder)this.control[n]).set_checkbox_state(n2, true);
            }
        } else if (string.equals("java.awt.TextField")) {
            ((TextField)this.control[n]).setText(Integer.toString(n2));
        } else {
            if (!string.equals("java.awt.Choice")) return false;
            if (n == 14) {
                if (n2 >= nArray.length) {
                    System.err.println("Unrecognised timing index (" + n2 + ") ignored");
                    return false;
                }
                n2 = nArray[n2];
            }
            ((Choice)this.control[n]).select(n2);
        }
        if (this.display[n] == null) return true;
        String string2 = this.get_display_value(n, n2);
        ((Label)this.display[n]).setText(string2);
        return true;
    }

    public int get_control_value(int n) {
        int n2;
        int[] nArray = new int[]{0, 1, 16, 14, 17, 2, 15, 18, 3, 4, 5, 13, 6, 7, 8, 9, 10, 11, 12, 28, 29, 19, 27, 20, 21, 30, 22, 23, 24, 25, 26};
        if (this.control[n] == null) {
            return -1;
        }
        String string = this.control[n].getClass().getName();
        if (string.equals("CScrollbar")) {
            n2 = ((CScrollbar)this.control[n]).getValue();
        } else if (string.equals("java.awt.Checkbox")) {
            n2 = ((Checkbox)this.control[n]).getState() ? 1 : 0;
        } else if (string.equals("CheckboxHolder")) {
            if (n == 9) {
                CheckboxHolder checkboxHolder = (CheckboxHolder)this.control[n];
                int n3 = checkboxHolder.get_all_checkbox_values(true);
                switch (n3) {
                    case 1: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 1;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                        break;
                    }
                    case 5: {
                        n2 = 32768;
                        break;
                    }
                    case 6: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 = 0;
                        break;
                    }
                }
            } else {
                n2 = ((CheckboxHolder)this.control[n]).get_selected_checkbox();
            }
        } else if (string.equals("java.awt.TextField")) {
            String string2 = ((TextField)this.control[n]).getText();
            try {
                n2 = Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        } else if (string.equals("java.awt.Choice")) {
            n2 = ((Choice)this.control[n]).getSelectedIndex();
            if (n == 14) {
                n2 = nArray[n2];
            }
        } else {
            return -1;
        }
        return n2;
    }

    public void set_control_state(int n, boolean bl) {
        Debug.printme("%%% in set_control_state (" + n + ", " + bl + ")");
        if (this.control[n] == null) {
            return;
        }
        this.control[n].setEnabled(bl);
    }

    public String get_display_value(int n, int n2) {
        String string;
        switch (n) {
            case 6: {
                if (n2 == 32) {
                    string = "0";
                    break;
                }
                if (n2 < 32) {
                    string = "< " + (32 - n2);
                    break;
                }
                string = "> " + (n2 - 32);
                break;
            }
            case 7: 
            case 8: {
                if (n2 == 6) {
                    string = "0";
                    break;
                }
                if (n2 < 6) {
                    string = "-" + (6 - n2);
                    break;
                }
                string = "+" + (n2 - 6);
                break;
            }
            default: {
                string = Integer.toString(n2);
            }
        }
        return string;
    }

    boolean canPersist(Token token) {
        boolean bl = false;
        if (Boolean.getBoolean("SUN_SUNRAY_DATASTORE")) {
            bl = token.isPersonal();
        }
        return bl;
    }

    String persist(boolean bl, String string, String string2, String string3) {
        String string4;
        Process process;
        SessionCred sessionCred;
        String string5 = null;
        try {
            sessionCred = new SessionCred();
        }
        catch (InvalidSessionException invalidSessionException) {
            String string6 = invalidSessionException.getMessage();
            System.err.println(string6);
            Log.unexpectedError((String)string6);
            return "Errors.Preferences.NotInSession";
        }
        try {
            process = Runtime.getRuntime().exec("/opt/SUNWut/lib/utprefs-helper resolution" + (bl ? "" : " -s") + " -t " + string + " -c " + string2 + " " + string3);
        }
        catch (IOException iOException) {
            String string7 = iOException.getMessage();
            System.err.println(string7);
            Log.unexpectedError((String)string7);
            return "Errors.Preferences.HelperExecFailed";
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(process.getOutputStream());
        String string8 = sessionCred.getCred() + System.getProperty("line.separator");
        byte[] byArray = string8.getBytes();
        try {
            bufferedOutputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            string4 = iOException.getMessage();
            System.err.println(string4);
            Log.unexpectedError((String)string4);
            string5 = "Errors.Preferences.HelperPipeFailed";
        }
        try {
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            string4 = iOException.getMessage();
            System.err.println(string4);
            Log.unexpectedError((String)string4);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while (true) {
            try {
                String string9;
                while ((string9 = bufferedReader.readLine()) != null) {
                    System.err.println(string9);
                    Log.unexpectedError((String)string9);
                }
            }
            catch (IOException iOException) {
                string4 = iOException.getMessage();
                System.err.println(string4);
                Log.unexpectedError((String)string4);
                continue;
            }
            break;
        }
        while (true) {
            try {
                if (process.waitFor() == 0) break;
                string5 = "Errors.Preferences.HelperFailed";
            }
            catch (InterruptedException interruptedException) {
                string4 = interruptedException.getMessage();
                System.err.println(string4);
                Log.unexpectedError((String)string4);
                continue;
            }
            break;
        }
        return string5;
    }

    public static void printThreadInfo(String string) {
        int n = SettingsGUI.getPID();
        int n2 = SettingsGUI.getTID();
        int n3 = SettingsGUI.getLWPID();
        Debug.printfile(string + ": pid = " + n + ", tid = " + n2 + ", lwpid = " + n3 + "\n");
    }

    public void printDebugInfo() {
        System.out.println("----------------------------------------------");
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        ThreadGroup threadGroup2 = threadGroup.getParent();
        if (threadGroup2 == null) {
            threadGroup.list();
        } else {
            threadGroup2.list();
        }
        System.out.println(" ");
        Thread[] threadArray = new Thread[30];
        threadGroup2.enumerate(threadArray);
        for (int i = 0; i < threadArray.length; ++i) {
            if (threadArray[i] == null) continue;
            System.out.println(i + ": " + threadArray[i].toString());
        }
        System.out.println("----------------------------------------------");
    }

    static {
        System.loadLibrary("hotkey");
    }

    class HotKeyThread
    extends Thread {
        String key_string;
        boolean shift_key;
        boolean ctrl_key;
        boolean alt_key;
        boolean meta_key;

        public HotKeyThread(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.key_string = string;
            this.shift_key = bl;
            this.ctrl_key = bl2;
            this.alt_key = bl3;
            this.meta_key = bl4;
        }

        public void run() {
            Thread thread = Thread.currentThread();
            thread.setName("HotKey");
            int n = SettingsGUI.this.watchForHotKeys(this.key_string, this.shift_key, this.ctrl_key, this.alt_key, this.meta_key);
            if (n != 0) {
                System.err.println(SettingsGUI.this.rb.getString("Errors.HotKey.Exiting") + "\n");
                System.exit(1);
            }
        }
    }

    class TimeoutThread
    extends Thread {
        boolean armed = true;
        int duration;
        CDialog dialog;
        Object armedLock = new Object();

        private TimeoutThread() {
        }

        protected TimeoutThread(CDialog cDialog, int n) {
            this.dialog = cDialog;
            this.duration = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void disarm() {
            Object object = this.armedLock;
            synchronized (object) {
                this.armed = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread thread = Thread.currentThread();
            thread.setName("TimeoutThread");
            Debug.printme("in TimeoutThread::run");
            try {
                Debug.printme("before sleep");
                TimeoutThread.sleep(this.duration * 1000);
                Debug.printme("after sleep");
                Object object = this.armedLock;
                synchronized (object) {
                    if (this.armed && this.dialog.isVisible()) {
                        Debug.printme("dialog still visible after timeout - closing now.");
                        this.dialog.setVisible(false);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                System.err.println(interruptedException);
            }
        }
    }

    class ItemL
    implements ItemListener {
        private boolean conductingResDialog = false;

        ItemL() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == SettingsGUI.this.choice1) {
                String string = SettingsGUI.this.choice1.getSelectedItem();
                SettingsGUI.this.card_label.setText("  " + string.toUpperCase());
                ((CardLayout)SettingsGUI.this.cardholder.getLayout()).show(SettingsGUI.this.cardholder, string);
            } else {
                Object object2;
                int n = SettingsGUI.this.component_to_setting_index((Component)object);
                if (n == -1) {
                    Debug.printme("itemStateChanged(): ERROR - unknown component");
                    return;
                }
                Debug.printme("gui component " + n + " got changed");
                int n2 = SettingsGUI.this.get_control_value(n);
                int n3 = SettingsGUI.this.devctl.get_newt_value(n);
                if ((n3 & 0x8000) != 0 && (n2 & 0x8000) == 0) {
                    Debug.printme("new_value was " + n2);
                    n2 = (short)(n2 | 0x8000);
                    Debug.printme("new_value adjusted is " + n2);
                }
                Debug.printme("new_value = " + n2 + ", last_value = " + n3);
                if (n2 == n3) {
                    return;
                }
                if (n == 9) {
                    object2 = (CheckboxHolder)SettingsGUI.this.control[n];
                    int bl = ((CheckboxHolder)object2).get_all_checkbox_values(true);
                    Debug.printme("output sel value is " + bl);
                    if (bl == 0) {
                        Checkbox string4 = (Checkbox)object;
                        Debug.printme("force checkbox back on");
                        string4.setState(true);
                        return;
                    }
                    if (((CheckboxHolder)object2).get_checkbox_state(0)) {
                        ((CheckboxHolder)object2).get_checkbox(1).setEnabled(false);
                        ((CheckboxHolder)object2).get_checkbox(2).setEnabled(false);
                    } else {
                        ((CheckboxHolder)object2).get_checkbox(1).setEnabled(true);
                        ((CheckboxHolder)object2).get_checkbox(2).setEnabled(true);
                    }
                    if (((CheckboxHolder)object2).get_checkbox_state(0)) {
                        Debug.printme("just got turned to auto\n");
                        if ((n2 & 0x8000) != 0) {
                            Debug.printme("got high order bit\n");
                            ((CheckboxHolder)object2).set_checkbox_state(1, false);
                            ((CheckboxHolder)object2).set_checkbox_state(2, true);
                        } else {
                            Debug.printme("not high order bit\n");
                            ((CheckboxHolder)object2).set_checkbox_state(1, true);
                            ((CheckboxHolder)object2).set_checkbox_state(2, false);
                        }
                    }
                }
                if (n == 14) {
                    if (this.conductingResDialog) {
                        return;
                    }
                    this.conductingResDialog = true;
                    String string = SettingsGUI.this.simple_msg("GUI.Display.ResRefresh.Confirm.Message1", 10);
                    SettingsGUI.this.conf_dialog.set_message_text(string, true);
                    SettingsGUI.this.conf_dialog.setVisible(true);
                    int n4 = SettingsGUI.this.conf_dialog.get_answer();
                    if (n4 == 0) {
                        SettingsGUI.this.set_control_value(n, n3);
                        this.conductingResDialog = false;
                        return;
                    }
                    SettingsGUI.this.conf_dialog.setVisible(false);
                    SettingsGUI.this.devctl.gui_control_changed(n, n2);
                    SettingsGUI.this.conf_dialog.set_message_text(SettingsGUI.this.rb.getString("GUI.Display.ResRefresh.Confirm.Message2"), true);
                    object2 = new TimeoutThread(SettingsGUI.this.conf_dialog, 10);
                    ((Thread)object2).start();
                    SettingsGUI.this.conf_dialog.setVisible(true);
                    ((TimeoutThread)object2).disarm();
                    n4 = SettingsGUI.this.conf_dialog.get_answer();
                    if (n4 == 0 || n4 == -1) {
                        SettingsGUI.this.conf_dialog.setVisible(false);
                        SettingsGUI.this.set_control_value(n, n3);
                        SettingsGUI.this.devctl.gui_control_changed(n, n3);
                        SettingsGUI.this.conf_dialog.set_message_text(SettingsGUI.this.rb.getString("GUI.Display.ResRefresh.Confirm.Message3"), false);
                        SettingsGUI.this.conf_dialog.setVisible(true);
                    } else {
                        try {
                            String string2;
                            boolean bl;
                            String string3;
                            boolean invalidSessionException = false;
                            Token token = new Token();
                            if (SettingsGUI.this.canPersist(token)) {
                                string3 = SettingsGUI.this.rb.getString("GUI.Display.ResRefresh.Confirm.Save");
                                SettingsGUI.this.conf_dialog.set_message_text(string3, true);
                                SettingsGUI.this.conf_dialog.setVisible(true);
                                n4 = SettingsGUI.this.conf_dialog.get_answer();
                                if (n4 == 1) {
                                    bl = true;
                                }
                            }
                            if ((string2 = token.getCID()) != null && (string3 = SettingsGUI.this.persist(bl, token.getName(), string2, this.getResNameForIndex(n2))) != null) {
                                SettingsGUI.this.post_error(string3);
                            }
                        }
                        catch (InvalidSessionException invalidSessionException) {
                            String string4 = invalidSessionException.getMessage();
                            System.err.println(string4);
                            Log.unexpectedError((String)string4);
                        }
                    }
                    this.conductingResDialog = false;
                } else {
                    if (SettingsGUI.this.display[n] != null) {
                        String string = SettingsGUI.this.get_display_value(n, n2);
                        ((Label)SettingsGUI.this.display[n]).setText(string);
                    }
                    SettingsGUI.this.devctl.gui_control_changed(n, n2);
                }
            }
        }

        String getResNameForIndex(int n) {
            String[] stringArray = new String[]{"standard", "monitor", "640x480@85", "800x600@85", "1024x768@60", "1024x768@75", "1152x900@66", "1152x900@76", "1280x1024@60", "1280x1024@66", "1280x1024@75", "1280x1024@76", "1280x1024@85", "1024x768@85", "640x480@60", "800x600@60", "custom", "640x480@75", "800x600@75", "1600x1024@60", "1600x1200@60d", "1600x1200@75", "1920x1080@60d", "1920x1080@70", "1920x1080@72", "1920x1200@60d", "1920x1200@70", "1600x1200@60", "1400x1050@60", "1440x900@60", "1680x1050@60"};
            return stringArray[n];
        }
    }

    class ActionL
    implements ActionListener {
        ActionL() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SettingsGUI.this.test_set_button) {
                SettingsGUI.this.devctl.dump_a_rama(-1);
            } else if (object == SettingsGUI.this.test_get_button) {
                int n = Integer.decode(SettingsGUI.this.test_index_tf.getText());
                int n2 = SettingsGUI.this.get_control_value(n);
                Debug.printme("index " + n + ", value " + n2);
            } else {
                int n = SettingsGUI.this.component_to_setting_index((Component)object);
                if (n == -1) {
                    Debug.printme("actionPerformed(): ERROR - unknown component");
                    return;
                }
                int n3 = SettingsGUI.this.get_control_value(n);
                Debug.printme("+++++ in SettingsGUI::actionPerformed() - setting " + n + " changed to " + n3);
                SettingsGUI.this.devctl.gui_control_changed(n, n3);
            }
        }
    }

    class AdjustmentL
    implements AdjustmentListener {
        AdjustmentL() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Object object = adjustmentEvent.getSource();
            boolean bl = false;
            boolean bl2 = false;
            Debug.printme("event is " + adjustmentEvent);
            int n = SettingsGUI.this.component_to_setting_index((Component)object);
            if (n == -1) {
                Debug.printme("adjustmentValueChanged(): ERROR - unknown component");
                return;
            }
            int n2 = SettingsGUI.this.get_control_value(n);
            Debug.printme("+++++ in SettingsGUI::adjustmentValueChanged() - setting " + n + " changed to " + n2);
            if (SettingsGUI.this.display[n] != null) {
                Debug.printme("XXX 1");
                String string = SettingsGUI.this.get_display_value(n, n2);
                Debug.printme("XXX 2");
                ((Label)SettingsGUI.this.display[n]).setText(string);
            }
            Debug.printme("XXX 3");
            SettingsGUI.this.devctl.gui_control_changed(n, n2);
        }
    }

    class WindowA
    extends WindowAdapter {
        WindowA() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == SettingsGUI.this) {
                if (SettingsGUI.this.hotkey_mode && !SettingsGUI.this.exit_on_hotkey_mode) {
                    SettingsGUI.this.set_visible(false);
                    return;
                }
                SettingsGUI.this.setVisible(false);
                SettingsGUI.this.dispose();
                System.exit(0);
            }
        }

        public void windowIconified(WindowEvent windowEvent) {
            Debug.printme("XXX window iconified\n");
            Object object = windowEvent.getSource();
            if (object == SettingsGUI.this) {
                SettingsGUI.this.devctl.poll_pause();
            }
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            Debug.printme("XXX window de-iconified\n");
            Object object = windowEvent.getSource();
            if (object == SettingsGUI.this) {
                SettingsGUI.this.devctl.poll_continue();
            }
        }
    }
}

