/*
 * Decompiled with CFR 0.152.
 */
package auth.utguiauth;

import auth.utguiauth.AbstractPamAuthCallback;
import auth.utguiauth.DataMessage;
import auth.utguiauth.DisconnectMessage;
import auth.utguiauth.OKMessage;
import auth.utguiauth.PamDialogError;
import auth.utguiauth.PamDone;
import auth.utguiauth.UTguiauthMessage;
import com.sun.ut.utils.ByteUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;

class UTguiauthMessageFactory {
    UTguiauthMessageFactory() {
    }

    /*
     * WARNING - void declaration
     */
    UTguiauthMessage createMessage(BufferedInputStream input, BufferedOutputStream output, AbstractPamAuthCallback pamAuthCallback) throws PamDone {
        void var10_10;
        UTguiauthMessage message;
        short len = this.getLen(input);
        String payload = this.getPayload(input, len);
        String[] headerAndDataFields = payload.split("\u0000");
        String[] headerFields = headerAndDataFields[0].split(" ");
        String type = headerFields[0];
        String data = headerAndDataFields.length == 2 ? headerAndDataFields[1] : null;
        if (type.equals("OK")) {
            message = new OKMessage();
        } else if (type.equals("DISCONNECT")) {
            message = new DisconnectMessage();
        } else if (type.equals("DATA")) {
            message = new DataMessage();
        } else {
            throw new PamDialogError("unknown message type " + type);
        }
        return var10_10.init(data, output, pamAuthCallback);
    }

    private short getLen(BufferedInputStream input) throws PamDialogError {
        int rlen;
        byte[] lenb = new byte[2];
        try {
            rlen = input.read(lenb, 0, lenb.length);
        }
        catch (IOException ioex) {
            throw new PamDialogError("read IOException: " + ioex);
        }
        if (rlen < 0) {
            throw new PamDialogError("pipe closed");
        }
        return ByteUtils.toShort((byte[])lenb);
    }

    private String getPayload(BufferedInputStream input, short len) throws PamDialogError {
        int rlen;
        byte[] inbuf = new byte[len];
        try {
            rlen = input.read(inbuf, 0, inbuf.length);
        }
        catch (IOException ioex) {
            throw new PamDialogError("read IOException: " + ioex);
        }
        if (rlen < 0) {
            throw new PamDialogError("pipe closed");
        }
        return new String(inbuf);
    }
}

