/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Checkbox;
import com.sun.web.ui.component.CheckboxGroup;
import com.sun.web.ui.model.Option;
import com.sun.web.ui.renderer.SelectorGroupRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class CheckboxGroupRenderer
extends SelectorGroupRenderer {
    private final String MSG_COMPONENT_NOT_CHECKBOXGROUP = "CheckboxGroupRenderer only renders CheckboxGroup components.";
    protected String[] styles = new String[]{"CHECKBOX_GROUP", "CHECKBOX_GROUP_CAPTION", "CHECKBOX_GROUP_LABEL", "CHECKBOX_GROUP_LABEL_DISABLED", "CHECKBOX_GROUP_ROW_EVEN", "CHECKBOX_GROUP_ROW_ODD", "CHECKBOX_GROUP_CELL_EVEN", "CHECKBOX_GROUP_CELL_ODD", "CHECKBOX", "CHECKBOX_DISABLED", "CHECKBOX_LABEL", "CHECKBOX_LABEL_DISABLED", "CHECKBOX_IMAGE", "CHECKBOX_IMAGE_DISABLED", "LABEL_LEVEL_ONE_TEXT", "LABEL_LEVEL_TWO_TEXT", "LABEL_LEVEL_THREE_TEXT"};

    public void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!(component instanceof CheckboxGroup)) {
            throw new IllegalArgumentException("CheckboxGroupRenderer only renders CheckboxGroup components.");
        }
    }

    public void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        CheckboxGroup cbgrp = (CheckboxGroup)component;
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderSelectorGroup(context, component, theme, writer, cbgrp.getColumns());
    }

    protected UIComponent getSelectorComponent(FacesContext context, UIComponent component, Theme theme, String id, Option option) {
        Checkbox cb;
        block3: {
            String[] subValue;
            block2: {
                CheckboxGroup cbgrp = (CheckboxGroup)component;
                cb = new Checkbox();
                cb.setId(id);
                cb.setParent((UIComponent)cbgrp);
                cb.setName(cbgrp.getClientId(context));
                cb.setToolTip(option.getTooltip());
                cb.setImageURL(option.getImage());
                cb.setSelectedValue(option.getValue());
                cb.setLabel(option.getLabel());
                boolean cbgrpDisabled = cbgrp.isDisabled();
                cb.setDisabled(cbgrpDisabled ? cbgrpDisabled : option.isDisabled());
                cb.setReadOnly(cbgrp.isReadOnly());
                cb.setTabIndex(cbgrp.getTabIndex());
                this.transferEventAttributes(cbgrp, cb);
                cb.setSelected(null);
                subValue = (String[])cbgrp.getSubmittedValue();
                if (subValue != null) break block2;
                if (!this.isSelected(option, cbgrp.getSelected())) break block3;
                cb.setSelected(cb.getSelectedValue());
                break block3;
            }
            if (subValue.length != 0) {
                Object selectedValue = cb.getSelectedValue();
                String selectedValueAsString = ConversionUtilities.convertValueToString(component, selectedValue);
                for (int i = 0; i < subValue.length; ++i) {
                    if (subValue[i] == null || !subValue[i].equals(selectedValueAsString)) continue;
                    cb.setSelected(selectedValue);
                    break;
                }
            }
        }
        return cb;
    }

    private boolean isSelected(Option item, Object currentValue) {
        Object value = item.getValue();
        if (value == null || currentValue == null) {
            return false;
        }
        if (currentValue instanceof Map) {
            return ((Map)currentValue).containsValue(value);
        }
        if (currentValue instanceof Collection) {
            return ((Collection)currentValue).contains(value);
        }
        if (currentValue instanceof Object[]) {
            Object[] selectedValues = (Object[])currentValue;
            for (int i = 0; i < selectedValues.length; ++i) {
                if (!value.equals(selectedValues[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected String[] getStyles() {
        return this.styles;
    }
}

