<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/Kiosk.js"/>
                    <f:verbatim>
                        <style type="text/css">
                            .RbGrp label {vertical-align: -2px;}
                        </style>
                    </f:verbatim>
                </ui:head>    
                <ui:body focus="f1:t1:a1:s1:p1:i1"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="kiosk"/>
                        <ui:alert binding ="#{kioskHandler.statusMessage.alert}"/>
            
                        <ui:contentPageTitle id="t1" title="#{msg.kiosk_pageTitle} - #{msg.kiosk_new_application}">
                            <f:verbatim><br/></f:verbatim>
                            <ui:propertySheet id="a1" jumpLinks="false">
                                <ui:propertySheetSection id="s1">
                                    <ui:property id="p1" label="#{msg.kiosk_applicationLabel}" labelAlign="right">
                                    <ui:markup tag="table" extraAttributes="cellpadding='1'">
                                        <ui:markup tag="tr">
                                            <ui:markup tag="td" extraAttributes="valign='center'">
                                                <ui:radioButton id="i1_editable" name="rbgroup" label="#{msg.kiosk_predefinedLabel}" selected="#{kioskHandler.predefined}"
                                                    onClick="disableElements()"
                                                    toolTip="#{msg.kiosk_predefinedLabel_tooltip}"/>
                                            </ui:markup>
                                            <ui:markup tag="td" extraAttributes="valign='center'">
                                                <ui:dropDown id="i2_editable" items="#{kioskHandler.applicationOptions}" selected="#{kioskHandler.application}"
                                                    toolTip="#{msg.kiosk_applicationOptions_tooltip}"/>
                                            </ui:markup>
                                        </ui:markup>
                                        <ui:markup tag="tr">
                                            <ui:markup tag="td" extraAttributes="valign='center'">
                                                <ui:radioButton id="i3_editable" name="rbgroup" label="#{msg.kiosk_customLabel}" selected="#{kioskHandler.custom}"
                                                    onClick="disableElements()"
                                                    toolTip="#{msg.kiosk_customLabel_tooltip}"/>
                                            </ui:markup>
                                            <ui:markup tag="td" extraAttributes="valign='center'">
                                                <ui:textField id="i4_editable" text="#{kioskHandler.path}" columns="32"
                                                    toolTip="#{msg.kiosk_path_tooltip}"/>
                                                <ui:staticText text="&#160;" escape="false"/>                                         
                                                <ui:button id="i5"
                                                           text="#{msg.kiosk_button_browse}"
                                                           onClick="javascript:var win = window.open('../advanced/KioskBrowseServer.jsp','kioskBrowseServerWindow','height=600,width=600,top='+((screen.height-(screen.height/1.618))-(500/2))+',left='+((screen.width-650)/2)+',scrollbars,resizable');win.focus(); return false;"/>
                                            </ui:markup>
                                        </ui:markup>
                                    </ui:markup>
                                    </ui:property>
                                    <ui:property id="p2" label="#{msg.kiosk_typeLabel}" labelAlign="right">
                                        <ui:radioButtonGroup id="i1_editable"
                                            items="#{kioskHandler.typeOptions}"
                                            columns="1"
                                            selected="#{kioskHandler.type}"
                                            onClick="disableElements()"
                                            toolTip="#{msg.kiosk_typeOptions_tooltip}"/>
                                        <ui:staticText text="&#160;&#160;&#160;" escape="false"/>
                                        <ui:staticText id="i2" text="#{msg.kiosk_typeHelp}" style="color:#999; font-size:11px;"/> 
                                    </ui:property>
                                    <ui:property id="p3" label="#{msg.kiosk_modeLabel}" labelAlign="right">
                                        <ui:radioButtonGroup id="i1_editable"
                                            items="#{kioskHandler.modeOptions}"
                                            columns="1"
                                            selected="#{kioskHandler.mode}"
                                            toolTip="#{msg.kiosk_modeOptions_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p4" label="#{msg.kiosk_argsLabel}" labelAlign="right">
                                        <ui:textField id="i1_editable" text="#{kioskHandler.args}" columns="64"
                                            toolTip="#{msg.kiosk_args_tooltip}"/>
                                    </ui:property>
                                </ui:propertySheetSection>
                            </ui:propertySheet>
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup> 
                                    <ui:button id="ok"
                                               text="#{msg.ok_button}"
                                               primary="true"
                                               action="#{kioskHandler.addApplication}"
                                               toolTip="#{msg.kiosk_edit_ok_tooltip}"
                                               alt="#{msg.ok_button_alt}"/>
                                    <ui:button id="cancel"
                                               text="#{msg.cancel_button}"
                                               action="kiosk"
                                               immediate="true"
                                               toolTip="#{msg.kiosk_edit_cancel_tooltip}"
                                               alt="#{msg.cancel_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                        </ui:contentPageTitle> 
                        <ui:script>
                            <f:verbatim>
                                disableElements();
                            </f:verbatim>
                        </ui:script>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 

