<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                </ui:head>    
                <ui:body focus="f1:p1:t1:actionsTop:edit"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="probe"/>
                        <ui:alert binding ="#{smartCardHandler.statusMessage.alert}"/>

                        <ui:contentPageTitle id="p1" 
                                             title="#{msg.probe_pageTitle}">

                            <ui:markup tag="div" styleClass="TtlHlpDiv">
                                <ui:helpInline id="h1" type="page"
                                               text="#{msg.probe_pageHelpText}">
                                    <ui:helpWindow windowTitle="#{msg.helpWindow_title}" 
                                                   pageTitle="#{msg.helpWindow_pageTitle}"
                                                   mastheadImageUrl="/images/productName.png"
                                                   mastheadImageHeight="40"
                                                   mastheadImageWidth="204"   
                                                   helpFile="probeorder.html"
                                                   toolTip="#{msg.helpWindow_link_tooltip}"
                                                   linkIcon="true" linkText="#{msg.probe_help_link}" />
                                </ui:helpInline>
                            </ui:markup> 
                            
                            <f:facet name="pageButtonsTop">
                                <ui:panelGroup> 
                                    <ui:button id="edit" 
                                               immediate="true"
                                               disabled="false" 
                                               text="#{msg.probe_table_edit_button}" 
                                               action="editProbeOrder"
                                               toolTip="#{msg.probe_table_edit_button_tooltip}"
                                               alt="#{msg.edit_button_alt}"/>
                                    <f:verbatim><br/></f:verbatim>
                                </ui:panelGroup> 
                            </f:facet> 
                           <f:facet name="pageButtonsBottom">
                                <ui:panelGroup> 
                                    <ui:button id="edit" 
                                               immediate="true"
                                               disabled="false" 
                                               text="#{msg.probe_table_edit_button}" 
                                               action="editProbeOrder"
                                               toolTip="#{msg.probe_table_edit_button_tooltip}"
                                               alt="#{msg.edit_button_alt}"/>
                                       <f:verbatim><br/></f:verbatim>
                                       <f:verbatim><br/></f:verbatim>
                                </ui:panelGroup> 
                            </f:facet> 
                            <f:verbatim><br/></f:verbatim>
                            <ui:markup tag="div" styleClass="ConMgn">
                                <ui:table id="t1"
                                    title="#{msg.probe_table_title}"
                                    paginateButton="true"
                                    paginationControls="true"
                                    summary="#{msg.probe_table_summary}"
                                    toolTip="#{msg.probe_table_summary}">
                                    <ui:tableRowGroup sourceData="#{smartCardHandler.registeredSmartCards}"
                                                      rows="20"
                                                      emptyDataMsg="#{msg.probe_table_empty}"
                                                      sourceVar="smartCardRowGroup">
                                        <ui:tableColumn headerText="#{msg.probe_table_name_header}" 
                                                        rowHeader="true">
                                            <ui:staticText text="#{smartCardRowGroup.value.name}"/>
                                        </ui:tableColumn>
                                        <ui:tableColumn headerText="#{msg.probe_table_model_header}"
                                                        rowHeader="true">
                                            <ui:staticText text="#{smartCardRowGroup.value.model}"/>
                                        </ui:tableColumn>
                                        <ui:tableColumn headerText="#{msg.probe_table_description_header}"
                                                        rowHeader="true">
                                            <ui:staticText text="#{smartCardRowGroup.value.description}"/>
                                        </ui:tableColumn>
                                        <ui:tableColumn headerText="#{msg.probe_table_supplier_header}"
                                                        rowHeader="true">
                                            <ui:staticText text="#{smartCardRowGroup.value.supplier}"/>
                                        </ui:tableColumn>
                                        <ui:tableColumn headerText="#{msg.probe_table_version_header}"
                                                        rowHeader="true">
                                            <ui:staticText text="#{smartCardRowGroup.value.version}"/>
                                        </ui:tableColumn>
                                        <ui:tableColumn headerText="#{msg.probe_table_type_header}"
                                                        rowHeader="true">
                                            <ui:staticText text="#{smartCardRowGroup.value.type}"/>
                                        </ui:tableColumn>
                                    </ui:tableRowGroup>
                                </ui:table>
                            </ui:markup>
                        </ui:contentPageTitle>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root>

