<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/DesktopUnit.js"/>
                </ui:head>    
                <ui:body focus="f1:p1:z1"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="dtus"/>
                        <ui:alert binding ="#{dtuList.statusMessage.alert}"/>

                        <ui:contentPageTitle id="p1" 
                                             title="#{msg.dtus_pageTitle}">

                            <ui:markup tag="div" styleClass="TtlHlpDiv">
                                <ui:helpInline id="h1" type="page"
                                               text="#{msg.dtus_pageHelpText}">
                                    <ui:helpWindow windowTitle="#{msg.helpWindow_title}" 
                                                   pageTitle="#{msg.helpWindow_pageTitle}"
                                                   mastheadImageUrl="/images/productName.png"
                                                   mastheadImageHeight="40"
                                                   mastheadImageWidth="204"   
                                                   helpFile="dtus.html"
                                                   toolTip="#{msg.helpWindow_link_tooltip}"
                                                   linkIcon="true" linkText="#{msg.dtus_help_link}" />
                                </ui:helpInline>
                            </ui:markup>                                                 
                                                 
                            <ui:markup tag="div" styleClass="ConMgn">
                                <f:verbatim><br/></f:verbatim>

                                <ui:dropDown id="z1"
                                             items="#{dtuList.searchCriteria.options}" 
                                             selected="#{dtuList.searchCriteria.filter}"
                                             toolTip="#{msg.dtu_searchCriteria_options_tooltip}"/> 
                                <ui:textField id="z2"
                                              text="#{dtuList.searchCriteria.searchString}" 
                                              columns="40"
                                              toolTip="#{msg.dtu_searchCriteria_searchString_tooltip}"/>
                                <ui:staticText text="&#160;" escape="false"/>
                                <ui:button id="search"
                                           text="#{msg.search_button}" 
                                           primary="true"
                                           action="#{dtuList.search}"
                                           toolTip="#{msg.dtu_search_button_tooltip}"
                                           alt="#{msg.search_button_alt}"/>
                                <f:verbatim><br/><br/></f:verbatim>

                                <ui:table id="t1"
                                          title="#{dtuList.title}" 
                                          paginateButton="true"
                                          paginationControls="true"
                                          selectMultipleButton="#{dtuList.selectable}"
                                          selectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          deselectMultipleButton="#{dtuList.selectable}"
                                          deselectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          clearSortButton="true"
                                          summary="#{msg.dtu_table_summary}"
                                          toolTip="#{msg.dtu_table_summary}">

                                    <ui:tableRowGroup sourceData="#{dtuList.dtus}" 
                                                      rows="20"
                                                      sourceVar="dtuRowGroup"
                                                      binding="#{dtuList.tableRowGroup}"
                                                      selected="#{dtuList.selectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select">
                                            <ui:checkbox id="select" 
                                                         onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                         selected="#{dtuList.selectHelper.selected}"
                                                         selectedValue="#{dtuList.selectHelper.selectedValue}"
                                                         toolTip="#{msg.dtu_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>

                                        <!-- Identifier column -->
                                        <ui:tableColumn headerText="#{msg.dtus_table_identifier_header}"
                                                        rowHeader="true"
                                                        sort="id"
                                                        style="width: 12%;">
                                            <ui:hyperlink text="#{dtuRowGroup.value.id}" 
                                                          action="#{dtuList.viewProperties}"
                                                          immediate="true"
                                                          toolTip="#{msg.dtu_table_value_tooltip}">
                                                <f:param name="id" 
                                                         value="#{dtuRowGroup.value.id}"/>
                                            </ui:hyperlink>
                                        </ui:tableColumn>

                                        <!-- Location column -->
                                        <ui:tableColumn headerText="#{msg.dtus_table_location_header}" 
                                                        rowHeader="true" 
                                                        sort="location"
                                                        style="width: 25%;">
                                            <ui:staticText text="#{dtuRowGroup.value.location}"/>
                                        </ui:tableColumn>

                                        <!-- Description column -->
                                        <ui:tableColumn headerText="#{msg.dtus_table_description_header}" 
                                                        sort="description"
                                                        rowHeader="true">
                                            <ui:staticText text="#{dtuRowGroup.value.description}"/>
                                        </ui:tableColumn>


                                    </ui:tableRowGroup>

                                    <!-- Action buttons -->
                                    <f:facet name="actionsTop">
                                        <f:subview id="actionsTop">
                                            <ui:button id="new"
                                                       disabled="false"
                                                       text="#{msg.new_button}"
                                                       action="newDesktopUnit"
                                                       immediate="true"
                                                       toolTip="#{msg.dtu_new_button_tooltip}"
                                                       alt="#{msg.new_button_alt}"/>
                                            <ui:button id="delete"
                                                       disabled="true"
                                                       text="#{msg.delete_button}" 
                                                       action="#{dtuList.delete}"
                                                       onClick="if (confirmDeleteSelectedRows() == false) return false"
                                                       toolTip="#{msg.dtu_delete_button_tooltip}"
                                                       alt="#{msg.delete_button_alt}"/>
                                        </f:subview>
                                    </f:facet>

                                </ui:table>

                            </ui:markup>
                        </ui:contentPageTitle> 
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 


