<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">    
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>                        
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                </ui:head>    
                <ui:body focus="f1:p1:_id19:back"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="servers"/>
                        <ui:alert binding ="#{statusMessage.alert}"/>
        
                        <ui:breadcrumbs>
                            <ui:hyperlink text="#{msg.breadcrump_link_all_servers}"
                                          action="viewServers"
                                          immediate="true"
                                          toolTip="#{msg.dtu_breadcrump_all_servers_tooltip}"/>
                            <ui:hyperlink text="#{packageHandler.serverName}"
                                          action="viewServerDetails"
                                          immediate="true"
                                          toolTip="#{msg.dtu_breadcrump_server_name_tooltip}"/>
                            <ui:hyperlink text="#{msg.breadcrump_link_installed_packages}"
                                          toolTip="#{msg.packages_link_tooltip}"/>
                        </ui:breadcrumbs>

                        <ui:contentPageTitle id="p1" 
                                             title="#{packageHandler.serverName} - #{msg.packages_pageTitle}">
                            <f:facet name="pageButtonsTop">
                                <ui:panelGroup> 
                                    <ui:button id="back"
                                               text="#{packageHandler.backToLabel}"
                                               action="viewServerDetails"
                                               immediate="true"
                                               toolTip="#{msg.dtu_back_to_server_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup>
                                    <ui:button id="back"
                                               text="#{packageHandler.backToLabel}" 
                                               action="viewServerDetails"
                                               immediate="true"
                                               toolTip="#{msg.dtu_back_to_server_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet>

                            <f:verbatim><br/></f:verbatim>
                            <ui:markup tag="div" styleClass="ConMgn">

                                <ui:table id="t1"
                                          title="#{msg.packages_table_title}"
                                          paginateButton="true"
                                          paginationControls="true"
                                          clearSortButton="true"
                                          summary="#{msg.packages_table_summary}"
                                          toolTip="#{msg.packages_table_tooltip}">

                                    <ui:tableRowGroup sourceData="#{packageHandler.packages}"
                                                      binding="#{packageHandler.tableRowGroup}"
                                                      sourceVar="packageRowGroup">

                                        <!-- Name column -->
                                        <ui:tableColumn headerText="#{msg.packages_table_name_header}" 
                                                        sort="pkg"
                                                        rowHeader="true">
                                            <ui:staticText text="#{packageRowGroup.value.pkg}"/>
                                        </ui:tableColumn>

                                        <!-- Description -->
                                        <ui:tableColumn headerText="#{msg.packages_table_description_header}" 
                                                        sort="name"
                                                        rowHeader="true">
                                            <ui:staticText text="#{packageRowGroup.value.name}"/>
                                        </ui:tableColumn>

                                        <!-- Version -->
                                        <ui:tableColumn headerText="#{msg.packages_table_version_header}"
                                                        sort="version"
                                                        rowHeader="true">
                                            <ui:staticText text="#{packageRowGroup.value.version}"/>
                                        </ui:tableColumn>

                                        <!-- Time stamp -->
                                        <ui:tableColumn headerText="#{msg.packages_table_pstamp_header}"
                                                        sort="pstamp"
                                                        rowHeader="true">
                                            <ui:staticText text="#{packageRowGroup.value.pstamp}"/>
                                        </ui:tableColumn>

                                    </ui:tableRowGroup>
                                </ui:table>

                            </ui:markup>
                        </ui:contentPageTitle>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 
