#
# ident "@(#)sunray-d.x	1.8 03/03/26 SMI"
#
# Copyright 2000-2003 Sun Microsystems, Inc.  All rights reserved.
#

[ requires package utesa ]
[ use MANAGED-MODULE ]
[ requires template sunray-models-d ]

[ load sunray-m.x ]

_services = { [ use SERVICE ]
	sh = {
		command         = ::shell:pipe:/bin/sh
		max             = 2
	}
}

_rules = { [ use PROC ]
	[ source sunray-d.rul ]
}

    userAccess(%generalUsers,read) = noauth
    groupAccess(%generalGroups,read) = noauth



    srSystem = { [ use templates.sunray-models-d.sunrayMib.srSystem ]
	oid		= 1
	initInterval	= 2
	refreshInterval	= 300

	srSystemHostName = {
		oid		= 1

		type		= active
		refreshMode	= sync
		refreshService  = _services.sh
		refreshCommand  = /bin/uname -n
		refreshInterval	= 0

	}

	srSystemContactName = {
		oid		= 2

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_contact
		refreshInterval	= 0

		access = rw
		setActions	= setName
		setService(setName) = _internal
		setCommand(setName) = utp_setContact %value
	}

	srSystemUpTime = {
		oid		= 3

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_upTime
		refreshInterval	= 300

		alarmRules  = rut2r100
	}

	srSoftwareVersion = {
		oid		= 4

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_version
		refreshInterval	= 0
	}

	srSystemInstallDate = {
		oid		= 5

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_installed
		refreshInterval	= 0
	}

	srPatchInfo = {
		oid		= 6

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_patches
		refreshInterval	= 0
	}

	srActiveSessions = {
		oid		= 7
		initInterval	= 4
		refreshInterval	= 300

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_sessions
	}

	srTotalSessions = {
		oid		= 8
		initInterval	= 4
		refreshInterval	= 300

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_totalSessions
	}

	srActiveDesktops = {
		oid		= 9
		initInterval	= 4
		refreshInterval	= 300

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_desktops
	}

	srUsers = {
		oid		= 10
		initInterval	= 4
		refreshInterval	= 300

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_users
	}

	srPolicy = {
		oid		= 11

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_policy
		refreshInterval	= 0
	}

    }

    srServices = { [ use templates.sunray-models-d.sunrayMib.srServices ]
	oid		= 2
	initInterval	= 4
	refreshInterval	= 300

	srServicesTable = {
		oid		= 1
		initInterval	= 4
		refreshInterval	= 300

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_daemons
	}
    }

    srFOGroup = { [ use templates.sunray-models-d.sunrayMib.srFOGroup ]
	oid		= 3
	initInterval	= 4
	refreshInterval	= 300


	srFOGTable = {
		oid		= 1
		initInterval	= 4
		refreshInterval	= 300

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_FOGroup
	}
    }

    srInterconnect = { [ use templates.sunray-models-d.sunrayMib.srInterconnect ]
	oid		= 4
	initInterval	= 4
	refreshInterval	= 300

	srDHCPTable = {
		oid		= 1
		initInterval	= 4
		refreshInterval	= 300

		type		= active
		refreshMode	= async
		refreshService  = _services.sh
		refreshCommand  = utsdhcpsum
	}

	srIfTable = {
		oid		= 2
		initInterval	= 4
		refreshInterval	= 300

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_interfaces
	}
    }

    srDesktops = { [ use templates.sunray-models-d.sunrayMib.srDesktops ]
	oid		= 5
	initInterval	= 4
	refreshInterval	= 300


	srMonitoredDesktopTable = {
		oid		= 1
		initInterval	= 4
		refreshInterval	= 300

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_DTUMonitored

	    srMonitoredDesktopEntry = {
		consoleHint:tableCommands = unload addrow
		consoleHint:commandLabel(unload) = base.console.ConsoleGeneric:tableRow.deletePopup
		consoleHint:commandSpec(unload) = requestTableRowOperation %windowID snmp://%targetHost:%targetPort/mod/sunray/srDesktops/srMonitoredDesktopTable/srMonitoredDesktopEntry/srMonitoredRowStatus#%targetFragment unload
		consoleHint:commandLabel(addrow) = base.console.ConsoleGeneric:tableRow.addPopup
		consoleHint:commandSpec(addrow) = launchUniqueDialog %windowID .templates.tools.rowadder objectUrl=snmp://%targetHost:%targetPort/mod/sunray/srDesktops/srMonitoredDesktopTable/srMonitoredDesktopEntry#%targetFragment
		consoleHint:tableHeaderCommands = addrow
		globActions = refresh
		globService(refresh) = srMonitoredDesktopTable
		globCommand(refresh) = refreshValueAndTrap
		srMonitoredRowStatus = {
		    setrowService() = _internal
		    setrowActions(createAndGo) = add
		    setrowActions(createAndWait) = add
		    setrowCommand(add) = utp_addDTUMonitored %value %index %rowname %newvalue
		    setrowActions(destroy) = remove
		    setrowCommand(remove) = utp_deleteDTUMonitored %index %rowname
		}
		srMonitoredDesktopID = {
		    access = rw
		    consoleHint:editAccess = ro
		    setActions = update
		    setService(update) = _superior
		    setCommand(update) = updateInstances
		}
		srMonitoredDesktopIpAddress = {
		    defaultvalue = 0.0.0.0
		}
		srMonitoredDesktopOperStatus = {
		    defaultvalue = 2
		}
                srMonitoredDesktopPackets = {
		    defaultvalue = 0
		}
                srMonitoredDesktopLostPackets = {
		    defaultvalue = 0
		}
                srMonitoredDesktopLostPercent = {
		    defaultvalue = 0.0
		}
		srMonitoredDesktopLocation = {
		    defaultvalue = "Unknown"
		}
		srMonitoredDesktopOptionalData = {
		    defaultvalue = "Unknown"
		}
		srMonitoredDesktopServer = {
		    defaultvalue = "None"
		}
		srMonitoredDesktopModel = {
		    defaultvalue = "Unknown"
		}
		srMonitoredDesktopFWRevision = {
		    defaultvalue = "Unknown"
		}
	    }

	}

	srExceptionDesktopTable = {
		oid		= 2
		initInterval	= 4
		refreshInterval	= 300

		type		= active
		refreshMode	= sync
		refreshService  = _internal
		refreshCommand  = utp_DTUException

	}
    }

[ load sunray-d.def ]


