<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/Token.js"/>
                </ui:head>    
                <ui:body focus="f1:p1:_id20:back"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="tokens"/>
                        <ui:alert binding ="#{statusMessage.alert}"/>

                        <ui:breadcrumbs>
                            <ui:hyperlink text="#{msg.tokens_tab_label}"
                                          action="viewTokens"
                                          immediate="true"
                                          toolTip="#{msg.tokens_breadcrumb_tokens_tooltip}"/>
                            <ui:hyperlink text="#{tokenHandler.selectedToken.id}"
                                          action="viewTokenDetails"
                                          immediate="true"
                                          toolTip="#{msg.tokens_breadcrumb_token_name_tooltip}"/>
                            <ui:hyperlink text="#{msg.tokens_sessions_section}"/>
                        </ui:breadcrumbs>

                        <ui:contentPageTitle id="p1" 
                                             title="#{tokenHandler.selectedToken.id} - #{msg.tokens_sessions_section}"
                                             helpText="#{msg.tokens_sessions_pageHelpText}">
                            
                            <f:facet name="pageButtonsTop">
                                <ui:panelGroup> 
                                    <ui:button id="back"
                                               text="#{tokenHandler.backToLabel}"
                                               action="viewTokenDetails"
                                               immediate="true"
                                               toolTip="#{msg.tokens_back_button_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup>
                                    <ui:button id="back"
                                               text="#{tokenHandler.backToLabel}"
                                               action="viewTokenDetails"
                                               immediate="true"
                                               toolTip="#{msg.tokens_back_button_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet>

                            <ui:markup tag="div" styleClass="ConMgn">

                                <f:verbatim><br/><br/></f:verbatim>

                                <ui:table id="t1"
                                          title="#{msg.sessions_pageTitle}"
                                          selectMultipleButton="true"
                                          selectMultipleButtonOnClick="setTimeout('disableSessionActions()', 0)"
                                          deselectMultipleButton="true"
                                          deselectMultipleButtonOnClick="setTimeout('disableSessionActions()', 0)"
                                          clearSortButton="true"
                                          summary="#{msg.tokens_sessions_table_summary}"
                                          toolTip="#{msg.tokens_sessions_table_summary}">

                                    <ui:tableRowGroup headerText="#{msg.sessions_user_header}"
                                                      groupToggleButton="true"
                                                      collapsed="false"
                                                      emptyDataMsg="#{msg.sessions_no_user_sessions}"
                                                      sourceData="#{tokenSessionList.userSessions}"
                                                      sourceVar="sessionRowGroup"
                                                      binding="#{tokenSessionList.userSessionRowGroup}"
                                                      selected="#{tokenSessionList.userSessionSelectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select">
                                            <ui:checkbox id="select" 
                                                         onClick="setTimeout('initAllSessionRows();disableSessionActions()', 0)"
                                                         selected="#{tokenSessionList.userSessionSelectHelper.selected}"
                                                         selectedValue="#{tokenSessionList.userSessionSelectHelper.selectedValue}"
                                                         toolTip="#{msg.sessions_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>

                                        <!-- Session columns -->
                                        <jsp:directive.include file="../session/UserSessions.jsp"/>

                                    </ui:tableRowGroup>

                                    <ui:tableRowGroup headerText="#{msg.sessions_idle_header}"
                                                      groupToggleButton="true"  
                                                      collapsed="false"
                                                      emptyDataMsg="#{msg.sessions_no_idle_sessions}"
                                                      binding="#{tokenSessionList.idleSessionRowGroup}"
                                                      sourceData="#{tokenSessionList.idleSessions}"
                                                      sourceVar="sessionRowGroup"
                                                      selected="#{tokenSessionList.idleSessionSelectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select">
                                            <ui:checkbox id="select"
                                                         onClick="setTimeout('initAllSessionRows();disableSessionActions()', 0)"
                                                         selected="#{tokenSessionList.idleSessionSelectHelper.selected}"
                                                         selectedValue="#{tokenSessionList.idleSessionSelectHelper.selectedValue}"
                                                         toolTip="#{msg.sessions_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>

                                        <!-- Session columns -->
                                        <jsp:directive.include file="../session/IdleSessions.jsp"/>

                                    </ui:tableRowGroup>

                                    <f:facet name="actionsTop">
                                        <f:subview id="actionsTop">
                                            <ui:button id="terminate" 
                                                       disabled="true" 
                                                       text="#{msg.sessions_terminate_button}" 
                                                       onClick="#{tokenSessionList.terminateOnClick}"
                                                       action="#{tokenSessionList.terminate}"
                                                       toolTip="#{msg.sessions_terminate_button_tooltip}"
                                                       alt="#{msg.sessions_terminate_button_tooltip}"/>
                                        </f:subview>
                                    </f:facet>

                                </ui:table> 

                            </ui:markup>
                        </ui:contentPageTitle> 
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 


