
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// editable list functions
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


function EditableList(id) { 

    // Not a facet does not have "extra" editable list id.

    // child elements
    this.list = document.getElementById(id + "_list");

    // Bug 6338492 -
    //     ALL: If a component supports facets or children is must be a
    //      NamingContainer
    // Since EditableList has become a NamingContainer the id's for
    // the facet children are prefixed with the EditableList id
    // in addition to their own id, which also has the 
    // EditableList id, as has been the convention for facets. This introduces
    // a redundancy in the facet id so the add button now looks like
    //
    // "formid:editablelistid:editablelistid:editablelistid_addButton"
    //
    // It used to be "formid:editablelistid_addButton"
    // It would be better to encapsulate that knowledge in the
    // EditableList renderer as does FileChooser which has the
    // same problem but because the select elements are not
    // facets in EditableList they really do only have id's of the
    // form "formid:addremoveid_list". Note that 
    // in these examples the "id" parameter is "formid:editablelistid"
    //
    // Therefore for now, locate the additional prefix here as the
    // "facet" id. Assume that id never ends in ":" and if there is
    // no colon, id is the same as the component id.
    //
    var componentid = id;
    var colon_index = componentid.lastIndexOf(':');
    if (colon_index != -1) {
	componentid = id.substring(colon_index + 1);
    }
    var facetid = id + ":" + componentid;

    this.field = document.getElementById(facetid + "_field");
    this.addButton = document.getElementById(facetid + "_addButton"); 
    this.removeButton = document.getElementById(facetid + "_removeButton"); 
    
    // attach methods
    this.add = editableList_add;
    this.enableAdd = editableList_enableAdd;
    this.enableRemove = editableList_enableRemove;
    this.setAddDisabled = editableList_setAddDisabled;
    this.setRemoveDisabled = editableList_setRemoveDisabled; 

    this.updateButtons = editableList_updateButtons;
    this.setDisabled = editableList_setDisabled;
} 

function editableList_add(elementId) { 
    // Never try to control the disabling/enabling of the Add button.
    // See bug 6352949
    //
    //this.enableAdd(); 
    this.addButton.click();
}

function editableList_enableAdd() { 
    var disabled = (this.field.value == ""); 
    this.setAddDisabled(disabled); 
}

function editableList_setAddDisabled(disabled) { 
    if(this.addButton.setDisabled != null) { 
        this.addButton.setDisabled(disabled); 
    } 
    else { 
        this.addButton.disabled = disabled; 
    } 
}

function editableList_enableRemove() { 
    var disabled = (this.list.selectedIndex == -1); 
    this.setRemoveDisabled(disabled); 
} 

function editableList_setRemoveDisabled(disabled) { 
    if(this.removeButton.setDisabled != null) { 
        this.removeButton.setDisabled(disabled); 
    } 
    else { 
        this.removeButton.disabled = disabled; 
    } 
}

function editableList_updateButtons() { 
    // Never try to control the disabling/enabling of the Add button.
    // See bug 6352949
    //
    //this.enableAdd(); 
    this.enableRemove(); 
}

function editableList_setDisabled(disabled) { 

    if(this.addButton.setDisabled != null) { 
        this.addButton.setDisabled(disabled); 
    } 
    else { 
        this.addButton.disabled = disabled; 
    } 
    if(this.removeButton.setDisabled != null) { 
        this.removeButton.setDisabled(disabled); 
    } 
    else { 
        this.removeButton.disabled = disabled; 
    } 
    this.field.disabled = disabled; 
    this.list.disabled = disabled; 
}

