/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _UTAMGH_H
#define _UTAMGH_H

#pragma ident	"@(#)utamgh.h	1.4 05/02/11 SMI"

#ifdef _SCCSID
static char *_SCCSid_UTAMGH_H = "@(#)utamgh.h	1.4 05/02/11 SMI";
#endif	/* defined _SCCSID */

/*
 * Declarations for SRSS AMGH
 */

/*
 * The structures of the in and out parameters used by AMGH APIs.
 */

struct ut_amghargs {
	int  amghversion;       /* the version of the customer API */
	char *username;         /* the user name */
	char *token;            /* the token id */
	char *terminal_cid;     /* the canonical terminal id */
	char *terminal_ip_addr; /* the terminal ip address */
	char *insert_token;     /* the token id inserted */
	char *display;          /* the display number */
/* Future extensions to this struct must be added at the end */
};

struct ut_amghret {
	char **server_list;     /* the array of the servers */ 
	char *username;         /* the user name */
	char *errorstr;         /* the error message */
	int  chain_amgh;	/* Enable chained AMGH placements */
	int  use_firstserver;	/* Use firstServer prop as the host */
/* Future extensions to this struct must be added at the end */
};

/* 
 * Define the version of AMGH structures.
 * 
 * An API Implementation should check that the value of struct ut_amghargs
 * field amghversion is not less than the UT_AMGH_VERSION value it is
 * compiled with.
 */

#define UT_AMGH_VERSION (sizeof(struct ut_amghargs) + sizeof(struct ut_amghret))

/*
 * Utility interfaces for AMGH APIs
 */

int ut_amgh_get_server_list(const struct ut_amghargs *amghargs,
			    struct ut_amghret *amghret);

int ut_amgh_free_server_list(struct ut_amghret *amghret);

/*
 * Return values for AMGH API implementations
 */

/* Mapping succeeded. ut_amghret values contain results */
#define UT_AMGH_SUCCESS              0

/* SRSS ut_amghargs version is older than the version used in the implementation */
#define UT_AMGH_INCOMPATIBLE_VERSION 1

/* Permission error in implementation */
#define UT_AMGH_NO_PERMISSION        2

/* Implementation error accessing a mapping resource */
#define UT_AMGH_DB_ERROR             3

/* Implementation requires username. ut_amghargs username is NULL (PAM stack err) */
#define UT_AMGH_NULL_USERNAME        4

/* ut_amghargs username conflicts with implementation mapped username */ 
#define UT_AMGH_USERNAME_CONFLICT    5

/* Out of heap in implementation */
#define UT_AMGH_NOMEM		     6

/* Undifferentiated error in implementation */
#define UT_AMGH_ERROR                7

#endif	/* defined _UTAMGH_H */
