#!/bin/sh
#
# vi:set ts=40 sw=2:
#

cmd=acroread
prod="Acrobat Reader"
ver=2.1
install_dir=REPLACE_ME

#
# Prepend a colon seperated environment variable
# $1 string to be prepended
# $2 environment variable
#
prepend()
{
  if [ -z "$2" -o "$2" = "$1" ] ; then
    echo "$1"
  else
    first="`expr "$2" : '\([^:]*\):'`"
    if [ "$first" = "$1" ] ; then
      echo "$2"
    else
      echo "${1}:${2}"
    fi
  fi
}


#
# Tests the version file in an installation directory.
#
test_install_dir()
{
  if [ "$1" -a -f "$1/AcroVersion" ] \
  && [ "`cat $1/AcroVersion 2>/dev/null`" = "$ver" ] ; then
    return 0
  else
    return 1
  fi
}


#
# Get the current working directory.
# Try to avoid automounter directories by checking
# if $HOME or $PWD is the same directory as pwd,
# and removing the automount directory component.
#
cwd="`pwd 2> /dev/null`"
if [ -z "$cwd" -o ! -d "$cwd" ] ; then
  echo "ERROR: Cannot determine current directory."
  exit 1
fi

if [ "$HOME" -a -d "$HOME" ] && [ "`cd / ; cd "$HOME" ; pwd`" = "$cwd" ] ; then
  cwd="$HOME"
elif [ "$PWD" -a -d "$PWD" ] && [ "`cd / ; cd "$PWD" ; pwd`" = "$cwd" ] ; then
  cwd="$PWD"
fi

if [ "$cwd" != / -a "${AUTOMOUNT_DIR=/tmp_mnt}" ] ; then
  tmp="`expr "$cwd" : "$AUTOMOUNT_DIR"'\(.*\)'`"
  if [ "$tmp" -a -d "$tmp" ] ; then
    if [ "`cd / ; cd "$tmp" ; pwd`" = "`pwd`" ] ; then
      cwd="$tmp"
    fi
  fi
fi

PWD="$cwd"
export PWD


#
# Setup ACRO_ARG0 to this script
#
arg0="$0"
if [ "$arg0" ] ; then
  case "$arg0" in
     /*) ;;
    ./*) arg0="$cwd/`expr "$arg0" : '\./\(.*\)'`" ;;
      *) arg0="$cwd/$arg0" ;;
  esac

  ACRO_ARG0="$arg0"
  export ACRO_ARG0
fi


#
# Try to find the installation directory
#
if ( test_install_dir "$install_dir" ) ; then
  ACRO_INSTALL_DIR="$install_dir"
  export ACRO_INSTALL_DIR
else
  script="$arg0"
  while [ "$script" ] ; do
    install_dir="`dirname "$script"`"
    if ( test_install_dir "$install_dir" ) ; then
      ACRO_INSTALL_DIR="$install_dir"
      export ACRO_INSTALL_DIR
      break
    fi

    install_dir="`dirname "$install_dir"`"
    if ( test_install_dir "$install_dir" ) ; then
      ACRO_INSTALL_DIR="$install_dir"
      export ACRO_INSTALL_DIR
      break
    fi

    if [ -h "$script" ] ; then
      new_script=`ls -l "$script" | sed 's/^.*-> *\(.*\) *$/\1/'`
      if [ "$new_script" -a "`expr "$new_script" : '/.*'`" = 0 ] ; then
        new_script="`dirname "$script"`/$new_script"
      fi
      script="$new_script"
    else
      break
    fi
  done

  if ( test_install_dir "$ACRO_INSTALL_DIR" ) ; then
    :
  elif ( test_install_dir "$ACRO_HOME" ) ; then
    ACRO_INSTALL_DIR="$ACRO_HOME"
    export ACRO_INSTALL_DIR
  else
    echo "ERROR: Cannot find installation directory."
    exit 1
  fi
fi


#
# setup the configuration from uname
#
os_name=`uname -s`
os_release=`uname -r`

case "$os_name" in
  SunOS)
    case "$os_release" in
      4.1.3*|4.1.4*)
        ACRO_CONFIG=sparcsun
        export ACRO_CONFIG
        ;;
      5.*)
        ACRO_CONFIG=sparcsolaris
        export ACRO_CONFIG
        ;;
    esac
    ;;
  HP-UX)
    ACRO_CONFIG=hppahpux
    export ACRO_CONFIG
    ;;
esac

if [ -z "$ACRO_CONFIG" ] ; then
  echo "The OS named $os_name version $os_release is currently not supported."
  echo "Try running on a supported platform and connecting to your display."
  echo "Supported platforms include the following:"
  echo "  SPARC/SunOS version 4.1.3 or 4.1.4"
  echo "  SPARC/Solaris version 2.x"
  echo "  HP/HP-UX version 9.0.x and 10.x"
  exit 1
fi


#
# XXX No LANG
#


#
# Setup XKEYSYMDB
#
if [ -z "$XKEYSYMDB" -o ! -f "$XKEYSYMDB" ] ; then
  if [ -f "$ACRO_INSTALL_DIR/$ACRO_CONFIG/lib/XKeysymDB" ] ; then
    XKEYSYMDB="$ACRO_INSTALL_DIR/$ACRO_CONFIG/lib/XKeysymDB"
    export XKEYSYMDB
  elif [ -f "$ACRO_INSTALL_DIR/XKeysymDB" ] ; then
    XKEYSYMDB="$ACRO_INSTALL_DIR/XKeysymDB"
    export XKEYSYMDB
  fi
fi


#
# Prepend XFILESEARCHPATH
#
XFILESEARCHPATH="`prepend "$ACRO_INSTALL_DIR/$ACRO_CONFIG/%T/%N%S" "$XFILESEARCHPATH"`"
export XFILESEARCHPATH


#
# Setup configuration specific environment variables
#
case "$ACRO_CONFIG" in
  sparcsun)
    LD_LIBRARY_PATH="`prepend "$ACRO_INSTALL_DIR/$ACRO_CONFIG/lib" "$LD_LIBRARY_PATH"`"
    export LD_LIBRARY_PATH
    XNLSPATH="$ACRO_INSTALL_DIR/$ACRO_CONFIG/lib/nls"
    export XNLSPATH
    ;;
  sparcsolaris)
    LD_LIBRARY_PATH="`prepend "$ACRO_INSTALL_DIR/$ACRO_CONFIG/lib" "$LD_LIBRARY_PATH"`"
    export LD_LIBRARY_PATH
    if [ -z "$LC_CTYPE" ] ; then
      LC_CTYPE="iso_8859_1"
      export LC_CTYPE
    fi
    ;;
  hppahpux)
    SHLIB_PATH="`prepend "$ACRO_INSTALL_DIR/$ACRO_CONFIG/lib" "$SHLIB_PATH"`"
    export SHLIB_PATH
    ;;
esac


#
# Set the command.  Process any debug flags and exec.
#
ACRO_EXEC_CMD="$ACRO_INSTALL_DIR/$ACRO_CONFIG/bin/$cmd"

if [ "$1" = "-DEBUG" ] ; then
  if [ $# = 1 ] ; then
    export ACRO_EXEC_CMD
    exec "$SHELL"
  else
    shift
    exec ${1+"$@"} "$ACRO_EXEC_CMD"
  fi
fi

if [ -f "$ACRO_EXEC_CMD" ] ; then
  exec "$ACRO_EXEC_CMD" ${1+"$@"}
else
  echo "ERROR: $prod not installed for this configuration, \"$ACRO_CONFIG\"."
  exit 1
fi

